/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.odf;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map.Entry;

import org.apache.commons.lang.mutable.MutableInt;

public class OfficeStyles {

	public OfficeStyles() {
	}

	// HashMap<style family name, HashMap<style name, style>> ...
	private HashMap<String, HashMap<String, OfficeStyleBase>> _defaultStyleFamilies;
	private HashMap<String, HashMap<String, OfficeStyleBase>> _officeStyleFamilies;
	private HashMap<String, HashMap<String, OfficeStyleBase>> _autoStyleFamilies;

	public class AllStyleIterator implements Iterator<Entry<String, OfficeStyleBase>> {

		Iterator<Entry<String, OfficeStyleBase>> defaultStyleIter;
		Iterator<Entry<String, OfficeStyleBase>> officeStyleIter;
		Iterator<Entry<String, OfficeStyleBase>> automaticStyleIter;

	    public AllStyleIterator(String family) {

	    	final HashMap<String, OfficeStyleBase> defaultStyles = getDefaultStyles(family, false);
    		defaultStyleIter = defaultStyles!=null ? defaultStyles.entrySet().iterator() : null;

	    	final HashMap<String, OfficeStyleBase> officeStyles = getOfficeStyles(family, false);
	    	officeStyleIter = officeStyles!=null ? officeStyles.entrySet().iterator() : null;

	    	final HashMap<String, OfficeStyleBase> automaticStyles = getAutomaticStyles(family, false);
	    	automaticStyleIter = automaticStyles!=null ? automaticStyles.entrySet().iterator() : null;
	    }

	    @Override
	    public boolean hasNext() {
	        return (defaultStyleIter!=null && defaultStyleIter.hasNext()) || (officeStyleIter!=null && officeStyleIter.hasNext()) || (automaticStyleIter!=null && automaticStyleIter.hasNext());
	    }

	    @Override
	    public Entry<String, OfficeStyleBase> next() {
	    	if(automaticStyleIter!=null && automaticStyleIter.hasNext()) {
	    		return automaticStyleIter.next();
	    	}
	    	if(officeStyleIter!=null && officeStyleIter.hasNext()) {
	    		return officeStyleIter.next();
	    	}
	    	return defaultStyleIter.next();
	    }

	    @Override
	    public void remove() {
	       throw new UnsupportedOperationException();
	    }
	}	
	
	// HashSet<style name, count>
	private HashMap<String, HashMap<String, MutableInt>> _usedStyleFamilies;

	public HashMap<String, HashMap<String, OfficeStyleBase>> getOfficeStyleFamilies() {
		if(_officeStyleFamilies==null) {
			_officeStyleFamilies = new HashMap<String, HashMap<String, OfficeStyleBase>>();
		}
		return _officeStyleFamilies;
	}

	protected HashMap<String, HashMap<String, OfficeStyleBase>> getDefaultStyleFamilies() {
		if(_defaultStyleFamilies==null) {
			_defaultStyleFamilies = new HashMap<String, HashMap<String, OfficeStyleBase>>();
		}
		return _defaultStyleFamilies;
	}

	protected HashMap<String, HashMap<String, OfficeStyleBase>> getAutomaticStyleFamilies() {
		if(_autoStyleFamilies==null) {
			_autoStyleFamilies = new HashMap<String, HashMap<String, OfficeStyleBase>>();
		}
		return _autoStyleFamilies;
	}

	public HashMap<String, OfficeStyleBase> getOfficeStyles(String family, boolean forceCreate) {
		final HashMap<String, HashMap<String, OfficeStyleBase>> styleFamilyMap = getOfficeStyleFamilies();
		HashMap<String, OfficeStyleBase> styleMap = styleFamilyMap.get(family);
		if(styleMap==null&&forceCreate) {
			styleMap = new HashMap<String, OfficeStyleBase>();
			styleFamilyMap.put(family, styleMap);
		}
		return styleMap;
	}

	public HashMap<String, OfficeStyleBase> getDefaultStyles(String family, boolean forceCreate) {
		final HashMap<String, HashMap<String, OfficeStyleBase>> styleFamilyMap = getDefaultStyleFamilies();
		HashMap<String, OfficeStyleBase> styleMap = styleFamilyMap.get(family);
		if(styleMap==null&&forceCreate) {
			styleMap = new HashMap<String, OfficeStyleBase>();
			styleFamilyMap.put(family, styleMap);
		}
		return styleMap;
	}

	public HashMap<String, OfficeStyleBase> getAutomaticStyles(String family, boolean forceCreate) {
		final HashMap<String, HashMap<String, OfficeStyleBase>> styleFamilyMap = getAutomaticStyleFamilies();
		HashMap<String, OfficeStyleBase> styleMap = styleFamilyMap.get(family);
		if(styleMap==null&&forceCreate) {
			styleMap = new HashMap<String, OfficeStyleBase>();
			styleFamilyMap.put(family, styleMap);
		}
		return styleMap;
	}

	public OfficeStyleBase getStyle(String family, String name) {
		OfficeStyleBase style = getAutomaticStyle(family, name);
		if(style==null) {
			style = getOfficeStyle(family, name);
			if(style==null) {
				style = getDefaultStyle(family, name);
			}
		}
		return style;
	}

	public Iterator<Entry<String, OfficeStyleBase>> getAllStyleIterator(String family) {
		return new AllStyleIterator(family);
	}

	public OfficeStyleBase getOfficeStyle(String family, String name) {
		final HashMap<String, OfficeStyleBase> officeStyles = getOfficeStyles(family, false);
		return officeStyles!=null ? officeStyles.get(name) : null;
	}

	public OfficeStyleBase getDefaultStyle(String family, String name) {
		final HashMap<String, OfficeStyleBase> officeDefaultStyles = getDefaultStyles(family, false);
		return officeDefaultStyles!=null ? officeDefaultStyles.get(name) : null;
	}

	public OfficeStyleBase getAutomaticStyle(String family, String name) {
		final HashMap<String, OfficeStyleBase> officeAutomaticStyles = getAutomaticStyles(family, false);
		return officeAutomaticStyles!=null ? officeAutomaticStyles.get(name) : null;
	}

	public void addOfficeStyle(OfficeStyleBase officeStyle) {
		getOfficeStyles(officeStyle.getFamily(), true).put(officeStyle.getName(), officeStyle);
	}

	public void addDefaultStyle(OfficeStyleBase officeDefaultStyle) {
		getDefaultStyles(officeDefaultStyle.getFamily(), true).put(officeDefaultStyle.getName(), officeDefaultStyle);
	}

	public void addAutomaticStyle(OfficeStyleBase officeAutomaticStyle) {
		getAutomaticStyles(officeAutomaticStyle.getFamily(), true).put(officeAutomaticStyle.getName(), officeAutomaticStyle);
	}

	private HashMap<String, MutableInt> getUsedStyles(String family) {
		if(_usedStyleFamilies==null) {
			_usedStyleFamilies = new HashMap<String, HashMap<String, MutableInt>>();
		}
		HashMap<String, MutableInt> _usedStyle = _usedStyleFamilies.get(family);
		if(_usedStyle==null) {
			_usedStyle = new HashMap<String, MutableInt>();
			_usedStyleFamilies.put(family, _usedStyle);
		}
		return _usedStyle;
	}

	private MutableInt getUsedStyle(String family, String name) {
		final HashMap<String, MutableInt> usedStyles = getUsedStyles(family);
		MutableInt count = usedStyles.get(name);
		if(count==null) {
			count = new MutableInt();
			usedStyles.put(name, count);
		}
		return count;
	}

	public int getStyleUsage(String family, String name) {
		return getUsedStyle(family, name).intValue();
	}

	public void incStyleUsage(String family, String name) {
		getUsedStyle(family, name).increment();
	}

	public void decStyleUsage(String family, String name) {
		getUsedStyle(family, name).decrement();
	}

	private <Y extends OfficeStyleBase> void addStyleSA(HashMap<String, HashMap<String, Y>> stylesMap) {

		HashMap<String, Y> s = (HashMap<String, Y>)stylesMap.get("kk");
	}
}
