/*
 *  Copyright 2007-2008, Plutext Pty Ltd.
 *
 *  This file is part of docx4j.

    docx4j is licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.

    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

 */
package org.docx4j.openpackaging.parts;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.xpath.XPath;

import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.jaxb.NamespacePrefixMappings;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.utils.XPathFactoryUtil;
import org.docx4j.w15.CTPeople;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;


public class PeoplePart extends JaxbXmlPart<CTPeople> {

	private static Logger log = LoggerFactory.getLogger(PeoplePart.class);

	private static XPath xPath = XPathFactoryUtil.newXPath();

	 /**
	 * @throws InvalidFormatException
	 */
	public PeoplePart(PartName partName) throws InvalidFormatException {
		super(partName);
		init();
	}

	public PeoplePart() throws InvalidFormatException {
		super(new PartName("/word/people.xml"));
		init();
	}

	public void init() {
		// Used if this Part is added to [Content_Types].xml
		setContentType(new  org.docx4j.openpackaging.contenttype.ContentType(
				org.docx4j.openpackaging.contenttype.ContentTypes.WORDPROCESSINGML_PEOPLE));

		// Used when this Part is added to a rels
//		setRelationshipType("http://schemas.microsoft.com/office/word/2012/wordml");
	setRelationshipType("http://schemas.microsoft.com/office/2011/relationships/people");


		setJAXBContext(Context.getJc());
	}

    /**
     * Unmarshal XML data from the specified InputStream and return the
     * resulting content tree.  Validation event location information may
     * be incomplete when using this form of the unmarshal API.
     *
     * <p>
     * Implements <a href="#unmarshalGlobal">Unmarshal Global Root Element</a>.
     *
     * @param is the InputStream to unmarshal XML data from
     * @return the newly created root object of the java content tree
     *
     * @throws JAXBException
     *     If any unexpected errors occur while unmarshalling
     */
	@Override
    public CTPeople unmarshal( java.io.InputStream is ) throws JAXBException {

		try {

			setJAXBContext(jc);

			log.debug("unmarshalling " + this.getClass().getName());

			jaxbElement = ((JAXBElement<CTPeople>) XmlUtils.unmarshal(is, jc, new org.docx4j.jaxb.JaxbValidationEventHandler())).getValue();

		} catch (Exception e ) {
			e.printStackTrace();
		}

		return jaxbElement;

    }

	public String xpathGetString(String xpathString, String prefixMappings)  throws Docx4JException {

		Document doc = XmlUtils.marshaltoW3CDomDocument(
				getJaxbElement(), Context.getJc() );

		try {
			String result;
			synchronized(xPath) {
				getNamespaceContext().registerPrefixMappings(prefixMappings);
				result = xPath.evaluate(xpathString, doc );
			}
			log.debug(xpathString + " ---> " + result);
			return result;
		} catch (Exception e) {
			throw new Docx4JException("Problems evaluating xpath '" + xpathString + "'", e);
		}
	}
	private NamespacePrefixMappings nsContext;
	private NamespacePrefixMappings getNamespaceContext() {
		if (nsContext==null) {
			nsContext = new NamespacePrefixMappings();
			xPath.setNamespaceContext(nsContext);
		}
		return nsContext;
	}


}


