package com.openexchange.office.doc.imexport;

import org.json.JSONException;
import org.json.JSONObject;

import com.openexchange.office.DocumentProperties;
import com.openexchange.office.tools.memory.MemoryObserver;
import com.openexchange.office.tools.system.SystemInfoHelper;

public class ImporterPropertyHelper {

    /**
     * Sets the importer properties regarding memory information to prevent
     * out-of-memory exceptions, while loading big documents.
     *
     * @param importerProps The json object that is used for importer properties.
     *
     * @return The maximum memory to be used by the import filter.
     */
    public static long setMemoryImporterProperties(final JSONObject importerProps) {
        long maxHeapSizeForFilter = 0;

        final SystemInfoHelper.MemoryInfo memInfo = SystemInfoHelper.getMemoryInfo();
        if (null != memInfo) {
            try {
                // The maximal heap size for the filter to load the document should not exceed
                // half of the maximal heap size of the JVM. The filter uses the value to
                // prevent loading documents that need a huge amount of heap memory.
                maxHeapSizeForFilter = memInfo.maxHeapSize / 2;
                importerProps.put("maxMemoryUsage", maxHeapSizeForFilter);

                MemoryObserver memObserver = MemoryObserver.getMemoryObserver();

                importerProps.put(DocumentProperties.PROP_MEMORYOBSERVER, memObserver);
                importerProps.put(DocumentProperties.PROP_MAX_MEMORY_USAGE, maxHeapSizeForFilter);
            } catch (JSONException e) {
                //LOG.error("Exception caught while setting up importer memory properties", e);
            }
        }

        return maxHeapSizeForFilter;
    }

}
