package com.openexchange.office.doc.imexport;

import com.openexchange.office.IExporter;
import com.openexchange.office.IImporter;
import com.openexchange.office.tools.doc.DocumentFormat;
import com.openexchange.office.tools.files.DocFileHelper;
import com.openexchange.server.ServiceLookup;


public class ImExportHelper {

    /**
     * Provides the importer for the current document.
     *
     * @return The Importer for the current file helper object
     */
    public static IImporter getImporter(final ServiceLookup services, final DocFileHelper fileHelper) {
        IImporter importer = null;

        if (null != fileHelper) {
            importer = ImExportHelper.getImporterService(services, fileHelper.getDocumentFormat());
        }

        return importer;
    }

    /**
     * Provides the exporter for the current document depending on the format.
     *
     * @return The Exporter for the current file helper object
     */
    public static IExporter getExporter(final ServiceLookup services, final DocFileHelper fileHelper) {
        IExporter exporter = null;

        if (null != fileHelper) {
            exporter = ImExportHelper.getExporterService(services, fileHelper.getDocumentFormat());
        }

        return exporter;
    }

    public static IImporter getImporterService(final ServiceLookup services, final DocumentFormat documentFormat) {
        IImporter importer = null;

        switch (documentFormat) {
            case DOCX: {
                importer = services.getService(com.openexchange.office.ooxml.docx.Importer.class);
                break;
            }

            case PPTX: {
                importer = services.getService(com.openexchange.office.ooxml.pptx.Importer.class);
                break;
            }

            case XLSX: {
                importer = services.getService(com.openexchange.office.ooxml.xlsx.Importer.class);
                break;
            }

            case ODT:
            case ODS: {
                importer = services.getService(com.openexchange.office.odf.Importer.class);
                break;
            }

            case NONE:
            case ODG:
            case ODP:
            default: {
                break;
            }
        }

        return importer;
    }

    public static IExporter getExporterService(final ServiceLookup services, final DocumentFormat documentFormat) {
        IExporter exporter = null;

        switch (documentFormat) {
            case DOCX: {
                exporter = services.getService(com.openexchange.office.ooxml.docx.Exporter.class);
                break;
            }

            case PPTX: {
                exporter = services.getService(com.openexchange.office.ooxml.pptx.Exporter.class);
                break;
            }

            case XLSX: {
                exporter = services.getService(com.openexchange.office.ooxml.xlsx.Exporter.class);
                break;
            }

            case ODT:
            case ODS: {
                exporter = services.getService(com.openexchange.office.odf.Exporter.class);
                break;
            }

            case NONE:
            case ODG:
            case ODP:
            default: {
                break;
            }
        }

        return exporter;
    }
}
