package com.openexchange.office.tools.htmldoc;

import java.util.concurrent.atomic.AtomicInteger;

import org.json.JSONArray;
import org.json.JSONObject;

public class Drawing
        extends NodeHolder
{

    private static final String  CONTENT_START       = "<div contenteditable='false' ";
    private static final String  START               = " class='drawing inline' style='width: 50px; height: 50px; border: none;'>";
    private static final String  DRAWING_CONTENT     = "<div class='content'>";
    private static final String  PLACEHOLDER_CONTENT = "<div class='content placeholder'>";
    private static final String  GROUP_CONTENT       = "<div class='content groupcontent'>";
    private static final String  SHAPE_CONTENT       = "<div class='content textframecontent'><div class='textframe' contenteditable='true'>";
    private static final String  CONTENT_IMAGE_START = "<img src='";
    private static final String  CONTENT_IMAGE_END   = "' style='left: 0px; top: 0px; width: 50px; height: 50px;'>";
    private static final String  DIV_END             = "</div>";

    // ///////////////////////////////////////////////////////////

    private static AtomicInteger idCounter           = new AtomicInteger();

    // ///////////////////////////////////////////////////////////

    private final String         id;
    private final String         type;
    private final String         fileVersion;
    private final String         folderId;
    private final String         fileId;

    private boolean              emptySpans          = true;                                                                                                                          ;
    private boolean              havePlaceholder     = true;

    private String               src                 = null;

    public Drawing(
            String type, String fileId, String folderId, String fileVersion)
        throws Exception
    {
        this.fileId = fileId;
        this.folderId = folderId;
        this.fileVersion = fileVersion;
        this.type = type;
        this.id = "frame" + idCounter.getAndIncrement();

    }

    @Override
    public boolean setAttribute(
        JSONArray start,
        JSONArray end,
        JSONObject assignedAttrs)
        throws Exception
    {
        super.setAttribute(start, end, assignedAttrs);
        
        if (start.length() == 0) {
	        // type must be checked now, because we support more than image
	        if ((null != type) && (type.equalsIgnoreCase("image")))
	        {
	            JSONObject attrs = getAttribute();
	            if (attrs != null)
	            {
	                JSONObject drawing = attrs.getJSONObject("image");
	                String imageUrl = drawing.getString("imageUrl");
	                if (imageUrl.contains("://"))
	                {
	                    src = imageUrl;
	                }
	                else
	                {
	                    src = "/appsuite/api/oxodocumentfilter?session=_REPLACE_SESSION_ID_&id=" + fileId + "&folder_id=" + folderId + "&action=getfile&get_filename=" + imageUrl + "&version=" + fileVersion + "&filename=drawing";
	                    // /appsuite/api/oxodocumentfilter?session=a8d5e5d2454447eebf1419a19fb72dd1&uid=1405331293709.2453&id=500&folder_id=103&filename=kleinertest.docx&version=16&action=getfile&get_filename=word/media/uid267d2855268d.jpg
	                }
	            }
	        }      
            return false;        	
        } else {
            return true;
        }

    }

    @Override
    public boolean appendContent(
        StringBuilder document)
        throws Exception
    {

        if (emptySpans)
        {
            GenDocHelper.addEmptySpan(document);
        }

        document.append(CONTENT_START);

        final JSONObject adapter = new JSONObject();

        adapter.put("type", this.type);
        adapter.put("uid", id);
        adapter.put("model", JSONObject.NULL);

        adapter.put("attributes", getAttribute());

        document.append(" jquerydata='");
        document.append(GenDocHelper.escapeSingleQuote(adapter.toString()));
        document.append("' data-type='");
        document.append(type);
        document.append("' ");

        // System.out.println("Drawing.appendContent() " + this.type);

        String content = START;
        document.append(content);
        // System.out.println("Drawing.appendContent() " + content);
        if (type.equalsIgnoreCase("image"))
        {

            document.append(DRAWING_CONTENT);

            String image = CONTENT_IMAGE_START;
            image += src;
            image += CONTENT_IMAGE_END;

            document.append(image);
        }
        else if (type.equalsIgnoreCase("group"))
        {
            document.append(GROUP_CONTENT);
            super.appendContent(document);
        }
        else if (type.equalsIgnoreCase("shape"))
        {
            if (havePlaceholder)
            {
                document.append(PLACEHOLDER_CONTENT);
                super.appendContent(document);
            }
            else
            {
                document.append(SHAPE_CONTENT);
                super.appendContent(document);

                document.append(DIV_END);
            }
        }
        else
        {
            //default behavior for types we cant handle yet (chart)
            document.append(PLACEHOLDER_CONTENT);
            super.appendContent(document);
        }

        document.append(DIV_END);
        document.append(DIV_END);

        if (emptySpans)
        {
            GenDocHelper.addEmptySpan(document);
        }
        return false;
    }

    @Override
    public boolean needsEmptySpan()
    {
        return false;
    }

    @Override
    public int getTextLength()
    {
        return 1;
    }

    @Override
    public void insert(
        JSONArray start,
        INode newChild)
        throws Exception
    {
        // System.out.println("Drawing.insert() " + start + " " + newChild.getClass());
        if (start.length() == 1)
        {
            if (newChild instanceof Drawing)
            {
                ((Drawing) newChild).disableEmptySpans();
            }
            else if ((newChild instanceof Paragraph) || (newChild instanceof Table))
            {
                havePlaceholder = false;
            }
        }
        super.insert(start, newChild);
    }

    public void disableEmptySpans()
    {
        this.emptySpans = false;
    }
}
