/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.ooxml.pptx.components;

import org.docx4j.IndexedNode;
import org.docx4j.IndexedNodeList;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.parts.PresentationML.SlideLayoutPart;
import org.docx4j.openpackaging.parts.PresentationML.SlideMasterPart;
import org.docx4j.openpackaging.parts.PresentationML.SlidePart;
import org.docx4j.wml.ContentAccessor;
import org.json.JSONObject;
import org.jvnet.jaxb2_commons.ppp.Child;

import com.openexchange.office.ooxml.OperationDocument;
import com.openexchange.office.ooxml.components.Component;
import com.openexchange.office.ooxml.components.ComponentContext;
import com.openexchange.office.ooxml.operations.CreateOperationHelper;

public class RootComponent extends PptxComponent {

	final private OperationDocument operationDocument;

	public RootComponent(OperationDocument operationDocument) {
		super(null, new IndexedNode<Object>((ContentAccessor)operationDocument.getContextPart()), 0);
        this.operationDocument = operationDocument;
        final ContentAccessor contentAccessor = (ContentAccessor)operationDocument.getContextPart();
        if((contentAccessor instanceof SlideMasterPart) || (contentAccessor instanceof SlideLayoutPart)) {
        	// adding dummy content as the first json address is always 0 and to be ignored
        	this.setNode(new IndexedNode<Object>(new DummyContentAccessor(contentAccessor)));
        }
    }
    private class DummyContentAccessor implements ContentAccessor {

    	final IndexedNodeList<Object> content;

    	public DummyContentAccessor(ContentAccessor c) {
    		content = new IndexedNodeList<Object>();
    		content.add(c);
    	}
		@Override
		public IndexedNodeList<Object> getContent() {
			return content;
		}
    }

    @Override
    public Component getNextComponent() {
        return null;
    }
    @Override
    public Component getNextChildComponent(ComponentContext previousChildContext, Component previousChildComponent) {
        final int index = previousChildContext!=null?previousChildContext.getNode().getIndex()+1:0;
        final int nextComponentNumber = previousChildComponent!=null?previousChildComponent.getNextComponentNumber():0;

        Component nextComponent = null;
        final IndexedNode<Object> rootNode = getNode();
        final IndexedNodeList<Object> nodeList = (IndexedNodeList<Object>)((ContentAccessor)rootNode.getData()).getContent();
        for(int i=index; nextComponent==null&&i<nodeList.size(); i++) {
            final IndexedNode<Object> childNode = nodeList.getNode(i);
            final Object o = getContentModel(childNode, rootNode.getData());
            if(o instanceof SlidePart) {
            	operationDocument.setContextPart((SlidePart)o);
            	nextComponent = new SlideComponent(this, childNode, nextComponentNumber);
            }
            else if(o instanceof SlideMasterPart) {
            	operationDocument.setContextPart((SlideMasterPart)o);
            	nextComponent = new SlideComponent(this, childNode, nextComponentNumber);
            }
            else if(o instanceof SlideLayoutPart) {
            	operationDocument.setContextPart((SlideLayoutPart)o);
            	nextComponent = new SlideComponent(this, childNode, nextComponentNumber);
            }
        }
        return nextComponent;
    }
    @Override
    public Component insertChildComponent(ComponentContext parentContext, IndexedNode<Object> contextNode, int number, Component child, Type type) {

        IndexedNodeList<Object> indexedNodeList;
        IndexedNode<Object> referenceNode = null;
        if(child!=null&&child.getComponentNumber()==number) {
            final ComponentContext contextChild = child.getContextChild(null);
            indexedNodeList = (IndexedNodeList<Object>)((ContentAccessor)contextChild.getParentContext().getNode().getData()).getContent();
            referenceNode = contextChild.getNode();
        }
        else {
            indexedNodeList = (IndexedNodeList<Object>)((ContentAccessor)contextNode.getData()).getContent();
        }

        switch(type) {
            case PARAGRAPH : {
                final Child newChild = Context.getDmlObjectFactory().createCTTextParagraph();
                newChild.setParent(contextNode.getData());
                final IndexedNode<Object> newChildNode = new IndexedNode<Object>(newChild);
                indexedNodeList.addNode(referenceNode, newChildNode, true);
                return new ParagraphComponent(parentContext, newChildNode, number);
            }
            default : {
                throw new UnsupportedOperationException();
            }
        }
    }
    @Override
    public void applyAttrsFromJSON(OperationDocument operationDocument, JSONObject attrs) {

    }
    @Override
    public JSONObject createJSONAttrs(CreateOperationHelper operationDocument, JSONObject attrs) {
        return attrs;
    }
}
