package com.openexchange.office.json.tools.fields;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

import org.json.JSONException;
import org.json.JSONObject;

public class FieldsParserSheets
        implements
        FieldsParser
{
    private String param;

    public FieldsParserSheets(
            String param)
        throws Exception
    {
        this.param = param;
    }

    @Override
    public Map<String, Object> getFields()
        throws Exception
    {
        Map<String, Object> fields = new HashMap<String, Object>();
        
        try
        {
            Map<String, Object> sheets = new JSONObject(param).asMap();        

            for (Entry<String, Object> sheet : sheets.entrySet())
            {
                Map<String, Object> entries = (Map<String, Object>) sheet.getValue();
                for (Entry<String, Object> entry : entries.entrySet())
                {
                    Map<String, Object> json = (Map<String, Object>) entry.getValue();

                    fields.put(sheet.getKey() + "!" + entry.getKey(), new JSONObject(json));
                }
            }
        }
        catch (JSONException e)
        {
            String[] fieldsource = param.split(";");
            for (int i = 0; i < fieldsource.length; i += 2)
            {
                fields.put(fieldsource[i], fieldsource[i + 1]);
            }
        }
        return fields;

    }

    /*
     * {sheet1: { B2: { type: 'Text'. value:'Prospecting' }, C2: { type: 'currency' value: '1234,45 EUR' } } }
     */
}
