package com.openexchange.office.json.tools.fields;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FieldsHandlerSheet
        implements
        FieldsHandler
{
    static final Map<String, String> TYPES;

    static
    {
        TYPES = new HashMap<String, String>();

        TYPES.put("text", "@");
        TYPES.put("currency", "[$$-409]#,##0");
        TYPES.put("date", "DD/MM/YYYY");
        TYPES.put("number", "#,##0.00");
    }

    @Override
    public JSONArray getMergeOperations(
        JSONArray ops,
        Map<String, Object> fields)
            throws Exception
    {

        int autostyleIndex = 0;

        Map<String, Integer> sheetMap = new HashMap<String, Integer>();

        for (int i = 0; i < ops.length(); i++)
        {
            JSONObject op = ops.getJSONObject(i);
            String name = op.getString("name");

            if (name.equals("insertSheet"))
            {
                sheetMap.put(op.getString("sheetName"), Integer.decode(op.getString("sheet")));
            }
            else if (name.equals("insertStyleSheet") && op.optBoolean("auto", false))
            {
                int autoStyleId = Integer.parseInt(op.getString("styleId").substring(1));
                autostyleIndex = Math.max(autostyleIndex, autoStyleId);
            }
        }

        JSONArray newOps = new JSONArray();
        for (Entry<String, Object> field : fields.entrySet())
        {
            JSONObject newOp = new JSONObject();

            Integer sheet = sheetMap.get(field.getKey().split("!")[0]);
            JSONArray cellRef = createCellRef(field.getKey().split("!")[1]);

            newOp.put("name", "fillCellRange");
            newOp.put("sheet", sheet);
            newOp.put("start", cellRef);
            // newOp.put("parse", "de_DE");

            JSONObject content = null;

            try
            {
                content = new JSONObject(field.getValue().toString());
                newOp.put("value", content.get("value"));

            }
            catch (JSONException e)
            {
                newOp.put("value", field.getValue().toString());
            }

            if (null != content)
            {
                String type = content.optString("type");
                
                if (StringUtils.equals(type, "number") || StringUtils.equals(type, "currency")) {
                    Object value = content.get("value");
                    if (value instanceof String) {
                        String valueString = (String) value;
                        int lastKomma = valueString.lastIndexOf(",");
                        int lastPoint = valueString.lastIndexOf(".");
                        if (lastKomma > lastPoint) {
                            valueString = valueString.substring(0, lastPoint) + valueString.substring(lastPoint+1, lastKomma) + '.' +   valueString.substring(lastKomma+1, valueString.length());
                            lastPoint = valueString.lastIndexOf(".");
                        }
                        if (lastPoint >= 0) {
                            try
                            {
                                newOp.put("value", Float.parseFloat(valueString));
                            }
                            catch (NumberFormatException e)
                            {
                                newOp.put("error", e.getMessage());
                            }
                        }
                    }
                }
                
                String nf = TYPES.get(type);
                if (StringUtils.isNotEmpty(nf))
                {
                    JSONObject numberFormat = new JSONObject();
                    numberFormat.put("code", nf);
                    numberFormat.put("id", -1);
                    JSONObject cell = new JSONObject();
                    cell.put("numberFormat", numberFormat);

                    /*
                     * JSONObject color = new JSONObject(); color.put("type", "scheme"); color.put("value", "accent4"); cell.put("fillColor", color);
                     */

                    // {sheet:0,start:[2,1],attrs:{cell:{fillColor:{type:"scheme",value:"accent1",fallbackValue:"5b9bd5"}}}}

                    autostyleIndex++;

                    JSONObject attrs = new JSONObject();

                    attrs.put("styleId", "a" + autostyleIndex);

                    attrs.put("cell", cell);
                    newOp.put("attrs", attrs);

                    JSONObject autostyle = new JSONObject();
                    autostyle.put("name", "insertStyleSheet");
                    autostyle.put("hidden", true);
                    autostyle.put("auto", true);
                    autostyle.put("parent", "Standard");
                    autostyle.put("type", "cell");
                    autostyle.put("styleName", "");

                    autostyle.put("styleId", "a" + autostyleIndex);

                    autostyle.put("attrs", attrs);

                    newOps.put(autostyle);

                    // insertStyleSheet

                }
                Object width = content.opt("width");
                if (width != null)
                {
                    JSONObject col = new JSONObject();
                    col.put("name", "setColumnAttributes");
                    col.put("sheet", sheet);
                    col.put("start", cellRef.get(0));

                    JSONObject column = new JSONObject();
                    column.put("customWidth", true);
                    column.put("width", width);

                    JSONObject attrs = new JSONObject();
                    attrs.put("column", column);

                    col.put("attrs", attrs);
                    newOps.put(col);

                }
            }
            newOps.put(newOp);

        }

        return newOps;
    }

    /*
     * copied from SmlUtils
     */
    public static JSONArray createCellRef(
        String cellRef)
    {

        if (cellRef == null || cellRef.isEmpty())
        {
            return null;
        }

        int characters = 0;
        int characterStartIndex = cellRef.charAt(0) == '$' ? 1 : 0;

        while ((characters + characterStartIndex) < cellRef.length())
        {
            char character = cellRef.charAt(characterStartIndex + characters);
            if ((character < 'A') || (character > 'Z'))
            {
                break;
            }
            characters++;
        }
        if (characters > 0 && (characters + characterStartIndex) < cellRef.length() && characters < 6)
        {

            final int[] exMap =
            { 1, 26, 676, 17576, 456976 };

            int ex = characters - 1;
            int x = 0;

            for (int i = 0; i < characters; i++)
            {
                x += ((cellRef.charAt(i + characterStartIndex) - 'A') + 1) * exMap[ex - i];
            }

            int numbers = 0;
            int numberStartIndex = characterStartIndex + characters;

            if (cellRef.charAt(numberStartIndex) == '$')
            {
                numberStartIndex++;
            }
            while (numbers + numberStartIndex < cellRef.length())
            {
                char character = cellRef.charAt(numberStartIndex + numbers);
                if ((character < '0') || (character > '9'))
                {
                    break;
                }
                numbers++;
            }
            if (numbers > 0)
            {
                int y = 0;
                for (int i = 0; i < numbers; i++)
                {
                    y *= 10;
                    y += cellRef.charAt(i + numberStartIndex) - '0';
                }
                if (y > 0)
                {
                    JSONArray res = new JSONArray();
                    res.put(x - 1);
                    res.put(y - 1);
                    return res;
                }
            }
        }
        return null;
    }

}
