/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.calcengine.client;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;

import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;

import com.openexchange.office.calcengine.CalcEngineConst;
import com.openexchange.office.tools.logging.LogFactory;

//=============================================================================
@Consumes(MediaType.APPLICATION_JSON)
@Provider
public class CalcEngineHttpEntityReader implements MessageBodyReader< CalcEngineHttpEntity >
{
	//-------------------------------------------------------------------------
	private static final Log LOG = LogFactory.getJclLog(CalcEngineHttpEntityReader.class);
	
	//-------------------------------------------------------------------------
	public CalcEngineHttpEntityReader ()
	{}
	
	//-------------------------------------------------------------------------
	@Override
	public boolean isReadable(final Class<?>     aSpecificType,
							  final Type         aGenericType ,
							  final Annotation[] lAnnotations ,
							  final MediaType    aMediaType   )
	{
		if (LOG.isTraceEnabled())
		{
			LOG.trace ("isReadable ()");
			LOG.trace ("      specific type = '"+aSpecificType+"'");
			LOG.trace ("      generic  type = '"+aGenericType +"'");
			LOG.trace ("      annotations   = '"+lAnnotations +"'");
			LOG.trace ("      media    type = '"+aMediaType   +"'");
		}

		if ( ! aSpecificType.equals(CalcEngineHttpEntity.class))
		{
			LOG.trace ("      return FALSE (non compatible class type)");
			return false;
		}

		if ( ! aMediaType.isCompatible(MediaType.APPLICATION_JSON_TYPE))
		{
			LOG.trace ("      return FALSE (non compatible media type)");
			return false;
		}
		
		LOG.trace ("      return TRUE");
		return true;
	}

	//-------------------------------------------------------------------------
	@Override
	public CalcEngineHttpEntity readFrom(final Class< CalcEngineHttpEntity >    aSpecificType,
										 final Type                             aGenericType ,
										 final Annotation[]                     lAnnotations ,
										 final MediaType                        aMediaType   ,
										 final MultivaluedMap< String, String > lHttpHeaders ,
										 final InputStream                      aEntityStream)
		throws IOException
		     , WebApplicationException
	{
		if (LOG.isTraceEnabled())
		{
			LOG.trace ("readFrom ()");
			LOG.trace ("      specific type = '"+aSpecificType+"'");
			LOG.trace ("      generic  type = '"+aGenericType +"'");
			LOG.trace ("      annotations   = '"+lAnnotations +"'");
			LOG.trace ("      media    type = '"+aMediaType   +"'");
		}

		try
		{
			final String sJSON = IOUtils.toString(aEntityStream, CalcEngineConst.ENCODING_4_STREAMING);
			if (LOG.isTraceEnabled())
				LOG.trace ("      json          = '"+sJSON+"'");

			final CalcEngineHttpEntity aEntity = CalcEngineHttpEntity.fromJSON(sJSON);
			if (LOG.isTraceEnabled())
				LOG.trace ("      entity        = '"+aEntity+"'");
			
			LOG.trace ("      return entity");
			return aEntity;
		}
		catch (Exception ex)
		{
			LOG.error (ex.getMessage (), ex);
		}

		LOG.trace ("      return null (exception)");
		return null;
	}
}
