/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.tools.rt;

import com.openexchange.office.tools.SessionUtils;
import com.openexchange.realtime.packet.ID;

/**
 * Helper class to extract or get information from a real-time stanza ID.
 *
 * {@link IDUtils}
 *
 * @author <a href="mailto:carsten.driesner@open-xchange.com">Carsten Driesner</a>
 * @since v7.6.0
 */
public class IDUtils {

    /**
     * Tries to get the user id from a real-time id string.
     *
     * @param id
     *  The real-time ID as string where we want to retrieve the user id.
     *
     * @return
     *  The user id or -1 if the id could not be determined.
     *
     * @throws Exception
     */
    public static int getUserIdFromRealTimeId(final String id) throws Exception {
        return getUserIdFromRealTimeId(new ID(id));
    }

    /**
     * Tries to get the user id from a real-time id.
     *
     * @param id
     *  The real-time ID where we want to retrieve the user id.
     *
     * @return
     *  The user id or -1 if the id could not be determined.
     *
     * @throws Exception
     */
    public static int getUserIdFromRealTimeId(final ID id) throws Exception {
        int result = -1;

        // try to get user id from session from ID
        if (null != id) {
            result = SessionUtils.getUserId(id.toSession());
        }

        return result;
    }

    /**
     * Provides the resource-id from the connection id.
     *
     * @param id
     *  The real-time ID to retrieve the resource-id from.
     *
     * @return
     *  The resource id or null.
     */
    public static String getResourceId(final ID id) {
        return (null != id) ? id.getResource() : null;
    }
}
