package com.openexchange.office.tools.htmldoc;

import org.json.JSONArray;

public class Row
        extends NodeHolder
{

    private boolean insertDefaultCells;

    public Row(
            boolean insertDefaultCells)
        throws Exception
    {
        this.insertDefaultCells = insertDefaultCells;
    }

    void setCellCount(
        int count)
        throws Exception
    {
        if (insertDefaultCells)
        {
            for (int i = 0; i < count; i++)
            {
                final JSONArray start = new JSONArray();
                start.put(i);

                this.insert(start, new Cell());
            }
        }
    }

    @Override
    public boolean appendContent(
        StringBuilder document)
        throws Exception
    {

        document.append("<tr role='row'");

        GenDocHelper.appendAttributes(getAttribute(), document);

        document.append(" >");

        super.appendContent(document);

        document.append("</tr>");
        return true;
    }

    @Override
    public boolean needsEmptySpan()
    {
        return false;
    }
}
