/*
*
*    OPEN-XCHANGE legal information
*
*    All intellectual property rights in the Software are protected by
*    international copyright laws.
*
*
*    In some countries OX, OX Open-Xchange, open xchange and OXtender
*    as well as the corresponding Logos OX Open-Xchange and OX are registered
*    trademarks.
*    The use of the Logos is not covered by the GNU General Public License.
*    Instead, you are allowed to use these Logos according to the terms and
*    conditions of the Creative Commons License, Version 2.5, Attribution,
*    Non-commercial, ShareAlike, and the interpretation of the term
*    Non-commercial applicable to the aforementioned license is published
*    on the web site http://www.open-xchange.com/EN/legal/index.html.
*
*    Please make sure that third-party modules and libraries are used
*    according to their respective licenses.
*
*    Any modifications to this package must retain all copyright notices
*    of the original copyright holder(s) for the original code used.
*
*    After any such modifications, the original and derivative code shall remain
*    under the copyright of the copyright holder(s) and/or original author(s)per
*    the Attribution and Assignment Agreement that can be located at
*    http://www.open-xchange.com/EN/developer/. The contributing author shall be
*    given Attribution for the derivative code and a license granting use.
*
*     Copyright (C) 2016 OX Software GmbH
*     Mail: info@open-xchange.com
*
*
*     This program is free software; you can redistribute it and/or modify it
*     under the terms of the GNU General Public License, Version 2 as published
*     by the Free Software Foundation.
*
*     This program is distributed in the hope that it will be useful, but
*     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
*     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
*     for more details.
*
*     You should have received a copy of the GNU General Public License along
*     with this program; if not, write to the Free Software Foundation, Inc., 59
*     Temple Place, Suite 330, Boston, MA 02111-1307 USA
*
*/
package com.openexchange.office.realtime.log;

/*
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import com.openexchange.office.tools.EasyStopWatch;
import com.openexchange.office.tools.logging.ELogLevel;
*/

/**
 * Logging class to control the time for a lengthly task, which is split up
 * in several steps, which are controlled, too.
 *
 * {@link TimeSpanContextLogger}
 *
 * @author <a href="mailto:carsten.driesner@open-xchange.com">Carsten Driesner</a>
 * @since v7.8.0
 */
public class TimeSpanContextLogger {
/*
    private final AtomicBoolean timeOverflow = new AtomicBoolean(false);
    private final ArrayList<LogEntry> logEntries = new ArrayList<LogEntry>();
    private final Log logger;
    private final ELogLevel logLevel;
    private final String exceededTimeLogMessage;
    private EasyStopWatch watch;

    private static class LogEntry {
        private final String logMsg;
        private final long timeElapsed;
        private final long fullTime;

        public LogEntry(final String logMsg, long timeElapsed, long fullTime) {
            this.logMsg = logMsg;
            this.timeElapsed = timeElapsed;
            this.fullTime = fullTime;
        }

        public long getTimeStamp() {
            return this.fullTime;
        }

        @Override
        public String toString() {
            final StringBuffer buf = new StringBuffer();
            buf.append(logMsg);
            buf.append(": ");
            buf.append(timeElapsed);
            buf.append("ms");
            return buf.toString();
        }
    }

    public TimeSpanContextLogger(final Log logger, ELogLevel logLevel, final String exceededTimeLogMessage) {
        Validate.notNull(logger, "Log must not null!");
        Validate.notNull("Time exceeded message must not be null!");
        this.logger = logger;
        this.logLevel = logLevel;
        this.watch = null;
        this.exceededTimeLogMessage = exceededTimeLogMessage;
    }

    public void start() {
        watch = new EasyStopWatch();
        logEntries.clear();
        timeOverflow.set(false);
        watch.start();
    }

    public void logStep(final String stepMsg, long maxTime) {
        long time = watch.getTime();

        synchronized(logEntries) {
            int size = logEntries.size();
            long lastStepTime = time;

            if (size > 0) {
                lastStepTime = time - logEntries.get(size - 1).getTimeStamp();
            }

            logEntries.add(new LogEntry(stepMsg, lastStepTime, time));

            if (lastStepTime > maxTime) {
                timeOverflow.set(true);
            }
        }
    }

    public long end(long maxTime) {
        long elapsedTime = watch.stop();

        if (timeOverflow.get() || (elapsedTime > maxTime)) {
            int size = logEntries.size();
            final StringBuffer buf = new StringBuffer(256);

            buf.append(exceededTimeLogMessage);
            buf.append("time for steps: (");
            for (int i = 0; i < size; i++) {
                buf.append(logEntries.get(i));
                if (i < (size-1)) {
                    buf.append(", ");
                }
            }
            buf.append("), ");
            buf.append("complete time = ");
            buf.append(elapsedTime);
            buf.append("ms");

            final String msg = buf.toString();
            try {
                switch (ELogLevel.toInt(logLevel)) {
                case ELogLevel.INT_LEVEL_DEBUG: logger.debug(msg); break;
                case ELogLevel.INT_LEVEL_ERROR: logger.error(msg); break;
                case ELogLevel.INT_LEVEL_INFO: logger.info(msg); break;
                case ELogLevel.INT_LEVEL_TRACE: logger.trace(msg); break;
                case ELogLevel.INT_LEVEL_WARNING: logger.warn(msg); break;
                }
            } catch (Exception e) {
                logger.error("RT connection: Exception while trying to output timing log message", e);
            }
        }

        return elapsedTime;
    }

    public static void logStep(final TimeSpanContextLogger logger, final String stepMsg, long maxTime) {
        if (null != logger) {
            logger.logStep(stepMsg, maxTime);
        }
    }
*/
}
