package org.docx4j.convert.out.XSLFO;

import static org.junit.Assert.assertTrue;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;

import org.docx4j.Docx4J;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.FOSettings;
import org.docx4j.convert.out.pdf.viaXSLFO.Conversion;
import org.docx4j.convert.out.pdf.viaXSLFO.PdfSettings;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.wml.Document;
import org.junit.Ignore;
import org.junit.Test;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TableIndentTest extends AbstractXSLFOTest {

	/*
	 * Word ignores indent (positive or negative)
	 * <w:tblInd w:type=\"dxa\" w:w=\"-1588\"/>
	 * where table is centre or right justified
	 * <w:jc w:val=\"center\"/>
	 */
	@Test
	@Ignore
	public  void testTblIndentOnCentredTable() throws Exception {
		
		boolean save = true;
		
		WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.createPackage();
		wordMLPackage.getMainDocumentPart().setJaxbElement(
				(Document)XmlUtils.unmarshalString(table1XML));		
		
		
    	FOSettings foSettings = Docx4J.createFOSettings();
		foSettings.setWmlPackage(wordMLPackage);
		
		OutputStream os = null;
		if (save) {
			
			os = new FileOutputStream(new File(System.getProperty("user.dir") + "/OUT_testTblIndentOnCentredTable.pdf"));
			wordMLPackage.save(new File(System.getProperty("user.dir") + "/OUT_testTblIndentOnCentredTable.docx"));
		} else {
			// want the fo document as the result.
			foSettings.setApacheFopMime(FOSettings.INTERNAL_FO_MIME);
			
			// exporter writes to an OutputStream.		
			os = new ByteArrayOutputStream(); 
		}
		
    	

		//Don't care what type of exporter you use
//		Docx4J.toFO(foSettings, os, Docx4J.FLAG_NONE);
		//Prefer the exporter, that uses a xsl transformation
		Docx4J.toFO(foSettings, os, Docx4J.FLAG_EXPORT_PREFER_XSL);

		if (save) {
			
		} else {
			byte[] bytes = ((ByteArrayOutputStream)os).toByteArray();
	//		System.out.println(new String(bytes, "UTF-8"));
		
			// Now use XPath to assert it has a table-body
			org.w3c.dom.Document domDoc = w3cDomDocumentFromByteArray( bytes);
			
			assertTrue(this.isAbsent(domDoc, "//fo:table-header"));
			assertTrue(this.isPresent(domDoc, "//fo:table-body"));
		}
		
	}
	

	private static String table1XML = "<w:document mc:Ignorable=\"w14 wp14\" xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\" xmlns:mc=\"http://schemas.openxmlformats.org/markup-compatibility/2006\">"
            + "<w:body>"
//                + "<w:p>"
//                    + "<w:pPr>"
//                        + "<w:pStyle w:val=\"Name\"/>"
//                        + "<w:ind w:left=\"-360\"/>"
//                        + "<w:rPr>"
//                            + "<w:b w:val=\"0\"/>"
//                        +"</w:rPr>"
//                    +"</w:pPr>"
//                +"</w:p>"
//                + "<w:p>"
//                    + "<w:pPr>"
//                        + "<w:rPr>"
//                            + "<w:rFonts w:ascii=\"Trebuchet MS\" w:hAnsi=\"Trebuchet MS\"/>"
//                        +"</w:rPr>"
//                    +"</w:pPr>"
//                +"</w:p>"
                + "<w:tbl>"
                    + "<w:tblPr>"
                        + "<w:tblW w:type=\"dxa\" w:w=\"9418\"/>"
                        // Word ignores negative indent where table is centre justified!
                        + "<w:jc w:val=\"center\"/>"
                        + "<w:tblInd w:type=\"dxa\" w:w=\"-1588\"/>"
                        + "<w:tblBorders>"
                            + "<w:top w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                            + "<w:left w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                            + "<w:bottom w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                            + "<w:right w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                            + "<w:insideH w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                            + "<w:insideV w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                        +"</w:tblBorders>"
                        + "<w:tblCellMar>"
                            + "<w:top w:type=\"dxa\" w:w=\"43\"/>"
                            + "<w:left w:type=\"dxa\" w:w=\"115\"/>"
                            + "<w:bottom w:type=\"dxa\" w:w=\"43\"/>"
                            + "<w:right w:type=\"dxa\" w:w=\"115\"/>"
                        +"</w:tblCellMar>"
                        + "<w:tblLook w:firstColumn=\"0\" w:firstRow=\"0\" w:lastColumn=\"0\" w:lastRow=\"0\" w:noHBand=\"0\" w:noVBand=\"0\" w:val=\"0000\"/>"
                    +"</w:tblPr>"
                    + "<w:tblGrid>"
                        + "<w:gridCol w:w=\"533\"/>"
                        + "<w:gridCol w:w=\"5796\"/>"
                        + "<w:gridCol w:w=\"1626\"/>"
                        + "<w:gridCol w:w=\"1463\"/>"
                    +"</w:tblGrid>"
                    + "<w:tr w:rsidTr=\"00615919\">"
                        + "<w:trPr>"
                            + "<w:cantSplit/>"
                            + "<w:trHeight w:val=\"288\"/>"
                            + "<w:jc w:val=\"center\"/>"
                        +"</w:trPr>"
                        + "<w:tc>"
                            + "<w:tcPr>"
                                + "<w:tcW w:type=\"dxa\" w:w=\"533\"/>"
                                + "<w:tcBorders>"
                                    + "<w:top w:color=\"3B5E91\" w:space=\"0\" w:sz=\"12\" w:val=\"single\"/>"
                                    + "<w:left w:color=\"3B5E91\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                    + "<w:bottom w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                    + "<w:right w:color=\"3B5E91\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                +"</w:tcBorders>"
                                + "<w:shd w:color=\"auto\" w:fill=\"E4EAF4\" w:val=\"clear\"/>"
                                + "<w:vAlign w:val=\"center\"/>"
                            +"</w:tcPr>"
                            + "<w:p>"
                                + "<w:pPr>"
                                    + "<w:pStyle w:val=\"ColumnHeadings\"/>"
                                +"</w:pPr>"
                                + "<w:r>"
                                    + "<w:t>qty</w:t>"
                                +"</w:r>"
                            +"</w:p>"
                        +"</w:tc>"
                        + "<w:tc>"
                            + "<w:tcPr>"
                                + "<w:tcW w:type=\"dxa\" w:w=\"5796\"/>"
                                + "<w:tcBorders>"
                                    + "<w:top w:color=\"3B5E91\" w:space=\"0\" w:sz=\"12\" w:val=\"single\"/>"
                                    + "<w:left w:color=\"3B5E91\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                    + "<w:bottom w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                    + "<w:right w:color=\"3B5E91\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                +"</w:tcBorders>"
                                + "<w:shd w:color=\"auto\" w:fill=\"E4EAF4\" w:val=\"clear\"/>"
                                + "<w:vAlign w:val=\"center\"/>"
                            +"</w:tcPr>"
                            + "<w:p>"
                                + "<w:pPr>"
                                    + "<w:pStyle w:val=\"ColumnHeadings\"/>"
                                +"</w:pPr>"
                                + "<w:r>"
                                    + "<w:t>description</w:t>"
                                +"</w:r>"
                            +"</w:p>"
                        +"</w:tc>"
                        + "<w:tc>"
                            + "<w:tcPr>"
                                + "<w:tcW w:type=\"dxa\" w:w=\"1626\"/>"
                                + "<w:tcBorders>"
                                    + "<w:top w:color=\"3B5E91\" w:space=\"0\" w:sz=\"12\" w:val=\"single\"/>"
                                    + "<w:left w:color=\"3B5E91\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                    + "<w:bottom w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                    + "<w:right w:color=\"3B5E91\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                +"</w:tcBorders>"
                                + "<w:shd w:color=\"auto\" w:fill=\"E4EAF4\" w:val=\"clear\"/>"
                                + "<w:vAlign w:val=\"center\"/>"
                            +"</w:tcPr>"
                            + "<w:p>"
                                + "<w:pPr>"
                                    + "<w:pStyle w:val=\"ColumnHeadings\"/>"
                                +"</w:pPr>"
                                + "<w:r>"
                                    + "<w:t>unit price</w:t>"
                                +"</w:r>"
                            +"</w:p>"
                        +"</w:tc>"
                        + "<w:tc>"
                            + "<w:tcPr>"
                                + "<w:tcW w:type=\"dxa\" w:w=\"1463\"/>"
                                + "<w:tcBorders>"
                                    + "<w:top w:color=\"3B5E91\" w:space=\"0\" w:sz=\"12\" w:val=\"single\"/>"
                                    + "<w:left w:color=\"3B5E91\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                    + "<w:bottom w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                    + "<w:right w:color=\"3B5E91\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                +"</w:tcBorders>"
                                + "<w:shd w:color=\"auto\" w:fill=\"E4EAF4\" w:val=\"clear\"/>"
                                + "<w:vAlign w:val=\"center\"/>"
                            +"</w:tcPr>"
                            + "<w:p>"
                                + "<w:pPr>"
                                    + "<w:pStyle w:val=\"ColumnHeadings\"/>"
                                +"</w:pPr>"
                                + "<w:r>"
                                    + "<w:t>line total</w:t>"
                                +"</w:r>"
                            +"</w:p>"
                        +"</w:tc>"
                    +"</w:tr>"
                    + "<w:tr w:rsidTr=\"00440DA0\">"
                        + "<w:trPr>"
                            + "<w:cantSplit/>"
                            + "<w:trHeight w:val=\"289\"/>"
                            + "<w:jc w:val=\"center\"/>"
                        +"</w:trPr>"
                        + "<w:tc>"
                            + "<w:tcPr>"
                                + "<w:tcW w:type=\"dxa\" w:w=\"533\"/>"
                                + "<w:tcBorders>"
                                    + "<w:top w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                    + "<w:left w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                    + "<w:bottom w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                    + "<w:right w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                +"</w:tcBorders>"
                                + "<w:shd w:color=\"auto\" w:fill=\"auto\" w:val=\"clear\"/>"
                                + "<w:vAlign w:val=\"center\"/>"
                            +"</w:tcPr>"
                            + "<w:p>"
                                + "<w:pPr>"
                                    + "<w:rPr>"
                                        + "<w:rFonts w:ascii=\"Trebuchet MS\" w:hAnsi=\"Trebuchet MS\"/>"
                                        + "<w:sz w:val=\"18\"/>"
                                        + "<w:szCs w:val=\"18\"/>"
                                    +"</w:rPr>"
                                +"</w:pPr>"
                                + "<w:r>"
                                    + "<w:rPr>"
                                        + "<w:rFonts w:ascii=\"Trebuchet MS\" w:hAnsi=\"Trebuchet MS\"/>"
                                        + "<w:sz w:val=\"18\"/>"
                                        + "<w:szCs w:val=\"18\"/>"
                                    +"</w:rPr>"
                                    + "<w:t>1</w:t>"
                                +"</w:r>"
                            +"</w:p>"
                        +"</w:tc>"
                        + "<w:tc>"
                            + "<w:tcPr>"
                                + "<w:tcW w:type=\"dxa\" w:w=\"5796\"/>"
                                + "<w:tcBorders>"
                                    + "<w:top w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                    + "<w:left w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                    + "<w:bottom w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                    + "<w:right w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                +"</w:tcBorders>"
                                + "<w:shd w:color=\"auto\" w:fill=\"auto\" w:val=\"clear\"/>"
                                + "<w:vAlign w:val=\"center\"/>"
                            +"</w:tcPr>"
                            + "<w:p>"
                                + "<w:pPr>"
                                    + "<w:rPr>"
                                        + "<w:rFonts w:ascii=\"Trebuchet MS\" w:hAnsi=\"Trebuchet MS\"/>"
                                        + "<w:b/>"
                                        + "<w:sz w:val=\"18\"/>"
                                        + "<w:szCs w:val=\"18\"/>"
                                    +"</w:rPr>"
                                +"</w:pPr>"
                                + "<w:r>"
                                    + "<w:rPr>"
                                        + "<w:rFonts w:ascii=\"Trebuchet MS\" w:hAnsi=\"Trebuchet MS\"/>"
                                        + "<w:b/>"
                                        + "<w:sz w:val=\"18\"/>"
                                        + "<w:szCs w:val=\"18\"/>"
                                    +"</w:rPr>"
                                    + "<w:t>An Item</w:t>"
                                +"</w:r>"
                            +"</w:p>"
                        +"</w:tc>"
                        + "<w:tc>"
                            + "<w:tcPr>"
                                + "<w:tcW w:type=\"dxa\" w:w=\"1626\"/>"
                                + "<w:tcBorders>"
                                    + "<w:top w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                    + "<w:left w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                    + "<w:bottom w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                    + "<w:right w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                +"</w:tcBorders>"
                                + "<w:shd w:color=\"auto\" w:fill=\"auto\" w:val=\"clear\"/>"
                                + "<w:tcMar>"
                                    + "<w:left w:type=\"dxa\" w:w=\"216\"/>"
                                    + "<w:right w:type=\"dxa\" w:w=\"216\"/>"
                                +"</w:tcMar>"
                                + "<w:vAlign w:val=\"center\"/>"
                            +"</w:tcPr>"
                            + "<w:p>"
                                + "<w:pPr>"
                                    + "<w:jc w:val=\"right\"/>"
                                    + "<w:rPr>"
                                        + "<w:rFonts w:ascii=\"Trebuchet MS\" w:hAnsi=\"Trebuchet MS\"/>"
                                        + "<w:sz w:val=\"18\"/>"
                                        + "<w:szCs w:val=\"18\"/>"
                                    +"</w:rPr>"
                                +"</w:pPr>"
                                + "<w:r>"
                                    + "<w:rPr>"
                                        + "<w:rFonts w:ascii=\"Trebuchet MS\" w:hAnsi=\"Trebuchet MS\"/>"
                                        + "<w:sz w:val=\"18\"/>"
                                        + "<w:szCs w:val=\"18\"/>"
                                    +"</w:rPr>"
                                    + "<w:t>$1</w:t>"
                                +"</w:r>"
                            +"</w:p>"
                        +"</w:tc>"
                        + "<w:tc>"
                            + "<w:tcPr>"
                                + "<w:tcW w:type=\"dxa\" w:w=\"1463\"/>"
                                + "<w:tcBorders>"
                                    + "<w:top w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                    + "<w:left w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                    + "<w:bottom w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                    + "<w:right w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                +"</w:tcBorders>"
                                + "<w:shd w:color=\"auto\" w:fill=\"auto\" w:val=\"clear\"/>"
                                + "<w:tcMar>"
                                    + "<w:left w:type=\"dxa\" w:w=\"216\"/>"
                                    + "<w:right w:type=\"dxa\" w:w=\"216\"/>"
                                +"</w:tcMar>"
                                + "<w:vAlign w:val=\"center\"/>"
                            +"</w:tcPr>"
                            + "<w:p>"
                                + "<w:pPr>"
                                    + "<w:jc w:val=\"right\"/>"
                                    + "<w:rPr>"
                                        + "<w:rFonts w:ascii=\"Trebuchet MS\" w:hAnsi=\"Trebuchet MS\"/>"
                                        + "<w:sz w:val=\"18\"/>"
                                        + "<w:szCs w:val=\"18\"/>"
                                    +"</w:rPr>"
                                +"</w:pPr>"
                                + "<w:r>"
                                    + "<w:rPr>"
                                        + "<w:rFonts w:ascii=\"Trebuchet MS\" w:hAnsi=\"Trebuchet MS\"/>"
                                        + "<w:sz w:val=\"18\"/>"
                                        + "<w:szCs w:val=\"18\"/>"
                                    +"</w:rPr>"
                                    + "<w:t>$1</w:t>"
                                +"</w:r>"
                            +"</w:p>"
                        +"</w:tc>"
                    +"</w:tr>"
                    + "<w:tr w:rsidTr=\"00615919\">"
                        + "<w:trPr>"
                            + "<w:cantSplit/>"
                            + "<w:trHeight w:val=\"288\"/>"
                            + "<w:jc w:val=\"center\"/>"
                        +"</w:trPr>"
                        + "<w:tc>"
                            + "<w:tcPr>"
                                + "<w:tcW w:type=\"dxa\" w:w=\"533\"/>"
                                + "<w:tcBorders>"
                                    + "<w:top w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                    + "<w:left w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                    + "<w:bottom w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                    + "<w:right w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                +"</w:tcBorders>"
                                + "<w:shd w:color=\"auto\" w:fill=\"auto\" w:val=\"clear\"/>"
                                + "<w:vAlign w:val=\"center\"/>"
                            +"</w:tcPr>"
                            + "<w:p>"
                                + "<w:pPr>"
                                    + "<w:rPr>"
                                        + "<w:rFonts w:ascii=\"Trebuchet MS\" w:hAnsi=\"Trebuchet MS\"/>"
                                        + "<w:sz w:val=\"18\"/>"
                                        + "<w:szCs w:val=\"18\"/>"
                                    +"</w:rPr>"
                                +"</w:pPr>"
                            +"</w:p>"
                        +"</w:tc>"
                        + "<w:tc>"
                            + "<w:tcPr>"
                                + "<w:tcW w:type=\"dxa\" w:w=\"5796\"/>"
                                + "<w:tcBorders>"
                                    + "<w:top w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                    + "<w:left w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                    + "<w:bottom w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                    + "<w:right w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                +"</w:tcBorders>"
                                + "<w:shd w:color=\"auto\" w:fill=\"auto\" w:val=\"clear\"/>"
                                + "<w:vAlign w:val=\"center\"/>"
                            +"</w:tcPr>"
                            + "<w:p>"
                                + "<w:pPr>"
                                    + "<w:rPr>"
                                        + "<w:rFonts w:ascii=\"Trebuchet MS\" w:hAnsi=\"Trebuchet MS\"/>"
                                        + "<w:sz w:val=\"18\"/>"
                                        + "<w:szCs w:val=\"18\"/>"
                                    +"</w:rPr>"
                                +"</w:pPr>"
                                + "<w:r>"
                                    + "<w:rPr>"
                                        + "<w:rFonts w:ascii=\"Trebuchet MS\" w:hAnsi=\"Trebuchet MS\"/>"
                                        + "<w:sz w:val=\"18\"/>"
                                        + "<w:szCs w:val=\"18\"/>"
                                    +"</w:rPr>"
                                    + "<w:t>Shipping</w:t>"
                                +"</w:r>"
                            +"</w:p>"
                        +"</w:tc>"
                        + "<w:tc>"
                            + "<w:tcPr>"
                                + "<w:tcW w:type=\"dxa\" w:w=\"1626\"/>"
                                + "<w:tcBorders>"
                                    + "<w:top w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                    + "<w:left w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                    + "<w:bottom w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                    + "<w:right w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                +"</w:tcBorders>"
                                + "<w:shd w:color=\"auto\" w:fill=\"auto\" w:val=\"clear\"/>"
                                + "<w:tcMar>"
                                    + "<w:left w:type=\"dxa\" w:w=\"216\"/>"
                                    + "<w:right w:type=\"dxa\" w:w=\"216\"/>"
                                +"</w:tcMar>"
                                + "<w:vAlign w:val=\"center\"/>"
                            +"</w:tcPr>"
                            + "<w:p>"
                                + "<w:pPr>"
                                    + "<w:jc w:val=\"right\"/>"
                                    + "<w:rPr>"
                                        + "<w:rFonts w:ascii=\"Trebuchet MS\" w:hAnsi=\"Trebuchet MS\"/>"
                                        + "<w:sz w:val=\"18\"/>"
                                        + "<w:szCs w:val=\"18\"/>"
                                    +"</w:rPr>"
                                +"</w:pPr>"
                                + "<w:r>"
                                    + "<w:rPr>"
                                        + "<w:rFonts w:ascii=\"Trebuchet MS\" w:hAnsi=\"Trebuchet MS\"/>"
                                        + "<w:sz w:val=\"18\"/>"
                                        + "<w:szCs w:val=\"18\"/>"
                                    +"</w:rPr>"
                                    + "<w:t>$</w:t>"
                                +"</w:r>"
                                + "<w:r>"
                                    + "<w:rPr>"
                                        + "<w:rFonts w:ascii=\"Trebuchet MS\" w:hAnsi=\"Trebuchet MS\"/>"
                                        + "<w:sz w:val=\"18\"/>"
                                        + "<w:szCs w:val=\"18\"/>"
                                    +"</w:rPr>"
                                    + "<w:t>2</w:t>"
                                +"</w:r>"
                            +"</w:p>"
                        +"</w:tc>"
                        + "<w:tc>"
                            + "<w:tcPr>"
                                + "<w:tcW w:type=\"dxa\" w:w=\"1463\"/>"
                                + "<w:tcBorders>"
                                    + "<w:top w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                    + "<w:left w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                    + "<w:bottom w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                    + "<w:right w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                +"</w:tcBorders>"
                                + "<w:shd w:color=\"auto\" w:fill=\"auto\" w:val=\"clear\"/>"
                                + "<w:tcMar>"
                                    + "<w:left w:type=\"dxa\" w:w=\"216\"/>"
                                    + "<w:right w:type=\"dxa\" w:w=\"216\"/>"
                                +"</w:tcMar>"
                                + "<w:vAlign w:val=\"center\"/>"
                            +"</w:tcPr>"
                            + "<w:p>"
                                + "<w:pPr>"
                                    + "<w:jc w:val=\"right\"/>"
                                    + "<w:rPr>"
                                        + "<w:rFonts w:ascii=\"Trebuchet MS\" w:hAnsi=\"Trebuchet MS\"/>"
                                        + "<w:sz w:val=\"18\"/>"
                                        + "<w:szCs w:val=\"18\"/>"
                                    +"</w:rPr>"
                                +"</w:pPr>"
                                + "<w:r>"
                                    + "<w:rPr>"
                                        + "<w:rFonts w:ascii=\"Trebuchet MS\" w:hAnsi=\"Trebuchet MS\"/>"
                                        + "<w:sz w:val=\"18\"/>"
                                        + "<w:szCs w:val=\"18\"/>"
                                    +"</w:rPr>"
                                    + "<w:t>$</w:t>"
                                +"</w:r>"
                                + "<w:r>"
                                    + "<w:rPr>"
                                        + "<w:rFonts w:ascii=\"Trebuchet MS\" w:hAnsi=\"Trebuchet MS\"/>"
                                        + "<w:sz w:val=\"18\"/>"
                                        + "<w:szCs w:val=\"18\"/>"
                                    +"</w:rPr>"
                                    + "<w:t>2</w:t>"
                                +"</w:r>"
                            +"</w:p>"
                        +"</w:tc>"
                    +"</w:tr>"
                    + "<w:tr w:rsidTr=\"00615919\">"
                        + "<w:trPr>"
                            + "<w:cantSplit/>"
                            + "<w:trHeight w:val=\"288\"/>"
                            + "<w:jc w:val=\"center\"/>"
                        +"</w:trPr>"
                        + "<w:tc>"
                            + "<w:tcPr>"
                                + "<w:tcW w:type=\"dxa\" w:w=\"533\"/>"
                                + "<w:tcBorders>"
                                    + "<w:top w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                    + "<w:left w:val=\"nil\"/>"
                                    + "<w:bottom w:val=\"nil\"/>"
                                    + "<w:right w:val=\"nil\"/>"
                                +"</w:tcBorders>"
                                + "<w:shd w:color=\"auto\" w:fill=\"auto\" w:val=\"clear\"/>"
                                + "<w:vAlign w:val=\"center\"/>"
                            +"</w:tcPr>"
                            + "<w:p>"
                                + "<w:pPr>"
                                    + "<w:rPr>"
                                        + "<w:rFonts w:ascii=\"Trebuchet MS\" w:hAnsi=\"Trebuchet MS\"/>"
                                        + "<w:sz w:val=\"18\"/>"
                                        + "<w:szCs w:val=\"18\"/>"
                                    +"</w:rPr>"
                                +"</w:pPr>"
                            +"</w:p>"
                        +"</w:tc>"
                        + "<w:tc>"
                            + "<w:tcPr>"
                                + "<w:tcW w:type=\"dxa\" w:w=\"5796\"/>"
                                + "<w:tcBorders>"
                                    + "<w:top w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                    + "<w:left w:val=\"nil\"/>"
                                    + "<w:bottom w:val=\"nil\"/>"
                                    + "<w:right w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                +"</w:tcBorders>"
                                + "<w:shd w:color=\"auto\" w:fill=\"auto\" w:val=\"clear\"/>"
                                + "<w:vAlign w:val=\"center\"/>"
                            +"</w:tcPr>"
                            + "<w:p>"
                                + "<w:pPr>"
                                    + "<w:rPr>"
                                        + "<w:rFonts w:ascii=\"Trebuchet MS\" w:hAnsi=\"Trebuchet MS\"/>"
                                        + "<w:sz w:val=\"18\"/>"
                                        + "<w:szCs w:val=\"18\"/>"
                                    +"</w:rPr>"
                                +"</w:pPr>"
                            +"</w:p>"
                        +"</w:tc>"
                        + "<w:tc>"
                            + "<w:tcPr>"
                                + "<w:tcW w:type=\"dxa\" w:w=\"1626\"/>"
                                + "<w:tcBorders>"
                                    + "<w:top w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                    + "<w:left w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                    + "<w:bottom w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                    + "<w:right w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                +"</w:tcBorders>"
                                + "<w:shd w:color=\"auto\" w:fill=\"auto\" w:val=\"clear\"/>"
                                + "<w:tcMar>"
                                    + "<w:left w:type=\"dxa\" w:w=\"216\"/>"
                                    + "<w:right w:type=\"dxa\" w:w=\"216\"/>"
                                +"</w:tcMar>"
                                + "<w:vAlign w:val=\"center\"/>"
                            +"</w:tcPr>"
                            + "<w:p>"
                                + "<w:pPr>"
                                    + "<w:jc w:val=\"right\"/>"
                                    + "<w:rPr>"
                                        + "<w:rFonts w:ascii=\"Trebuchet MS\" w:hAnsi=\"Trebuchet MS\"/>"
                                        + "<w:b/>"
                                        + "<w:sz w:val=\"18\"/>"
                                        + "<w:szCs w:val=\"18\"/>"
                                    +"</w:rPr>"
                                +"</w:pPr>"
                                + "<w:r>"
                                    + "<w:rPr>"
                                        + "<w:rFonts w:ascii=\"Trebuchet MS\" w:hAnsi=\"Trebuchet MS\"/>"
                                        + "<w:b/>"
                                        + "<w:sz w:val=\"18\"/>"
                                        + "<w:szCs w:val=\"18\"/>"
                                    +"</w:rPr>"
                                    + "<w:t>Total</w:t>"
                                +"</w:r>"
                            +"</w:p>"
                        +"</w:tc>"
                        + "<w:tc>"
                            + "<w:tcPr>"
                                + "<w:tcW w:type=\"dxa\" w:w=\"1463\"/>"
                                + "<w:tcBorders>"
                                    + "<w:top w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                    + "<w:left w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                    + "<w:bottom w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                    + "<w:right w:color=\"auto\" w:space=\"0\" w:sz=\"4\" w:val=\"single\"/>"
                                +"</w:tcBorders>"
                                + "<w:shd w:color=\"auto\" w:fill=\"auto\" w:val=\"clear\"/>"
                                + "<w:tcMar>"
                                    + "<w:left w:type=\"dxa\" w:w=\"216\"/>"
                                    + "<w:right w:type=\"dxa\" w:w=\"216\"/>"
                                +"</w:tcMar>"
                                + "<w:vAlign w:val=\"center\"/>"
                            +"</w:tcPr>"
                            + "<w:p>"
                                + "<w:pPr>"
                                    + "<w:jc w:val=\"right\"/>"
                                    + "<w:rPr>"
                                        + "<w:rFonts w:ascii=\"Trebuchet MS\" w:hAnsi=\"Trebuchet MS\"/>"
                                        + "<w:sz w:val=\"18\"/>"
                                        + "<w:szCs w:val=\"18\"/>"
                                    +"</w:rPr>"
                                +"</w:pPr>"
                                + "<w:r>"
                                    + "<w:rPr>"
                                        + "<w:rFonts w:ascii=\"Trebuchet MS\" w:hAnsi=\"Trebuchet MS\"/>"
                                        + "<w:sz w:val=\"18\"/>"
                                        + "<w:szCs w:val=\"18\"/>"
                                    +"</w:rPr>"
                                    + "<w:t>$</w:t>"
                                +"</w:r>"
                                + "<w:r>"
                                    + "<w:rPr>"
                                        + "<w:rFonts w:ascii=\"Trebuchet MS\" w:hAnsi=\"Trebuchet MS\"/>"
                                        + "<w:sz w:val=\"18\"/>"
                                        + "<w:szCs w:val=\"18\"/>"
                                    +"</w:rPr>"
                                    + "<w:t>3</w:t>"
                                +"</w:r>"
                            +"</w:p>"
                        +"</w:tc>"
                    +"</w:tr>"
                +"</w:tbl>"
                + "<w:p>"
                    + "<w:pPr>"
                        + "<w:rPr>"
                            + "<w:rFonts w:ascii=\"Trebuchet MS\" w:hAnsi=\"Trebuchet MS\"/>"
                        +"</w:rPr>"
                    +"</w:pPr>"
                    + "<w:bookmarkStart w:id=\"0\" w:name=\"_GoBack\"/>"
                    + "<w:bookmarkEnd w:id=\"0\"/>"
                +"</w:p>"
                + "<w:sectPr>"
                    + "<w:pgSz w:h=\"15840\" w:w=\"12240\"/>"
                    + "<w:pgMar w:bottom=\"1440\" w:footer=\"720\" w:gutter=\"0\" w:header=\"720\" w:left=\"1800\" w:right=\"1800\" w:top=\"1440\"/>"
                    + "<w:cols w:space=\"720\"/>"
                    + "<w:docGrid w:linePitch=\"360\"/>"
                +"</w:sectPr>"
            +"</w:body>"
        +"</w:document>";
	
	
	    
}
