/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.calcengine;

import javax.ws.rs.core.MediaType;

//=============================================================================
public class CalcEngineConst
{
    //-------------------------------------------------------------------------
    public static final String CALCENGINE_CONTEXTPATH = "/calcengine";
    public static final String CALCENGINE_SERVLETPATH = "/";

    //-------------------------------------------------------------------------
    public static final String RELPATH_CALCULATE   = "calculate";
    public static final String RELPATH_EXECUTE     = "execute"  ;
    public static final String RELPATH_RESTORE     = "restore"  ;
    public static final String RELPATH_COPY        = "copy"     ;
    public static final String RELPATH_PASTE       = "paste"    ;
    public static final String RELPATH_INTERNAL    = "internal" ;
    public static final String RELPATH_ISALIVE     = RELPATH_INTERNAL + "/isalive"    ;
    public static final String RELPATH_SHUTDOWN    = RELPATH_INTERNAL + "/shutdown"   ;
    public static final String RELPATH_KILL        = RELPATH_INTERNAL + "/kill"       ;
    public static final String RELPATH_SETLOGLEVEL = RELPATH_INTERNAL + "/setloglevel";

    //-------------------------------------------------------------------------
    public static final String LOADBALANCERID_4_CALCENGINE_WORKER = "lb-4-calc-engine-worker";

    //-------------------------------------------------------------------------
    public static final String ENCODING_4_STREAMING = "UTF-8";

    //-------------------------------------------------------------------------
    public static final String MEDIATYPE_4_STREAMING = MediaType.APPLICATION_JSON + ";charset=" + ENCODING_4_STREAMING;

	//--------------------------------------------------------------------------
	public static final int EXITCODE_OK              = 0;
	public static final int EXITCODE_GENERAL_ERROR   = 1;
	public static final int EXITCODE_INVALID_CMDLINE = 2;
	public static final int EXITCODE_PORT_IN_USE     = 3;
	public static final int EXITCODE_KILLBILL        = 666;
}
