/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Source;
import org.apache.fop.fonts.CMapSegment;
import org.apache.fop.fonts.EmbeddingMode;
import org.apache.fop.fonts.FontDescriptor;
import org.apache.fop.fonts.FontResolver;
import org.apache.fop.fonts.FontType;
import org.apache.fop.fonts.FontUtil;
import org.apache.fop.fonts.MutableFont;
import org.apache.fop.fonts.Typeface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CustomFont
extends Typeface
implements FontDescriptor,
MutableFont {
    private String fontName = null;
    private String fullName = null;
    private Set<String> familyNames = null;
    private String fontSubName = null;
    private String embedFileName = null;
    private String embedResourceName = null;
    private FontResolver resolver = null;
    private EmbeddingMode embeddingMode = EmbeddingMode.AUTO;
    private int capHeight = 0;
    private int xHeight = 0;
    private int ascender = 0;
    private int descender = 0;
    private int[] fontBBox = new int[]{0, 0, 0, 0};
    private int flags = 4;
    private int weight = 0;
    private int stemV = 0;
    private int italicAngle = 0;
    private int missingWidth = 0;
    private FontType fontType = FontType.TYPE1;
    private int firstChar = 0;
    private int lastChar = 255;
    private Map<Integer, Map<Integer, Integer>> kerning;
    private boolean useKerning = true;
    private boolean useAdvanced = true;
    protected CMapSegment[] cmap;

    @Override
    public String getFontName() {
        return this.fontName;
    }

    @Override
    public String getEmbedFontName() {
        return this.getFontName();
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public Set<String> getFamilyNames() {
        return Collections.unmodifiableSet(this.familyNames);
    }

    public String getStrippedFontName() {
        return FontUtil.stripWhiteSpace(this.getFontName());
    }

    public String getFontSubName() {
        return this.fontSubName;
    }

    public String getEmbedFileName() {
        return this.embedFileName;
    }

    public EmbeddingMode getEmbeddingMode() {
        return this.embeddingMode;
    }

    public Source getEmbedFileSource() throws IOException {
        Source result = null;
        if (this.resolver != null && this.embedFileName != null && (result = this.resolver.resolve(this.embedFileName)) == null) {
            throw new IOException("Unable to resolve Source '" + this.embedFileName + "' for embedded font");
        }
        return result;
    }

    public String getEmbedResourceName() {
        return this.embedResourceName;
    }

    @Override
    public int getAscender() {
        return this.ascender;
    }

    @Override
    public int getDescender() {
        return this.descender;
    }

    @Override
    public int getCapHeight() {
        return this.capHeight;
    }

    @Override
    public int getAscender(int size) {
        return size * this.ascender;
    }

    @Override
    public int getDescender(int size) {
        return size * this.descender;
    }

    @Override
    public int getCapHeight(int size) {
        return size * this.capHeight;
    }

    @Override
    public int getXHeight(int size) {
        return size * this.xHeight;
    }

    @Override
    public int[] getFontBBox() {
        return this.fontBBox;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public boolean isSymbolicFont() {
        return (this.getFlags() & 4) != 0 || "ZapfDingbatsEncoding".equals(this.getEncodingName());
    }

    public int getWeight() {
        return this.weight;
    }

    @Override
    public int getStemV() {
        return this.stemV;
    }

    @Override
    public int getItalicAngle() {
        return this.italicAngle;
    }

    public int getMissingWidth() {
        return this.missingWidth;
    }

    @Override
    public FontType getFontType() {
        return this.fontType;
    }

    public int getFirstChar() {
        return this.firstChar;
    }

    public int getLastChar() {
        return this.lastChar;
    }

    public boolean isKerningEnabled() {
        return this.useKerning;
    }

    @Override
    public final boolean hasKerningInfo() {
        return this.isKerningEnabled() && this.kerning != null && !this.kerning.isEmpty();
    }

    @Override
    public final Map<Integer, Map<Integer, Integer>> getKerningInfo() {
        if (this.hasKerningInfo()) {
            return this.kerning;
        }
        return Collections.emptyMap();
    }

    public boolean isAdvancedEnabled() {
        return this.useAdvanced;
    }

    @Override
    public void setFontName(String name) {
        this.fontName = name;
    }

    @Override
    public void setFullName(String name) {
        this.fullName = name;
    }

    @Override
    public void setFamilyNames(Set<String> names) {
        this.familyNames = new HashSet<String>(names);
    }

    public void setFontSubFamilyName(String subFamilyName) {
        this.fontSubName = subFamilyName;
    }

    @Override
    public void setEmbedFileName(String path) {
        this.embedFileName = path;
    }

    @Override
    public void setEmbedResourceName(String name) {
        this.embedResourceName = name;
    }

    @Override
    public void setEmbeddingMode(EmbeddingMode embeddingMode) {
        this.embeddingMode = embeddingMode;
    }

    @Override
    public void setCapHeight(int capHeight) {
        this.capHeight = capHeight;
    }

    public void setXHeight(int xHeight) {
        this.xHeight = xHeight;
    }

    @Override
    public void setAscender(int ascender) {
        this.ascender = ascender;
    }

    @Override
    public void setDescender(int descender) {
        this.descender = descender;
    }

    @Override
    public void setFontBBox(int[] bbox) {
        this.fontBBox = bbox;
    }

    @Override
    public void setFlags(int flags) {
        this.flags = flags;
    }

    public void setWeight(int weight) {
        weight = weight / 100 * 100;
        weight = Math.max(100, weight);
        this.weight = weight = Math.min(900, weight);
    }

    @Override
    public void setStemV(int stemV) {
        this.stemV = stemV;
    }

    @Override
    public void setItalicAngle(int italicAngle) {
        this.italicAngle = italicAngle;
    }

    @Override
    public void setMissingWidth(int width) {
        this.missingWidth = width;
    }

    @Override
    public void setFontType(FontType fontType) {
        this.fontType = fontType;
    }

    @Override
    public void setFirstChar(int index) {
        this.firstChar = index;
    }

    @Override
    public void setLastChar(int index) {
        this.lastChar = index;
    }

    @Override
    public void setKerningEnabled(boolean enabled) {
        this.useKerning = enabled;
    }

    @Override
    public void setAdvancedEnabled(boolean enabled) {
        this.useAdvanced = enabled;
    }

    public void setResolver(FontResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public void putKerningEntry(Integer key, Map<Integer, Integer> value) {
        if (this.kerning == null) {
            this.kerning = new HashMap<Integer, Map<Integer, Integer>>();
        }
        this.kerning.put(key, value);
    }

    public void replaceKerningMap(Map<Integer, Map<Integer, Integer>> kerningMap) {
        this.kerning = kerningMap == null ? Collections.emptyMap() : kerningMap;
    }

    public void setCMap(CMapSegment[] cmap) {
        this.cmap = new CMapSegment[cmap.length];
        System.arraycopy(cmap, 0, this.cmap, 0, cmap.length);
    }

    public CMapSegment[] getCMap() {
        CMapSegment[] copy = new CMapSegment[this.cmap.length];
        System.arraycopy(this.cmap, 0, copy, 0, this.cmap.length);
        return copy;
    }
}

