/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow.table;

import java.util.List;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.flow.table.ColumnNumberManager;
import org.apache.fop.fo.flow.table.ColumnNumberManagerHolder;
import org.apache.fop.fo.flow.table.PendingSpan;
import org.apache.fop.fo.flow.table.Table;
import org.apache.fop.fo.flow.table.TableCell;
import org.apache.fop.fo.flow.table.TableColumn;
import org.apache.fop.fo.flow.table.TableEventProducer;
import org.apache.fop.fo.flow.table.TableFObj;
import org.apache.fop.fo.flow.table.TablePart;
import org.apache.fop.fo.properties.CommonAccessibility;
import org.apache.fop.fo.properties.CommonAccessibilityHolder;

public abstract class TableCellContainer
extends TableFObj
implements ColumnNumberManagerHolder,
CommonAccessibilityHolder {
    private CommonAccessibility commonAccessibility;
    protected List pendingSpans;
    protected ColumnNumberManager columnNumberManager;

    public TableCellContainer(FONode parent) {
        super(parent);
    }

    public void bind(PropertyList pList) throws FOPException {
        super.bind(pList);
        this.commonAccessibility = CommonAccessibility.getInstance(pList);
    }

    protected void addTableCellChild(TableCell cell, boolean firstRow) throws FOPException {
        int colNumber = cell.getColumnNumber();
        int colSpan = cell.getNumberColumnsSpanned();
        int rowSpan = cell.getNumberRowsSpanned();
        Table t = this.getTable();
        if (t.hasExplicitColumns()) {
            if (colNumber + colSpan - 1 > t.getNumberOfColumns()) {
                TableEventProducer eventProducer = TableEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
                eventProducer.tooManyCells(this, this.getLocator());
            }
        } else {
            t.ensureColumnNumber(colNumber + colSpan - 1);
            while (this.pendingSpans.size() < colNumber + colSpan - 1) {
                this.pendingSpans.add(null);
            }
        }
        if (firstRow) {
            this.handleCellWidth(cell, colNumber, colSpan);
        }
        if (rowSpan > 1) {
            for (int i = 0; i < colSpan; ++i) {
                this.pendingSpans.set(colNumber - 1 + i, new PendingSpan(rowSpan));
            }
        }
        this.columnNumberManager.signalUsedColumnNumbers(colNumber, colNumber + colSpan - 1);
        t.getRowGroupBuilder().addTableCell(cell);
    }

    private void handleCellWidth(TableCell cell, int colNumber, int colSpan) throws FOPException {
        Table t = this.getTable();
        Length colWidth = null;
        if (cell.getWidth().getEnum() != 9 && colSpan == 1) {
            colWidth = cell.getWidth();
        }
        for (int i = colNumber; i < colNumber + colSpan; ++i) {
            TableColumn col = t.getColumn(i - 1);
            if (colWidth == null) continue;
            col.setColumnWidth(colWidth);
        }
    }

    abstract TablePart getTablePart();

    public ColumnNumberManager getColumnNumberManager() {
        return this.columnNumberManager;
    }

    public CommonAccessibility getCommonAccessibility() {
        return this.commonAccessibility;
    }
}

