/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.wmf2svg.util;

import com.google.appengine.api.images.Image;
import com.google.appengine.api.images.ImagesService;
import com.google.appengine.api.images.ImagesServiceFactory;
import com.google.appengine.api.images.Transform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.DataBuffer;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class ImageUtil {
    private static Converter converter;

    public static byte[] convert(byte[] byArray, String string, boolean bl) {
        if (converter == null) {
            throw new UnsupportedOperationException("Image Conversion API(Image IO or GAE Image API) is missing.");
        }
        return converter.convert(byArray, string, bl);
    }

    static {
        if ("Production".equals(System.getProperty("com.google.appengine.runtime.environment"))) {
            converter = new GAEConverter();
        } else {
            try {
                Class.forName("javax.imageio.ImageIO");
                converter = new ImageIOConverter();
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    private static class GAEConverter
    implements Converter {
        private GAEConverter() {
        }

        public byte[] convert(byte[] byArray, String string, boolean bl) {
            if (string == null) {
                throw new IllegalArgumentException("dest type is null.");
            }
            string = string.toLowerCase();
            ImagesService.OutputEncoding outputEncoding = null;
            if ("png".equals(string)) {
                outputEncoding = ImagesService.OutputEncoding.PNG;
            } else if ("jpeg".equals(string)) {
                outputEncoding = ImagesService.OutputEncoding.JPEG;
            } else {
                throw new UnsupportedOperationException("unsupported image encoding: " + string);
            }
            ImagesService imagesService = ImagesServiceFactory.getImagesService();
            Image image = ImagesServiceFactory.makeImage((byte[])byArray);
            Transform transform = bl ? ImagesServiceFactory.makeVerticalFlip() : ImagesServiceFactory.makeCompositeTransform();
            return imagesService.applyTransform(transform, image, outputEncoding).getImageData();
        }
    }

    private static class ImageIOConverter
    implements Converter {
        private ImageIOConverter() {
        }

        public byte[] convert(byte[] byArray, String string, boolean bl) {
            if (string == null) {
                throw new IllegalArgumentException("dest type is null.");
            }
            string = string.toLowerCase();
            byte[] byArray2 = null;
            try {
                Object object;
                BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(byArray));
                BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 5);
                ColorConvertOp colorConvertOp = new ColorConvertOp(bufferedImage2.getColorModel().getColorSpace(), null);
                colorConvertOp.filter(bufferedImage, bufferedImage2);
                bufferedImage = bufferedImage2;
                if (bl) {
                    object = bufferedImage.getRaster().getDataBuffer();
                    BufferedImage bufferedImage3 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getType());
                    DataBuffer dataBuffer = bufferedImage3.getRaster().getDataBuffer();
                    int n = bufferedImage.getWidth() * bufferedImage.getColorModel().getPixelSize() / 8;
                    int n2 = 0;
                    int n3 = bufferedImage.getHeight() - 1;
                    while (n2 < bufferedImage.getHeight()) {
                        for (int i = 0; i < n; ++i) {
                            dataBuffer.setElem(n2 * n + i, ((DataBuffer)object).getElem(n3 * n + i));
                        }
                        ++n2;
                        --n3;
                    }
                    bufferedImage = bufferedImage3;
                }
                object = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedImage, string, (OutputStream)object);
                byArray2 = ((ByteArrayOutputStream)object).toByteArray();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return byArray2;
        }
    }

    private static interface Converter {
        public byte[] convert(byte[] var1, String var2, boolean var3);
    }
}

