/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.ooxml.pptx;

import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;


/**
 * {@link DummyOperations}
 *
 * @author <a href="mailto:kai.ahrens@open-xchange.com">Kai Ahrens</a>
 */
public class DummyOperations {

    /**
     * Initializes a new {@link DummyOperations}.
     */
    DummyOperations() {
    }

    /**
     * @return the final JSONObject
     */
    public static JSONObject createExportDocumentOperations() {

        final JSONObject aOperations = new JSONObject();
        final JSONArray aOperationsArray = new JSONArray();

        implAddExportOperations(aOperationsArray);

        try {
            aOperations.put("operations", aOperationsArray);
        } catch (JSONException e) {
            ;
        }

        return aOperations;
    }

    /**
     * @return the final JSONObject
     */
    public static JSONObject createImportDocumentOperations() {

        final JSONObject aOperations = new JSONObject();
        final JSONArray aOperationsArray = new JSONArray();

        implAddImportOperations(aOperationsArray);

        try {
            aOperations.put("operations", aOperationsArray);
        } catch (JSONException e) {
            ;
        }

        return aOperations;
    }

    /**
     * @param aOperationsArray
     */
    private static void implAddExportOperations(final JSONArray aOperationsArray) {
        implAddInsertTextOperation(
            aOperationsArray,
            0,
            -1,
            "Lorem ipsum dolor sit amet, consectetur adipisici elit, sed eiusmod tempor incidunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquid ex ea commodi consequat. Quis aute iure reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint obcaecat cupiditat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.");
    }

    /**
     * @param aOperationsArray
     */
    private static void implAddImportOperations(final JSONArray aOperationsArray) {

        // add all document operations to the JSONArray
        implAddInitDocumentOperation(aOperationsArray);

        implAddInsertTextOperation(
            aOperationsArray,
            0,
            -1,
            "Lorem ipsum dolor sit amet, consectetur adipisici elit, sed eiusmod tempor incidunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquid ex ea commodi consequat. Quis aute iure reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint obcaecat cupiditat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.");

        implAddInsertParagraphOperation(aOperationsArray, -1);
        implAddInsertParagraphOperation(aOperationsArray, -1);
        implAddInsertTextOperation(
            aOperationsArray,
            2,
            -1,
            "Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat.");

        implAddInsertParagraphOperation(aOperationsArray, -1);
        implAddInsertParagraphOperation(aOperationsArray, -1);
        implAddInsertTextOperation(
            aOperationsArray,
            4,
            -1,
            "Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi.");

        implAddInsertParagraphOperation(aOperationsArray, -1);
        implAddInsertParagraphOperation(aOperationsArray, -1);
        implAddInsertTextOperation(
            aOperationsArray,
            6,
            -1,
            "Nam liber tempor cum soluta nobis eleifend option congue nihil imperdiet doming id quod mazim placerat facer possim assum. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat.");

        implAddInsertParagraphOperation(aOperationsArray, -1);
        implAddInsertParagraphOperation(aOperationsArray, -1);
        implAddInsertTextOperation(
            aOperationsArray,
            8,
            -1,
            "Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis.");

        implAddInsertParagraphOperation(aOperationsArray, -1);
        implAddInsertParagraphOperation(aOperationsArray, -1);
        implAddInsertTextOperation(
            aOperationsArray,
            10,
            -1,
            "At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, At accusam aliquyam diam diam dolore dolores duo eirmod eos erat, et nonumy sed tempor et et invidunt justo labore Stet clita ea et gubergren, kasd magna no rebum. sanctus sea sed takimata ut vero voluptua. est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat.");
    }

    /**
     * @param aOperationsArray
     */
    private static void implAddInitDocumentOperation(final JSONArray aOperationsArray) {

        final JSONObject aInitDocumentObject = new JSONObject();

        try {
            aInitDocumentObject.put("name", "initDocument");

            aOperationsArray.put(aInitDocumentObject);
        } catch (JSONException e) {
            ;
        }
    }

    /**
     * @param aOperationsArray
     * @param nPara
     */
    private static void implAddInsertParagraphOperation(final JSONArray aOperationsArray, final int nPara) {

        final JSONObject aInsertParagraphObject = new JSONObject();

        List<Integer> aStartArray = new ArrayList<Integer>();
        aStartArray.add(nPara);

        try {
            aInsertParagraphObject.put("name", "insertParagraph");
            aInsertParagraphObject.put("start", aStartArray);

            aOperationsArray.put(aInsertParagraphObject);
        } catch (JSONException e) {
            ;
        }
    }

    /**
     * @param aOperationsArray
     * @param nPara
     * @param nPos
     * @param aText
     */
    private static void implAddInsertTextOperation(final JSONArray aOperationsArray, final int nPara, final int nPos, final String aText) {

        final JSONObject aInsertTextObject = new JSONObject();

        try {
            List<Integer> aStartArray = new ArrayList<Integer>();
            aStartArray.add(nPara);
            aStartArray.add(nPos);

            aInsertTextObject.put("name", "insertText");
            aInsertTextObject.put("start", aStartArray);
            aInsertTextObject.put("text", aText);

            aOperationsArray.put(aInsertTextObject);
        } catch (JSONException e) {
            ;
        }
    }

    /**
     * @param aOperationsArray
     * @param nPara
     * @param nStart
     * @param nEnd
     */
    @SuppressWarnings("unused")
    private static void implAddDeleteTextOperation(final JSONArray aOperationsArray, final int nPara, final int nStart, final int nEnd) {

        final JSONObject aDeleteTextObject = new JSONObject();

        try {
            List<Integer> aStartArray = new ArrayList<Integer>();
            aStartArray.add(nPara);
            aStartArray.add(nStart);

            List<Integer> aEndArray = new ArrayList<Integer>();
            aStartArray.add(nPara);
            aStartArray.add(nEnd);

            aDeleteTextObject.put("name", "deleteText");
            aDeleteTextObject.put("start", aStartArray);
            aDeleteTextObject.put("end", aEndArray);

            aOperationsArray.put(aDeleteTextObject);
        } catch (JSONException e) {
            ;
        }
    }

    /**
     * @param aOperationsArray
     * @param nPara
     * @param nStart
     * @param nEnd
     * @param aValue
     */
    @SuppressWarnings("unused")
    private static void implAddSetAttributeOperation(final JSONArray aOperationsArray, final int nPara, final int nStart, final int nEnd, final String aValue) {

        final JSONObject aSetAttributeObject = new JSONObject();

        try {
            List<Integer> aStartArray = new ArrayList<Integer>();
            aStartArray.add(nPara);
            aStartArray.add(nStart);

            List<Integer> aEndArray = new ArrayList<Integer>();
            aStartArray.add(nPara);
            aStartArray.add(nEnd);

            aSetAttributeObject.put("name", "setAttribute");
            aSetAttributeObject.put("start", aStartArray);
            aSetAttributeObject.put("end", aEndArray);
            aSetAttributeObject.put("value", aValue);

            aOperationsArray.put(aSetAttributeObject);
        } catch (JSONException e) {
            ;
        }
    }
}
