/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.json.actions;

import org.apache.commons.logging.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.office.json.tools.TemplateFilesScanner;
import com.openexchange.office.tools.ErrorCode;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.session.ServerSession;

public class GetTemplateListAction extends DocumentFilterAction {
    private static final Log LOG = com.openexchange.log.Log.loggerFor(GetTemplateListAction.class);

    private TemplateFilesScanner m_templateFilesScanner = null;

    /**
     * {@link GetTemplateListAction}
     *
     * @author <a href="mailto:carsten.driesner@open-xchange.com">Carsten Driesner</a>
     */

    @Action(method = RequestMethod.GET, name = "gettemplatelist", description = "Request to receive a list of possible template files.", parameters = {
        @Parameter(name = "session", description = "A session ID previously obtained from the login module."),
        @Parameter(name = "type", description = "The type of document templates to build up the list from."),
        @Parameter(name = "uid", description = "The unique id of the client application.")
    }, responseDescription = "Response with timestamp: A JSON object containing the list of templates or a certain type.")

    /**
     * Initializes a new {@link GetTemplateListAction}.
     * @param services
     */
    public GetTemplateListAction(ServiceLookup services, TemplateFilesScanner templateFilesScanner) {
        super(services);
        m_templateFilesScanner = templateFilesScanner;
    }

    /* (non-Javadoc)
     * @see com.openexchange.ajax.requesthandler.AJAXActionService#perform(com.openexchange.ajax.requesthandler.AJAXRequestData, com.openexchange.tools.session.ServerSession)
     */
    @Override
    public AJAXRequestResult perform(AJAXRequestData request, ServerSession session) throws OXException {
        final JSONObject jsonObj = new JSONObject();
        final String type = request.getParameter("type").toLowerCase();
        final JSONArray templates = new JSONArray();
        AJAXRequestResult requestResult = null;

        if ((null != request) && (null != session)) {
        	ErrorCode errorCode = m_templateFilesScanner.searchForTemplates(session, type, templates);
        	try {
                jsonObj.put("error", errorCode.getAsJSON());
                jsonObj.put("templates", templates);
        	} catch (JSONException e) {
        		LOG.error("Exception while creating JSONObject answering AJAXRequest gettemplatelist", e);
        	}
        }

        requestResult = new AJAXRequestResult(jsonObj);

        return requestResult;
    }
}
