/*
 *  Copyright 2010-2013, Plutext Pty Ltd.
 *
 *  This file is part of xlsx4j, a component of docx4j.

    docx4j is licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.

    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

 */
package org.xlsx4j.sml;

import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

import org.jvnet.jaxb2_commons.ppp.Child;
import org.xlsx4j.jaxb.Context;


/**
 * <p>Java class for CT_PatternFill complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType name="CT_PatternFill">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="fgColor" type="{http://schemas.openxmlformats.org/spreadsheetml/2006/main}CT_Color" minOccurs="0"/>
 *         &lt;element name="bgColor" type="{http://schemas.openxmlformats.org/spreadsheetml/2006/main}CT_Color" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="patternType" type="{http://schemas.openxmlformats.org/spreadsheetml/2006/main}ST_PatternType" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 *
 *
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "CT_PatternFill", propOrder = {
    "fgColor",
    "bgColor"
})
public class CTPatternFill implements Child, Cloneable
{
    protected CTColor fgColor;
    protected CTColor bgColor;
    @XmlAttribute(name = "patternType")
    protected STPatternType patternType;
    @XmlTransient
    private Object parent;

    public CTPatternFill clone() {
        final CTPatternFill clone = Context.getsmlObjectFactory().createCTPatternFill();
        if(fgColor!=null) {
            clone.fgColor = fgColor.clone();
            clone.fgColor.setParent(clone);
        }
        if(bgColor!=null) {
            clone.bgColor = bgColor.clone();
            clone.bgColor.setParent(clone);
        }
        clone.patternType = patternType;
        return clone;
    }

    /**
     * Gets the value of the fgColor property.
     *
     * @return
     *     possible object is
     *     {@link CTColor }
     *
     */
    public CTColor getFgColor() {
        return fgColor;
    }

    /**
     * Sets the value of the fgColor property.
     *
     * @param value
     *     allowed object is
     *     {@link CTColor }
     *
     */
    public void setFgColor(CTColor value) {
        this.fgColor = value;
    }

    /**
     * Gets the value of the bgColor property.
     *
     * @return
     *     possible object is
     *     {@link CTColor }
     *
     */
    public CTColor getBgColor() {
        return bgColor;
    }

    /**
     * Sets the value of the bgColor property.
     *
     * @param value
     *     allowed object is
     *     {@link CTColor }
     *
     */
    public void setBgColor(CTColor value) {
        this.bgColor = value;
    }

    /**
     * Gets the value of the patternType property.
     *
     * @return
     *     possible object is
     *     {@link STPatternType }
     *
     */
    public STPatternType getPatternType() {
        return patternType;
    }

    /**
     * Sets the value of the patternType property.
     *
     * @param value
     *     allowed object is
     *     {@link STPatternType }
     *
     */
    public void setPatternType(STPatternType value) {
        this.patternType = value;
    }

    /**
     * Gets the parent object in the object tree representing the unmarshalled xml document.
     *
     * @return
     *     The parent object.
     */
    public Object getParent() {
        return this.parent;
    }

    public void setParent(Object parent) {
        this.parent = parent;
    }

    /**
     * This method is invoked by the JAXB implementation on each instance when unmarshalling completes.
     *
     * @param parent
     *     The parent object in the object tree.
     * @param unmarshaller
     *     The unmarshaller that generated the instance.
     */
    public void afterUnmarshal(Unmarshaller unmarshaller, Object parent) {
        setParent(parent);
    }

}
