/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.jms.osgi;

import java.util.Properties;

import org.apache.commons.logging.Log;

import com.openexchange.config.ConfigurationService;
import com.openexchange.jms.IJMSServer;
import com.openexchange.jms.JMSEnv;
import com.openexchange.jms.JMSServer;
import com.openexchange.log.LogFactory;
import com.openexchange.office.tools.IPUtils;
import com.openexchange.osgi.HousekeepingActivator;

//=============================================================================
public class JMSActivator extends HousekeepingActivator
{
	//-------------------------------------------------------------------------
    private static final Log LOG = LogFactory.getLog(JMSActivator.class);

    // -----------------------------------------------------------------------------------
    private static final String LOGPREFIX = "JMS Env : com.openexchange.jms.osgi : ";

    //-------------------------------------------------------------------------
    @Override
    protected Class<?>[] getNeededServices()
    {
        return new Class<?>[] { ConfigurationService.class };
    }

	//-------------------------------------------------------------------------
	@Override
    protected void startBundle()
    	throws Exception
    {
    	try
    	{
    		LOG.info(LOGPREFIX+"initialize JMS environment ...");

    		impl_initJMSEnv                 ();
    		impl_startJMSServerIfConfigured ();
    		
    		LOG.info(LOGPREFIX+"OK.");
    	}
    	catch (Throwable ex)
    	{
    		LOG.error(ex.getMessage (), ex);
    		throw new RuntimeException(ex);
    	}
    }

    //-------------------------------------------------------------------------
	@Override
	protected void stopBundle()
		throws Exception
	{
    	try
    	{
    		LOG.info(LOGPREFIX+"deinitialize JMS environment ...");

    		impl_stopJMSServerIfRunning ();

    		LOG.info(LOGPREFIX+"OK.");
    	}
    	catch (Throwable ex)
    	{
    		LOG.error(ex.getMessage (), ex);
    	}
	}

	//-------------------------------------------------------------------------
    private void impl_initJMSEnv ()
        throws Exception
    {
		LOG.info(LOGPREFIX+"define JMS environment ...");

		final ConfigurationService aConfig = getService(ConfigurationService.class);
		final JMSEnv               aJMSEnv = JMSEnv.create();
		final Properties           lProps  = aConfig.getFile(JMSEnv.CONFIG_FILE);

		if (lProps.size() < 1)
			LOG.info(LOGPREFIX+"... not configured - wont be activated.");
		else
			aJMSEnv.init(lProps);

		LOG.info(LOGPREFIX+"OK.");
    }
    
	//-------------------------------------------------------------------------
    private void impl_startJMSServerIfConfigured ()
        throws Exception
    {
		final ConfigurationService aConfig   = getService(ConfigurationService.class);
		final String               sServerIP = aConfig.getProperty (JMSEnv.CFGPROP_JMS_SERVER_IP);
		
		if ( ! IPUtils.isMyIP (sServerIP))
			return;

		LOG.info(LOGPREFIX+"start JMS server ...");
		final IJMSServer iServer = JMSServer.get();
						 iServer.start();
		m_iServerHold =  iServer;
		LOG.info(LOGPREFIX+"OK.");

		LOG.info(LOGPREFIX+"register JMS server as service ...");
		registerService(IJMSServer.class, iServer);
		LOG.info(LOGPREFIX+"OK.");
    }

	//-------------------------------------------------------------------------
    private void impl_stopJMSServerIfRunning ()
        throws Exception
    {
    	final IJMSServer iServer = m_iServerHold;
		m_iServerHold = null;

		if (iServer != null)
		{
    		LOG.info(LOGPREFIX+"stop server ...");
			iServer.stop();
    		LOG.info(LOGPREFIX+"OK.");
		}	
    }

	//-------------------------------------------------------------------------
	private IJMSServer m_iServerHold = null;
}
