/**
 * OPEN-XCHANGE legal information
 *
 * All intellectual property rights in the Software are protected by
 * international copyright laws.
 *
 *
 * In some countries OX, OX Open-Xchange, open xchange and OXtender
 * as well as the corresponding Logos OX Open-Xchange and OX are registered
 * trademarks of the Open-Xchange, Inc. group of companies.
 * The use of the Logos is not covered by the GNU General Public License.
 * Instead, you are allowed to use these Logos according to the terms and
 * conditions of the Creative Commons License, Version 2.5, Attribution,
 * Non-commercial, ShareAlike, and the interpretation of the term
 * Non-commercial applicable to the aforementioned license is published
 * on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 * Please make sure that third-party modules and libraries are used
 * according to their respective licenses.
 *
 * Any modifications to this package must retain all copyright notices
 * of the original copyright holder(s) for the original code used.
 *
 * After any such modifications, the original and derivative code shall remain
 * under the copyright of the copyright holder(s) and/or original author(s)per
 * the Attribution and Assignment Agreement that can be located at
 * http://www.open-xchange.com/EN/developer/. The contributing author shall be
 * given Attribution for the derivative code and a license granting use.
 *
 *  Copyright (C) 2004-2014 Open-Xchange, Inc.
 *  Mail: info@open-xchange.com
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License, Version 2 as published
 *  by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc., 59
 *  Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package com.openxchange.office_communication.tools.logging;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;

import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.MDC;

import com.openxchange.office_communication.tools.logging.v2.Logger;

//=============================================================================
public class LogUtils
{
	//-------------------------------------------------------------------------
	private LogUtils ()
	{}

	//-------------------------------------------------------------------------
	public static void enableDebugLogging ()
	    throws Exception
	{
    	ch.qos.logback.classic.Logger aRootLog = (ch.qos.logback.classic.Logger) org.slf4j.LoggerFactory.getLogger(ch.qos.logback.classic.Logger.ROOT_LOGGER_NAME);
        aRootLog.setLevel(ch.qos.logback.classic.Level.DEBUG);

		LoggingAspect.LOG_LEVEL = "info";
	}

	//-------------------------------------------------------------------------
	public static void enablePIDLogging ()
	    throws Exception
	{
		final RuntimeMXBean aRuntime = ManagementFactory.getRuntimeMXBean();
		final String        sPID     = aRuntime.getName();
		MDC.put("PID", sPID);
	}
	
	//-------------------------------------------------------------------------
	public static void enableAutoFlushOnShutdown ()
		throws Exception
	{
		Runtime.getRuntime().addShutdownHook(new Thread ()
		{
			@Override
			public void run ()
			{
				try
				{
					final ch.qos.logback.classic.LoggerContext aLogContext = (ch.qos.logback.classic.LoggerContext) org.slf4j.LoggerFactory.getILoggerFactory();
					aLogContext.stop();
				}
				catch (Throwable ex)
				{}
			}
		});
	}
	
	//-------------------------------------------------------------------------
	public static void logErrorQuietly (final Logger    aLogger,
										final Throwable aError )
	{
		if (aLogger != null)
		{
			aLogger.forLevel (ELogLevel.E_ERROR)
			       .withError(aError)
			       .log      ();
		}
		else
		{
			System.err.println    (aError.getMessage());
			aError.printStackTrace(System.err);
		}
	}
	
	//-------------------------------------------------------------------------
	public static String formatContextVariables (final String[] lNames ,
											     final Object[] lValues)
	{
		Validate.notNull(lNames                         , "Invalid argument 'names'."        );
		Validate.notNull(lValues                        , "Invalid argument 'values'."       );
		Validate.isTrue (lNames.length == lValues.length, "Names and values are not in sync.");
		
		final StringBuffer sOut = new StringBuffer (256);
		sOut.append ("[");
		
		      boolean bAddSeparator = false;
		final int     c             = lNames.length;
		for (int i=0; i<c; i++)
		{
			final String sName  = lNames [i];
			final Object aValue = lValues[i];
			final String sValue = impl_toString (aValue);
			
			if (bAddSeparator == true)
				sOut.append (", ");
			else
				bAddSeparator = true;
			
			sOut.append (sName );
			sOut.append ("="   );
			sOut.append (sValue);
		}
		
		sOut.append ("]");
		return sOut.toString ();
	}

	//-------------------------------------------------------------------------
	@SuppressWarnings("deprecation")
	private static String impl_toString (final Object aObject)
	{
		return ObjectUtils.toString(aObject);
	}
}
