/**
 * OPEN-XCHANGE legal information
 *
 * All intellectual property rights in the Software are protected by
 * international copyright laws.
 *
 *
 * In some countries OX, OX Open-Xchange, open xchange and OXtender
 * as well as the corresponding Logos OX Open-Xchange and OX are registered
 * trademarks of the Open-Xchange, Inc. group of companies.
 * The use of the Logos is not covered by the GNU General Public License.
 * Instead, you are allowed to use these Logos according to the terms and
 * conditions of the Creative Commons License, Version 2.5, Attribution,
 * Non-commercial, ShareAlike, and the interpretation of the term
 * Non-commercial applicable to the aforementioned license is published
 * on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 * Please make sure that third-party modules and libraries are used
 * according to their respective licenses.
 *
 * Any modifications to this package must retain all copyright notices
 * of the original copyright holder(s) for the original code used.
 *
 * After any such modifications, the original and derivative code shall remain
 * under the copyright of the copyright holder(s) and/or original author(s)per
 * the Attribution and Assignment Agreement that can be located at
 * http://www.open-xchange.com/EN/developer/. The contributing author shall be
 * given Attribution for the derivative code and a license granting use.
 *
 *  Copyright (C) 2004-2014 Open-Xchange, Inc.
 *  Mail: info@open-xchange.com
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License, Version 2 as published
 *  by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc., 59
 *  Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package com.openxchange.office_communication.tools.logging;

import org.apache.commons.lang3.StringUtils;

//=============================================================================
public enum ELogLevel
{
	//-------------------------------------------------------------------------
	E_FATAL,
	E_ERROR,
	E_WARNING,
	E_INFO,
	E_DEBUG,
	E_TRACE;

	//-------------------------------------------------------------------------
	public static final int INT_LEVEL_FATAL   = 0;
	public static final int INT_LEVEL_ERROR   = 1;
	public static final int INT_LEVEL_WARNING = 2;
	public static final int INT_LEVEL_INFO    = 3;
	public static final int INT_LEVEL_DEBUG   = 4;
	public static final int INT_LEVEL_TRACE   = 5;

	//-------------------------------------------------------------------------
	public static final String STR_LEVEL_FATAL   = "fatal"  ;
	public static final String STR_LEVEL_ERROR   = "error"  ;
	public static final String STR_LEVEL_WARNING = "warning";
	public static final String STR_LEVEL_INFO    = "info"   ;
	public static final String STR_LEVEL_DEBUG   = "debug"  ;
	public static final String STR_LEVEL_TRACE   = "trace"  ;

	//-------------------------------------------------------------------------
	public static int toInt (final ELogLevel eLevel)
	{
		if (eLevel == ELogLevel.E_FATAL)
			return INT_LEVEL_FATAL;
		else
		if (eLevel == ELogLevel.E_ERROR)
			return INT_LEVEL_ERROR;
		else
		if (eLevel == ELogLevel.E_WARNING)
			return INT_LEVEL_WARNING;
		else
		if (eLevel == ELogLevel.E_INFO)
			return INT_LEVEL_INFO;
		else
		if (eLevel == ELogLevel.E_DEBUG)
			return INT_LEVEL_DEBUG;
		else
		if (eLevel == ELogLevel.E_TRACE)
			return INT_LEVEL_TRACE;
		else
			throw new UnsupportedOperationException ("No support for log level '"+eLevel+"' implemented yet.");
	}

	//-------------------------------------------------------------------------
	public static ELogLevel fromString (final String    sString ,
			                            final ELogLevel eDefault)
	{
		if (StringUtils.isEmpty(sString))
			return eDefault;
		
		if (StringUtils.equalsIgnoreCase(sString, STR_LEVEL_FATAL))
			return ELogLevel.E_FATAL;
		else
		if (StringUtils.equalsIgnoreCase(sString, STR_LEVEL_ERROR))
			return ELogLevel.E_ERROR;
		else
		if (StringUtils.equalsIgnoreCase(sString, STR_LEVEL_WARNING))
			return ELogLevel.E_WARNING;
		else
		if (StringUtils.equalsIgnoreCase(sString, STR_LEVEL_INFO))
			return ELogLevel.E_INFO;
		else
		if (StringUtils.equalsIgnoreCase(sString, STR_LEVEL_DEBUG))
			return ELogLevel.E_DEBUG;
		else
		if (StringUtils.equalsIgnoreCase(sString, STR_LEVEL_TRACE))
			return ELogLevel.E_TRACE;
		else
			throw new UnsupportedOperationException ("No support for log level '"+sString+"' implemented yet.");
	}

	//-------------------------------------------------------------------------
	public static String toString (final ELogLevel eLevel)
	{
		if (eLevel == ELogLevel.E_FATAL)
			return STR_LEVEL_FATAL;
		else
		if (eLevel == ELogLevel.E_ERROR)
			return STR_LEVEL_ERROR;
		else
		if (eLevel == ELogLevel.E_WARNING)
			return STR_LEVEL_WARNING;
		else
		if (eLevel == ELogLevel.E_INFO)
			return STR_LEVEL_INFO;
		else
		if (eLevel == ELogLevel.E_DEBUG)
			return STR_LEVEL_DEBUG;
		else
		if (eLevel == ELogLevel.E_TRACE)
			return STR_LEVEL_TRACE;
		else
			throw new UnsupportedOperationException ("No support for log level '"+eLevel+"' implemented yet.");
	}

	//-------------------------------------------------------------------------
	public static boolean isActive (final ELogLevel eWorkLevel ,
									final ELogLevel eCheckLevel)
	{
		final int     nWorkLevel  = ELogLevel.toInt(eWorkLevel );
		final int     nCheckLevel = ELogLevel.toInt(eCheckLevel);
		final boolean bActive     = nCheckLevel <= nWorkLevel;
		return bActive;
	}

	//-------------------------------------------------------------------------
	public boolean greaterThan (ELogLevel eCheck)
	{
		final int     nThisLevel   = ELogLevel.toInt (this  );
		final int     nCheckLevel  = ELogLevel.toInt (eCheck);
		final boolean bGreaterThan = (nCheckLevel < nThisLevel);
		return bGreaterThan;
	}
	
	//-------------------------------------------------------------------------
	public boolean lessThan (ELogLevel eCheck)
	{
		final int     nThisLevel  = ELogLevel.toInt (this  );
		final int     nCheckLevel = ELogLevel.toInt (eCheck);
		final boolean bLessThan   = (nCheckLevel > nThisLevel);
		return bLessThan;
	}
}
