/**
 * OPEN-XCHANGE legal information
 *
 * All intellectual property rights in the Software are protected by
 * international copyright laws.
 *
 *
 * In some countries OX, OX Open-Xchange, open xchange and OXtender
 * as well as the corresponding Logos OX Open-Xchange and OX are registered
 * trademarks of the Open-Xchange, Inc. group of companies.
 * The use of the Logos is not covered by the GNU General Public License.
 * Instead, you are allowed to use these Logos according to the terms and
 * conditions of the Creative Commons License, Version 2.5, Attribution,
 * Non-commercial, ShareAlike, and the interpretation of the term
 * Non-commercial applicable to the aforementioned license is published
 * on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 * Please make sure that third-party modules and libraries are used
 * according to their respective licenses.
 *
 * Any modifications to this package must retain all copyright notices
 * of the original copyright holder(s) for the original code used.
 *
 * After any such modifications, the original and derivative code shall remain
 * under the copyright of the copyright holder(s) and/or original author(s)per
 * the Attribution and Assignment Agreement that can be located at
 * http://www.open-xchange.com/EN/developer/. The contributing author shall be
 * given Attribution for the derivative code and a license granting use.
 *
 *  Copyright (C) 2004-2014 Open-Xchange, Inc.
 *  Mail: info@open-xchange.com
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License, Version 2 as published
 *  by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc., 59
 *  Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package com.openxchange.office_communication.tools.exec.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;

import com.openxchange.office_communication.tools.exec.IExecutableWatcher;

//==============================================================================
public class ExecutableWatch
{
    //--------------------------------------------------------------------------
	public static final int INIT_BUFFER_SIZE = 8 * 1024       ; // 8kb
	public static final int MAX_BUFFER_SIZE  = 5 * 1024 * 1024; // 5mb
//	public static final int INIT_BUFFER_SIZE = 100;
//	public static final int MAX_BUFFER_SIZE  = 100;
	
    //--------------------------------------------------------------------------
	public ExecutableWatch ()
	    throws Exception
	{}

	//--------------------------------------------------------------------------
	public synchronized void addWatcher (final IExecutableWatcher iWatcher)
	    throws Exception
	{
		final Map< String, IExecutableWatcher > aRegistry = mem_Registry ();
		final String[]                          lWatches  = iWatcher.getWatchPoints();

		if (lWatches == null)
			return;

		for (String sWatch : lWatches)
			aRegistry.put(sWatch, iWatcher);
		
		m_nWatchPointCount += lWatches.length;
	}

	//--------------------------------------------------------------------------
	public synchronized void scanForWatches (final String sContent)
	    throws Exception
	{
		// a) all watch points was detected ...
		//    no need to work further ...
		//    ignore all request for now (in the hope caller will stop calling us)

		if (allWatchPointsDetected ())
			return;
		
		// b) in case not all watch points was detected ...
		//    trim our internal buffer so we don't 'eat memory'.
		
		      StringBuffer aBuffer     = mem_Buffer ();
		final int          nBufferSize = aBuffer.length();
		if (nBufferSize > MAX_BUFFER_SIZE)
			aBuffer = impl_trimBuffer ();
		aBuffer.append (sContent);
		
		final Map< String, IExecutableWatcher > aRegistry = mem_Registry ();
		final String                            sCheck    = aBuffer.toString ();
		final Iterator< String >                pWatches  = aRegistry.keySet().iterator();

		while (pWatches.hasNext())
		{
			final String sWatch = pWatches.next();
			if ( ! StringUtils.contains(sCheck, sWatch))
				continue;

			m_nDetectedWatchPoints++;
			final IExecutableWatcher iWatcher = aRegistry.get(sWatch);

			if (iWatcher == null)
				break;

			aRegistry.remove(sWatch);
			try
			{
				iWatcher.watchPointDetected(sWatch);
			}
			catch (Exception ex)
			{
			    // no handling by intention !
				// be robust even if listener isnt robust enough ;-)
			}

			break;
		}
	}

	//--------------------------------------------------------------------------
	public synchronized boolean allWatchPointsDetected ()
		throws Exception
	{
		final boolean bAllDetected = (m_nDetectedWatchPoints >= m_nWatchPointCount);
		return bAllDetected;
	}
	
	//--------------------------------------------------------------------------
	private StringBuffer impl_trimBuffer ()
		throws Exception
	{
		final int    nTrimStart = Math.round(MAX_BUFFER_SIZE / 2);
		final String sTrimmed   = m_aBuffer.substring(nTrimStart);
System.err.println ("trimmed : ["+sTrimmed+"]");
		m_aBuffer = new StringBuffer (sTrimmed);
		return m_aBuffer;
	}
	
	//--------------------------------------------------------------------------
	private Map< String, IExecutableWatcher > mem_Registry ()
		throws Exception
	{
		if (m_lRegistry == null)
			m_lRegistry = new HashMap< String, IExecutableWatcher >();
		return m_lRegistry;
	}

	//--------------------------------------------------------------------------
	private StringBuffer mem_Buffer ()
	    throws Exception
	{
		if (m_aBuffer == null)
			m_aBuffer = new StringBuffer (INIT_BUFFER_SIZE);
		return m_aBuffer;
	}

	//--------------------------------------------------------------------------
	private Map< String, IExecutableWatcher > m_lRegistry = null;

	//--------------------------------------------------------------------------
	private int m_nWatchPointCount = 0;
	
	//--------------------------------------------------------------------------
	private int m_nDetectedWatchPoints = 0;
	
	//--------------------------------------------------------------------------
	private StringBuffer m_aBuffer = null;
}
