/**
 * OPEN-XCHANGE legal information
 *
 * All intellectual property rights in the Software are protected by
 * international copyright laws.
 *
 *
 * In some countries OX, OX Open-Xchange, open xchange and OXtender
 * as well as the corresponding Logos OX Open-Xchange and OX are registered
 * trademarks of the Open-Xchange, Inc. group of companies.
 * The use of the Logos is not covered by the GNU General Public License.
 * Instead, you are allowed to use these Logos according to the terms and
 * conditions of the Creative Commons License, Version 2.5, Attribution,
 * Non-commercial, ShareAlike, and the interpretation of the term
 * Non-commercial applicable to the aforementioned license is published
 * on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 * Please make sure that third-party modules and libraries are used
 * according to their respective licenses.
 *
 * Any modifications to this package must retain all copyright notices
 * of the original copyright holder(s) for the original code used.
 *
 * After any such modifications, the original and derivative code shall remain
 * under the copyright of the copyright holder(s) and/or original author(s)per
 * the Attribution and Assignment Agreement that can be located at
 * http://www.open-xchange.com/EN/developer/. The contributing author shall be
 * given Attribution for the derivative code and a license granting use.
 *
 *  Copyright (C) 2004-2014 Open-Xchange, Inc.
 *  Mail: info@open-xchange.com
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License, Version 2 as published
 *  by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc., 59
 *  Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package com.openxchange.office_communication.configuration.configitems;

import com.openxchange.office_communication.configuration.ConfigAccess;
import com.openxchange.office_communication.tools.config.IComplexConfiguration;

//=============================================================================
public class CacheServerConfig
{
	//-------------------------------------------------------------------------
	public static final String CONFIG_PACKAGE = "/cache/server";

	//-------------------------------------------------------------------------
	public static final String CFGKEY_PREFIX = "cache.server";
	
	//-------------------------------------------------------------------------
	public static final String CFGKEY_SERVER_INTERFACE = CFGKEY_PREFIX+".interface";
	public static final String CFGKEY_SERVER_HOST      = CFGKEY_PREFIX+".host";
	public static final String CFGKEY_SERVER_PORT      = CFGKEY_PREFIX+".port";
	public static final String CFGKEY_SERVER_ID        = CFGKEY_PREFIX+".id";
	public static final String CFGKEY_SERVER_PASSWORD  = CFGKEY_PREFIX+".password";
	
	//-------------------------------------------------------------------------
	private CacheServerConfig ()
	    throws Exception
	{}

	//-------------------------------------------------------------------------
	public static CacheServerConfig access ()
		throws Exception
	{
		final CacheServerConfig aConfig = new CacheServerConfig ();
		return aConfig;
	}

	//-------------------------------------------------------------------------
	public String getInterface ()
	    throws Exception
	{
		return mem_Config ().get(CFGKEY_SERVER_INTERFACE, String.class);
	}
	
	//-------------------------------------------------------------------------
	public String getHost ()
	    throws Exception
	{
		return mem_Config ().get(CFGKEY_SERVER_HOST, String.class);
	}

	//-------------------------------------------------------------------------
	public int getPort ()
	    throws Exception
	{
		return mem_Config ().get(CFGKEY_SERVER_PORT, int.class);
	}

	//-------------------------------------------------------------------------
	public String getPortAsString ()
	    throws Exception
	{
		return Integer.toString(getPort());
	}
	
	//-------------------------------------------------------------------------
	public String getId ()
	    throws Exception
	{
		return mem_Config ().get(CFGKEY_SERVER_ID, String.class);
	}

	//-------------------------------------------------------------------------
	public String getPassword ()
	    throws Exception
	{
		return mem_Config ().get(CFGKEY_SERVER_PASSWORD, String.class);
	}

	//-------------------------------------------------------------------------
	final IComplexConfiguration mem_Config ()
	    throws Exception
	{
		if (m_iConfig == null)
			m_iConfig = ConfigAccess.accessConfig(CONFIG_PACKAGE);
		return m_iConfig;
	}

	//-------------------------------------------------------------------------
	private IComplexConfiguration m_iConfig = null;
}
