/*
 * Decompiled with CFR 0.152.
 */
package org.json.hash;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.json.hash.HashKey;
import org.json.hash.HashKeyEntrySet;
import org.json.hash.HashKeySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HashKeyMap<V>
implements Map<String, V> {
    private final Map<HashKey, V> map;

    public HashKeyMap() {
        this(new LinkedHashMap());
    }

    public HashKeyMap(int initialCapacity) {
        this(new LinkedHashMap(initialCapacity));
    }

    public HashKeyMap(Map<HashKey, V> map) {
        this.map = map;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(HashKey.valueOf(key.toString()));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.map.get(HashKey.valueOf(key.toString()));
    }

    @Override
    public V put(String key, V value) {
        return this.map.put(HashKey.valueOf(key), value);
    }

    @Override
    public V remove(Object key) {
        return this.map.remove(HashKey.valueOf(key.toString()));
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> m) {
        if (m == null || m.isEmpty()) {
            return;
        }
        for (Map.Entry<String, V> e : m.entrySet()) {
            this.map.put(HashKey.valueOf(e.getKey()), e.getValue());
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<String> keySet() {
        return new HashKeySet(this.map.keySet());
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        return new HashKeyEntrySet<V>(this.map.entrySet());
    }

    @Override
    public boolean equals(Object o) {
        return this.map.equals(o);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }
}

