/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.office.calcengine.worker;

import com.openexchange.office.calcengine.client.impl.CalcEngineHttpEntityReader;
import com.openexchange.office.calcengine.client.impl.CalcEngineHttpEntityWriter;
import com.openexchange.office.calcengine.servlets.CalcEngineWorkerServlet;
import com.openexchange.office.calcengine.worker.JettyToApacheLoggingBridge;
import com.openexchange.office.calcengine.worker.WorkerCommandLine;
import com.openexchange.office.tools.logging.ELogFramework;
import com.openexchange.office.tools.logging.LogFactory;
import com.sun.jersey.api.core.DefaultResourceConfig;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.util.Set;
import javax.servlet.Servlet;
import javax.ws.rs.core.Application;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class WorkerMain {
    private static final Log LOG = LogFactory.getLog(WorkerMain.class);
    public static final String DEFAULT_INTERFACE = "0.0.0.0";
    public static final int EXIT_OK = 0;
    public static final int EXIT_GENERAL_ERROR = -1;
    public static final int EXIT_INVALID_CMDLINE = -2;
    public static final int EXIT_PORT_IN_USE = -3;

    public static void main(String[] lArgs) {
        LogFactory.establishLog4JStdOutMode();
        LogFactory.establishJDKLog2Log4JMode();
        LogFactory.switchLogFramework((ELogFramework)ELogFramework.E_STD);
        JettyToApacheLoggingBridge.register();
        LOG.info((Object)"worker main ...");
        try {
            WorkerMain aWorker = new WorkerMain();
            aWorker.impl_start(lArgs);
            LOG.info((Object)"worker finished normal ...");
        }
        catch (BindException exBind) {
            LOG.error((Object)"port already used ...", (Throwable)exBind);
            System.exit(-3);
        }
        catch (Throwable ex) {
            LOG.error((Object)"worker finished unexpected ...", ex);
            System.exit(-1);
        }
        System.exit(0);
    }

    private void impl_start(String[] lArgs) throws Exception {
        WorkerCommandLine aCmdLine = new WorkerCommandLine();
        aCmdLine.parse(lArgs);
        if (aCmdLine.needsHelp()) {
            aCmdLine.printHelp();
            System.exit(-2);
        }
        String sInterface = aCmdLine.getInterface();
        int nPort = aCmdLine.getPort();
        boolean bDoSimulation = aCmdLine.isSimulationOn();
        if (StringUtils.isEmpty((String)sInterface)) {
            sInterface = DEFAULT_INTERFACE;
        }
        if (bDoSimulation) {
            CalcEngineWorkerServlet.SIMULATION_MODE = true;
        }
        this.impl_startFromCode(sInterface, nPort);
    }

    private void impl_startFromCode(String sInterface, int nPort) throws Exception {
        LOG.info((Object)("worker will listen on interface='" + sInterface + "', port=" + nPort + " ..."));
        Server aServer = new Server(new InetSocketAddress(sInterface, nPort));
        ServletContextHandler aHandler = new ServletContextHandler();
        CalcEngineWorkerServlet aServlet = new CalcEngineWorkerServlet();
        DefaultResourceConfig aApp = new DefaultResourceConfig();
        LOG.info((Object)"configure marshalling environment ...");
        Set lClasses = aApp.getClasses();
        lClasses.add(CalcEngineHttpEntityWriter.class);
        lClasses.add(CalcEngineHttpEntityReader.class);
        LOG.info((Object)"worker register servlets ...");
        aApp.getSingletons().add(aServlet);
        ServletContainer aServletContainer = new ServletContainer((Application)aApp);
        aHandler.setContextPath("/calcengine");
        aHandler.addServlet(new ServletHolder((Servlet)aServletContainer), "/*");
        aServer.setHandler((Handler)aHandler);
        LOG.info((Object)"worker starts ...");
        aServer.start();
        LOG.info((Object)"worker started successfully ...");
        aServer.join();
    }
}

