package com.openexchange.office.tools.logging.impl;

import java.io.IOException;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

//=============================================================================
class BufferedResponseWrapper extends HttpServletResponseWrapper
{
	//-------------------------------------------------------------------------
	public BufferedResponseWrapper(final HttpServletResponse aResponse)
		throws IOException
	{
		super(aResponse);
	}

	//-------------------------------------------------------------------------
    public String getBuffer()
    	throws Exception
    {
    	return mem_Buffer ().toString ();
    }

	//-------------------------------------------------------------------------
	@Override
	public ServletOutputStream getOutputStream()
		throws IOException
	{
		try
		{
			return mem_BufferStream();
		}
		catch (Exception ex)
		{
			System.err.println (ex.getMessage());
			ex.printStackTrace(System.err);
		}
		
		return super.getOutputStream();
	}

	//-------------------------------------------------------------------------
    private StringBuffer mem_Buffer ()
        throws Exception
    {
    	if (m_sBuffer == null)
    		m_sBuffer = new StringBuffer (256);
    	return m_sBuffer;
    }
    
	//-------------------------------------------------------------------------
    private BufferedServletOutputStream mem_BufferStream ()
        throws Exception
    {
    	if (m_aBufferStream == null)
    		m_aBufferStream = new BufferedServletOutputStream (mem_Buffer(), super.getOutputStream());
    	return m_aBufferStream;
    }
    
	//-------------------------------------------------------------------------
    private StringBuffer m_sBuffer = null;

	//-------------------------------------------------------------------------
    private BufferedServletOutputStream m_aBufferStream = null;
}