/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.realtime.impl;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CellRange {
    int startCol;
    int startRow;
    int endCol;
    int endRow;
    public CellRange(JSONObject range) {
        try {
            JSONArray start = range.getJSONArray("start");
            JSONArray end;
            if(range.has("end"))
                end = range.getJSONArray("end");
            else
                end = start;
            startCol = start.getInt(0);
            startRow = start.getInt(1);
            endCol = end.getInt(0);
            endRow = end.getInt(1);
        } catch (JSONException e) {
        }
    }
    public JSONObject write() {
        JSONObject ret = new JSONObject();
        JSONArray pos = new JSONArray();
        try {
            pos.put(0, startCol);
            pos.put(1, startRow);
            ret.put("start", pos);
            if(startCol != endCol || startRow != endRow)
            {
                pos.reset();
                pos.put(0, endCol);
                pos.put(1, endRow);
                ret.put("end", pos);
            }
        } catch (JSONException e) {
        }
        return ret;
    }
    public boolean merge(CellRange other) {
        if(startCol <= other.startCol && startRow <= other.startRow &&endCol >= other.endCol && endRow >= other.endRow) { //other is included
            return true;
        } else if( ( startCol == other.startCol && endCol == other.endCol && ((startRow <= other.startRow - 1 && endRow <= other.endRow - 1) || (startRow >= other.startRow + 1 && endRow >= other.endRow + 1 ) ))  ||  //same columns, extending rows
                ( startRow == other.startRow && endRow == other.endRow && ((startCol <= other.startCol - 1 && endCol <= other.endCol - 1) || (startCol >= other.startCol + 1 && endCol >= other.endCol + 1 ) ))) // same row, extending columns
            {
                startCol = Math.min(startCol, other.startCol);
                endCol = Math.max(endCol, other.endCol);
                startRow = Math.min(startRow, other.startRow);
                endRow = Math.max(endRow, other.endRow);
                return true;

        } else {
            return false;
        }
    }

}
