/*
 * Copyright 2014 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.odftoolkit.odfdom.component;

import org.odftoolkit.odfdom.dom.element.OdfStylableElement;

/**
 *
 * @author svante.schubert AT gmail DOT com
 */
public interface TableChange {	
	/** Effects the tableElement provided as first parameter, e.g. format, insert, delete */ 
	public Object execute(OdfStylableElement tableElement, Object... args);
	/** An action should declare if XML column elements are effected. */ 
	public boolean effectsColumns();
	/** An action should declare if XML row elements are effected. */
	public boolean effectsRows();
	/** An action should declare if XML cell elements are effected. */
	public boolean effectsCells();
}
