package com.openexchange.office.calcengine.client.impl.jms;

import org.apache.commons.lang.StringUtils;

public enum ECalcEngineMethod
{
    //-------------------------------------------------------------------------
	E_CREATE_DOCUMENT,
	E_DESTROY_DOCUMENT,
	E_EXECUTE_OPERATION,
	E_GET_VERSION;
	
    //-------------------------------------------------------------------------
	public static final String METHODSTR_CREATE_DOCUMENT   = "create-document"  ;
	public static final String METHODSTR_DESTROY_DOCUMENT  = "destroy-document" ;
	public static final String METHODSTR_EXECUTE_OPERATION = "execute-operation";
	public static final String METHODSTR_GET_VERSION       = "get-version"      ;

    //-------------------------------------------------------------------------
	public static ECalcEngineMethod fromString (final String sMethod)
	    throws Exception
	{
		ECalcEngineMethod eMethod = null;

		if (StringUtils.equalsIgnoreCase(sMethod, METHODSTR_CREATE_DOCUMENT))
			eMethod = E_CREATE_DOCUMENT;
		else
		if (StringUtils.equalsIgnoreCase(sMethod, METHODSTR_DESTROY_DOCUMENT))
			eMethod = E_DESTROY_DOCUMENT;
		else
		if (StringUtils.equalsIgnoreCase(sMethod, METHODSTR_EXECUTE_OPERATION))
			eMethod = E_EXECUTE_OPERATION;
		else
		if (StringUtils.equalsIgnoreCase(sMethod, METHODSTR_GET_VERSION))
			eMethod = E_GET_VERSION;
		else
			throw new UnsupportedOperationException ("no support for '"+sMethod+"' implemented yet");

		return eMethod;
	}

    //-------------------------------------------------------------------------
	public static String toString (final ECalcEngineMethod eMethod)
	    throws Exception
	{
		String sMethod = null;
		
		if (eMethod == E_CREATE_DOCUMENT)
			sMethod = METHODSTR_CREATE_DOCUMENT;
		else
		if (eMethod == E_DESTROY_DOCUMENT)
			sMethod = METHODSTR_DESTROY_DOCUMENT;
		else
		if (eMethod == E_EXECUTE_OPERATION)
			sMethod = METHODSTR_EXECUTE_OPERATION;
		else
		if (eMethod == E_GET_VERSION)
			sMethod = METHODSTR_GET_VERSION;
		else
			throw new UnsupportedOperationException ("no support for '"+eMethod+"' implemented yet");
		
		return sMethod;
	}
}
