/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.calcengine.client.impl;

import com.openexchange.office.calcengine.client.CalcEngineClipBoardEvent;
import com.openexchange.office.calcengine.client.ECalcEngineError;
import com.openexchange.office.calcengine.client.ICalcEngineClient;
import com.openexchange.office.tools.logging.ELogLevel;
import com.openexchange.office.tools.monitoring.CalcEngineEvent;
import com.openexchange.office.tools.monitoring.CalcEngineEventType;
import com.openexchange.office.tools.monitoring.Statistics;

/**
 * {@link CalcEngineClientMonitoring}
 *
 * @author <a href="mailto:kai.ahrens@open-xchange.com">Kai Ahrens</a>
 */
public class CalcEngineClientMonitoring implements ICalcEngineClient {

    //private static final Log LOG = LogFactory.getJclLog(CalcEngineClientMonitoring.class);

    /**
     * Initializes a new {@link CalcEngineClientMonitoring}.
     */
    private CalcEngineClientMonitoring() {
    }

    /**
     * @param iWrapped
     * @return
     * @throws Exception
     */
    public static synchronized CalcEngineClientMonitoring create(final ICalcEngineClient iWrapped) throws Exception {
        final CalcEngineClientMonitoring aInst = new CalcEngineClientMonitoring();
        aInst.m_iWrapped = iWrapped;
        return aInst;
    }

    /* (non-Javadoc)
     * @see com.openexchange.office.calcengine.client.ICalcEngineClient#createDocument()
     */
    @Override
    public String createDocument() throws Exception {
        final String ret = m_iWrapped.createDocument();

        Statistics.handleDocumentEvent(new CalcEngineEvent(CalcEngineEventType.DOC_INIT));

        return ret;
    };

    /* (non-Javadoc)
     * @see com.openexchange.office.calcengine.client.ICalcEngineClient#destroyDocument(java.lang.String)
     */
    @Override
    public void destroyDocument(final String sDocHandle) throws Exception {
        m_iWrapped.destroyDocument(sDocHandle);
        Statistics.handleDocumentEvent(new CalcEngineEvent(CalcEngineEventType.DOC_EXIT));
    };

    /* (non-Javadoc)
     * @see com.openexchange.office.calcengine.client.ICalcEngineClient#executeOperation(java.lang.String, java.lang.String, java.lang.StringBuffer)
     */
    @Override
    public ECalcEngineError executeOperation(final String sDocHandle, final String sOperationJSON, final StringBuffer sResultJSON) throws Exception {
        ECalcEngineError ret = ECalcEngineError.E_NONE;
        Exception excp = null;

        try {
            final long jobStartTime = System.currentTimeMillis();

            ret = m_iWrapped.executeOperation(sDocHandle, sOperationJSON, sResultJSON);
            handleProcessedJob(ret, jobStartTime);
        }
        catch (Exception e) {
            excp = e;
        }

        handleErrorCondition(excp, ret);

        return ret;
    };

    /* (non-Javadoc)
     * @see com.openexchange.office.calcengine.client.ICalcEngineClient#restoreDocument(java.lang.String, java.lang.String[])
     */
    @Override
    public ECalcEngineError restoreDocument(final String sDocHandle, final String... lPagedOperationJSONs) throws Exception {
        ECalcEngineError ret = ECalcEngineError.E_NONE;
        Exception excp = null;

        try {
            ret = m_iWrapped.restoreDocument(sDocHandle, lPagedOperationJSONs);

            if (ECalcEngineError.E_NONE == ret) {
                Statistics.handleDocumentEvent(new CalcEngineEvent(CalcEngineEventType.DOC_RELOADED));
            }
        }
        catch (Exception e) {
            excp = e;
        }

        handleErrorCondition(excp, ret);

        return ret;
    }

    /* (non-Javadoc)
     * @see com.openexchange.office.calcengine.client.ICalcEngineClient#copy(java.lang.String, com.openexchange.office.calcengine.client.CalcEngineClipBoardEvent)
     */
    @Override
    public ECalcEngineError copy(final String sSourceDocHandle, final CalcEngineClipBoardEvent aEvent) throws Exception {
        ECalcEngineError ret = ECalcEngineError.E_NONE;
        Exception excp = null;

        try {
            final long jobStartTime = System.currentTimeMillis();

            ret = m_iWrapped.copy(sSourceDocHandle, aEvent);
            handleProcessedJob(ret, jobStartTime);
        }
        catch (Exception e) {
            excp = e;
        }

        handleErrorCondition(excp, ret);

        return ret;
    }

    /* (non-Javadoc)
     * @see com.openexchange.office.calcengine.client.ICalcEngineClient#paste(java.lang.String, com.openexchange.office.calcengine.client.CalcEngineClipBoardEvent)
     */
    @Override
    public ECalcEngineError paste(final String sTargetDocHandle, final CalcEngineClipBoardEvent aEvent) throws Exception {
        ECalcEngineError ret = ECalcEngineError.E_NONE;
        Exception excp = null;

        try {
            final long jobStartTime = System.currentTimeMillis();

            ret = m_iWrapped.paste(sTargetDocHandle, aEvent);
            handleProcessedJob(ret, jobStartTime);
        }
        catch (Exception e) {
            excp = e;
        }

        handleErrorCondition(excp, ret);

        return ret;
    }

    /* (non-Javadoc)
     * @see com.openexchange.office.calcengine.client.ICalcEngineClient#getVersion()
     */
    @Override
    public String getVersion() throws Exception {
        return m_iWrapped.getVersion();
    }

    /* (non-Javadoc)
     * @see com.openexchange.office.calcengine.client.ICalcEngineClient#setLogLevel()
     */
    @Override
    public void setLogLevel (final ELogLevel eLevel) throws Exception {
        m_iWrapped.setLogLevel(eLevel);
    }

    // - Implementation -------------------------------------------------------------------------

    /**
     * @param calcEngineError
     * @param jobStartTime
     */
    void handleProcessedJob(ECalcEngineError calcEngineError, long jobStartTime) {
        if (ECalcEngineError.E_NONE == calcEngineError) {
            final long jobExecTime = System.currentTimeMillis() - jobStartTime;
            Statistics.handleDocumentEvent(new CalcEngineEvent(CalcEngineEventType.JOB_PROCESSED, jobExecTime));
        } else {
            Statistics.handleDocumentEvent(new CalcEngineEvent(CalcEngineEventType.JOB_ERROR));
        }
    }

    /**
     * @param e
     * @param calcEngineError
     * @throws Exception
     */
    void handleErrorCondition(Exception e, ECalcEngineError calcEngineError) throws Exception {
        if ((null != e) || (ECalcEngineError.E_DOCUMENT_LOST == calcEngineError) || (ECalcEngineError.E_TIMEOUT == calcEngineError)) {
            Statistics.handleDocumentEvent(new CalcEngineEvent(CalcEngineEventType.DOC_ERROR));

            if (null != e) {
                throw e;
            }
        }
    }

    // -------------------------------------------------------------------------------------

    private ICalcEngineClient m_iWrapped = null;
}
