package org.docx4j;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.docx4j.utils.ResourceUtils;
import com.openexchange.log.LogFactory;

public class Docx4jProperties {

	protected static Log log = LogFactory.getLog(Docx4jProperties.class);

	private static Properties properties;

	private static void init() {

		properties = new Properties();
		try {
			properties.load(
					ResourceUtils.getResource("docx4j.properties"));
		} catch (Exception e) {
			log.error("Error reading docx4j.properties", e);
		}
	}

	public static String getProperty(String key) {

		if (properties==null) {init();}

		return properties.getProperty(key);
	}


	/**
	 * @since 2.7.2
	 */
	public static String getProperty(String key, String defaultValue) {

		if (properties==null) {init();}

		return properties.getProperty(key, defaultValue);
	}

	/**
	 * @since 2.8.1
	 */
	public static boolean getProperty(String key, boolean defaultValue) {

		if (properties==null) {init();}
		String result = properties.getProperty(key, Boolean.toString(defaultValue));
		return Boolean.parseBoolean(result);
	}

	public static Properties getProperties() {

		if (properties==null) {init();}
		return properties;
	}

}
