/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.ooxml.xlsx.tools;

import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.packages.SpreadsheetMLPackage;
import org.docx4j.openpackaging.parts.SpreadsheetML.WorkbookPart;
import org.json.JSONException;
import org.json.JSONObject;
import org.xlsx4j.sml.CTSheetProtection;
import org.xlsx4j.sml.Cell;
import org.xlsx4j.sml.Row;
import org.xlsx4j.sml.STSheetState;
import org.xlsx4j.sml.Sheet;
import org.xlsx4j.sml.SheetData;
import org.xlsx4j.sml.Workbook;
import org.xlsx4j.sml.Worksheet;
import com.openexchange.office.ooxml.tools.Commons;
import com.openexchange.office.ooxml.xlsx.OperationDocument;

public class SheetUtils {

    public static Sheet getSheet(SpreadsheetMLPackage spreadsheetMLPackage, int index) {
        WorkbookPart workbookPart = spreadsheetMLPackage.getWorkbookPart();
        Workbook workbook = workbookPart.getJaxbElement();
        return workbook.getSheets().getSheet().get(index);
    }

    public static void applySheetProperties(Sheet sheet, Worksheet worksheet, JSONObject sheetProperties) {

        if(sheetProperties==null)
            return;

        boolean visible = sheetProperties.optBoolean("visible", true);
        sheet.setState(visible ? STSheetState.VISIBLE : STSheetState.HIDDEN);

        final Object locked = sheetProperties.opt("locked");
        if(locked!=null) {
            CTSheetProtection sheetProtection = worksheet.getSheetProtection();
            if(locked instanceof Boolean) {
                if(sheetProtection==null) {
                    sheetProtection = Context.getsmlObjectFactory().createCTSheetProtection();
                    worksheet.setSheetProtection(sheetProtection);
                }
                sheetProtection.setSheet((Boolean)locked);
            }
            else {
                if(sheetProtection!=null) {
                    sheetProtection.setSheet(null);
                }
            }
        }
    }

    public static JSONObject createSheetProperties(Sheet sheet)
        throws JSONException {

        JSONObject jsonSheetProperties = new JSONObject();
        jsonSheetProperties.put("visible", sheet.getState()==STSheetState.VISIBLE);
        return jsonSheetProperties;
    }

    public static JSONObject createWorkSheetProperties(Sheet sheet, Worksheet worksheet)
        throws JSONException {

        final JSONObject attrs = createSheetProperties(sheet);
        final CTSheetProtection sheetProtection = worksheet.getSheetProtection();
        if(sheetProtection!=null) {
            if(sheetProtection.isSheet()) {
                attrs.put("locked", true);
            }
        }
        return attrs;
    }

    /*
     * applying attrs to each physical available cell within the row
     *
     */
    public static void applyRowProperties(OperationDocument operationDocument, SheetData sheetData, int start, JSONObject attrs)
        throws Exception {

        Row row = sheetData.getRow(start, false);
        if(row==null) {
            return;
        }
        final Commons.CellIterator cellIterator = row.createCellIterator();
        while(cellIterator.hasNext()) {
            CellUtils.applyCellProperties(operationDocument, null, attrs, cellIterator.next(), operationDocument.getStylesheet(true));
        }
    }

    /*
     * applying attrs to each physical available cell within the column
     *
     */
    public static void applyColumnProperties(OperationDocument operationDocument, SheetData sheetData, int start, int end, JSONObject attrs)
        throws Exception {

        final Commons.RowIterator rowIterator = sheetData.createRowIterator();
        while(rowIterator.hasNext()) {
            final Row row = rowIterator.next();
            for(int i=start; i<=end; i++) {
                final Cell cell = row.getCell(i, false);
                if(cell!=null) {
                    CellUtils.applyCellProperties(operationDocument, null, attrs, cell, operationDocument.getStylesheet(true));
                }
            }
        }
    }
}
