
package com.openexchange.office.ooxml.xlsx.operations;

import java.util.HashMap;
import java.util.Map;
import org.xlsx4j.sml.CTCellStyle;
import org.xlsx4j.sml.CTCellStyles;
import org.xlsx4j.sml.CTStylesheet;

public final class BuiltinIds {

    private final static String[] builtins = new String[54];

    static {
        for (int i = 1; i <= 6; i++) {
            final String accentName = "Accent " + i;

            final int normalId = 25 + (i * 4);

            builtins[normalId + 0] = accentName;
            builtins[normalId + 1] = "20% - " + accentName;
            builtins[normalId + 2] = "40% - " + accentName;
            builtins[normalId + 3] = "60% - " + accentName;
        }

        builtins[0] = "Standard";

        builtins[3] = "Comma";
        builtins[4] = "Currency";
        builtins[5] = "Percent";
        builtins[6] = "Decimal";
        builtins[7] = "Currency [0]";
        builtins[8] = "Hyperlink";

        builtins[10] = "Note";
        builtins[11] = "Warning Text";

        builtins[15] = "Title";
        builtins[16] = "Heading 1";
        builtins[17] = "Heading 2";
        builtins[18] = "Heading 3";
        builtins[19] = "Heading 4";
        builtins[20] = "Input";
        builtins[21] = "Output";
        builtins[22] = "Calculation";
        builtins[23] = "Check Cell";
        builtins[24] = "Linked Cell";
        builtins[25] = "Total";
        builtins[26] = "Positive";
        builtins[27] = "Negative";
        builtins[28] = "Neutral";


        builtins[53] = "Explanatory Text";
    }

    public final static Long getBuiltinId(String style) {
        for(int i=0; i<builtins.length; i++) {
            final String res = builtins[i];
            if(res!=null&&res.equals(style)) {
                return new Long(i);
            }
        }
        return null;
    }

    public final static String getName(long builtinId) {
        String res = null;
        if(builtinId>=0&&builtinId<builtins.length) {
            res = builtins[(int) builtinId];
        }
        if (res == null || res.isEmpty()) {
            res = "BuiltIn" + builtinId;
        }
        return res;
    }

    public final static Map<String, CTCellStyle> getUsedStyles(CTStylesheet styleSheet) {
        final Map<String, CTCellStyle> builtInStyles = new HashMap<String, CTCellStyle>();
        if(styleSheet!=null) {
            final CTCellStyles cellStyles = styleSheet.getCellStyles();
            if(cellStyles!=null) {
                for(CTCellStyle cellStyle : cellStyles.getCellStyle()) {

                    // first check if this style is a builtin style...
                    final Long builtInId = cellStyle.getBuiltinId();
                    if(builtInId!=null) {
                        final String builtInString = getName(builtInId);
                        if(builtInString!=null) {
                            builtInStyles.put(builtInString, cellStyle);
                            continue;
                        }
                    }
                    // this style is no builtin style, we are using the styleName as Id
                    final String name = cellStyle.getName();
                    if(name!=null&&!name.isEmpty()) {
                        builtInStyles.put(name, cellStyle);
                    }
                }
            }
        }
        return builtInStyles;
    }
}
