/*
 * Copyright 2012 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.odftoolkit.odfdom.component;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.junit.runners.Parameterized.Parameters;
import org.odftoolkit.odfdom.utils.ResourceUtilities;

/**
 * Loads all document of the input test directory and gathers its operations.
 * Gathered operations will be applied to an empty text document. The changed
 * text document will be saved and reloaded. New gathered operations will be
 * compared with the original ones, expected to be identical.
 *
 * @author svanteschubert
 */
@RunWith(Parameterized.class)
public class RoundtripAllDocumentsTest extends RoundtripTestTemplate {

	private static final Logger LOG = Logger.getLogger(RoundtripAllDocumentsTest.class.getName());
	private static final String OUTPUT_DIRECTORY = "regression-tests" + File.separatorChar;
	private File mTestFile = null;	

	public RoundtripAllDocumentsTest(File testFile) {
		super();
		mTestFile = testFile;
	}

	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
		// Creating the output directory for the tests
		File outputDir = ResourceUtilities.newTestOutputFile(OUTPUT_DIRECTORY);
		outputDir.mkdir();
	}

	@Parameters(name = "Test# {index}: {0}")
	public static Collection<Object[]> data() {
		Collection<Object[]> testSuiteData = new ArrayList<Object[]>();
		addFilesFromFolder(ResourceUtilities.getTestReferenceFolder(), testSuiteData);
		return testSuiteData;
	}

	private static void addFilesFromFolder(final File folder, Collection<Object[]> testSuiteData) {
		for (final File fileEntry : folder.listFiles()) {
			if (fileEntry.isDirectory()) {
// ToDo: There is a performance directory that currently ruins the test!				
//				LOG.log(Level.INFO, "*** testDirectory:{0}", fileEntry.getAbsolutePath());
//				addFilesFromFolder(fileEntry, testSuiteData);
			} else {
				if ((fileEntry.getAbsolutePath().endsWith(".odt") || fileEntry.getAbsolutePath().endsWith(".ott")) &&  
					fileEntry.getAbsolutePath().endsWith(".ods") || fileEntry.getAbsolutePath().endsWith(".ots") 
						&& !fileEntry.getAbsolutePath().contains("testInvalidPkg") && !fileEntry.getAbsolutePath().contains("Text1.odt")
						// ToDo: There is a table repeated issue to be fixed soo										
						&& !fileEntry.getAbsolutePath().contains("test1") && !fileEntry.getAbsolutePath().contains("test1") && !fileEntry.getAbsolutePath().endsWith("PasswordProtected.odt")  
						&& !fileEntry.getAbsolutePath().endsWith("tableOps.odt") && !fileEntry.getAbsolutePath().endsWith("OOStyledTable.odt")) {// || fileEntry.getAbsolutePath().endsWith(".odp")) 
					LOG.log(Level.INFO, "*** testFile: {0}", fileEntry.getAbsolutePath());
					Object[] testData = new Object[]{fileEntry};
					testSuiteData.add(testData);
				}
			}
		}
	}

	@Test
	public void testFile() {
		
		String fileName = mTestFile.getName();
		String fileTruncName = fileName.substring(0, fileName.indexOf("."));
		String fileSuffix = fileName.substring(fileName.indexOf("."), fileName.length());
		super.roundtripOnlyToEmptyDocRegressionTest(fileTruncName, fileSuffix);
	}	
}