package com.openexchange.office.tools;

import org.json.JSONException;
import org.json.JSONObject;

public enum ErrorCode {

    NO_ERROR(0, "NO_ERROR", "No error"),
    FILTER_NOBACKUP_ERROR(100, "FILTER_NOBACKUP_ERROR", "The document is inconsistent and no backup file could be created!"),
    FILTER_OPERATION_ERROR(101, "FILTER_OPERATION_ERROR", "The document is inconsistent and is saved as doc_ox file!"),
    FILTER_QUOTA_REACHED_ERROR(102, "FILTER_QUOTA_REACHED_ERROR", "The document could not be written due to quota limitations!"),
    CREATEDOCUMENT_CONVERSION_FAILED_ERROR(200, "CREATEDOCUMENT_CONVERSION_FAILED_ERROR", "The document couldn't be created because of an conversion error!"),
    CREATEDOCUMENT_CANNOT_READ_TEMPLATEFILE_ERROR(201, "CREATEDOCUMENT_CANNOT_READ_TEMPLATEFILE_ERROR", "The document couldn't be created because the template file couldn't be read!"),
    CREATEDOCUMENT_CANNOT_READ_DEFAULTTEMPLATEFILE_ERROR(202, "CREATEDOCUMENT_CANNOT_READ_DEFAULTTEMPLATEFILE_ERROR", "The document coulnd't be created because the default template file couldn't be read!"),
    CREATEDOCUMENT_PERMISSION_CREATEFILE_MISSING_ERROR(203, "CREATEDOCUMENT_PERMISSION_CREATEFILE_MISSING_ERROR", "The document couldn't be created due to missing permissions!"),
    CREATEDOCUMENT_QUOTA_REACHED_ERROR(204, "CREATEDOCUMENT_QUOTA_REACHED_ERROR", "The document couldn't be created because the quota has been reached!"),
    RENAMEDOCUMENT_FAILED_ERROR(300, "RENAMEDOCUMENT_FAILED_ERROR", "Renaming the document failed!"),
    RENAMEDOCUMENT_VALIDATION_FAILED_CHARACTERS_ERROR(301, "RENAMEDOCUMENT_VALIDATION_FAILED_CHARACTERS_ERROR", "The document couldn't be renamed as the validation of the new file name failed. File name contains invalid characters!"),
    LOADDOCUMENT_FAILED_ERROR(400, "LOADDOCUMENT_FAILED_ERROR", "Loading the document failed!"),
    LOADDOCUMENT_CANNOT_RETRIEVE_OPERATIONS_ERROR(401, "LOADDOCUMENT_CANNOT_RETRIEVE_OPERATIONS_ERROR", "Loading the document failed because operations couldn't be generated!"),
    LOADDOCUMENT_CANNOT_READ_PASSWORD_PROTECTED_ERROR(402, "LOADDOCUMENT_CANNOT_READ_PASSWORD_PROTECTED_ERROR", "Loading the document failed because it's password protected!");

    private final int m_code;
    private final String m_codeAsStringConstant;
    private final String m_description;

    private ErrorCode(int code, String codeAsString, String description) {
      this.m_code = code;
      this.m_codeAsStringConstant = codeAsString;
      this.m_description = description;
    }

    public String getDescription() {
       return m_description;
    }

    public int getCode() {
       return m_code;
    }

    public String getCodeAsStringConstant() {
        return m_codeAsStringConstant;
    }

    @Override
    public String toString() {
      return m_code + ": " + m_description;
    }

    public JSONObject getAsJSON() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("errorCode", this.getCode());
            jsonObject.put("error", this.getCodeAsStringConstant());
            jsonObject.put("errorDescription", this.getDescription());
        } catch (final JSONException e) {
            //
        }
        return jsonObject;
    }

    static public int getErrorCodeFromJSON(JSONObject jsonObject, int defaultValue) {
        int result = defaultValue;
        if (null != jsonObject) {
            result = jsonObject.optInt("errorCode", defaultValue);
        }
        return result;
    }

    static public String getErrorConstantFromJSON(JSONObject jsonObject, String defaultValue) {
        String result = defaultValue;
        if (null != jsonObject) {
            result = jsonObject.optString("error", defaultValue);
        }
        return result;
    }

    static public String getErrorDescriptionFromJSON(JSONObject jsonObject, String defaultValue) {
        String result = defaultValue;
        if (null != jsonObject) {
            result = jsonObject.optString("errorDescription", defaultValue);
        }
        return result;
    }
 }
