/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.resource;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import com.openexchange.office.IResourceEntry;
import com.openexchange.office.IResourceProvider;

/**
 * {@link ResourceProvider}
 *
 * @author <a href="mailto:kai.ahrens@open-xchange.com">Kai Ahrens</a>
 */
public class ResourceProvider implements IResourceProvider {

    private ArrayList<IResourceEntry> entries = new ArrayList<IResourceEntry>();

    /**
     * Initializes a new {@link ResourceProvider}.
     */
    public ResourceProvider() {
    }

    /**
     * @return true in case the entry list has been correctly initialized
     */
    protected boolean initEntries() {
        if (entries.isEmpty()) {
            InputStream inputStm = null;

            try {
                final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

                if (null != factory) {
                    final DocumentBuilder builder = factory.newDocumentBuilder();
                    inputStm = this.getClass().getClassLoader().getResourceAsStream("/com/openexchange/office/resource/content.xml");
                    final Document doc = ((null != builder) && (null != inputStm)) ? builder.parse(inputStm) : null;

                    if (null != doc) {
                        doc.getDocumentElement().normalize();

                        final NodeList modules = doc.getElementsByTagName("module");

                        for (int i = 0; i < modules.getLength(); ++i) {
                            final Node module = modules.item(i);

                            if (Node.ELEMENT_NODE == module.getNodeType()) {
                                final String moduleName = module.getAttributes().getNamedItem("name").getNodeValue();
                                final NodeList groups = ((Element) module).getElementsByTagName("group");

                                for (int j = 0; j < groups.getLength(); ++j) {
                                    final Node group = groups.item(j);

                                    if (Node.ELEMENT_NODE == group.getNodeType()) {
                                        final String groupName = group.getAttributes().getNamedItem("name").getNodeValue();
                                        final NodeList resources = ((Element) group).getElementsByTagName("resource");

                                        for (int k = 0; k < resources.getLength(); ++k) {
                                            final Node resource = resources.item(k);

                                            if (Node.ELEMENT_NODE == resource.getNodeType()) {
                                                final NamedNodeMap attribs = resource.getAttributes();
                                                final String location = attribs.getNamedItem("location").getNodeValue();
                                                final String name = attribs.getNamedItem("name").getNodeValue();
                                                final String description = resource.getTextContent();

                                                entries.add(new ResourceEntry(moduleName, groupName, location, name, description));
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            } catch (Exception e) {
                //
            } finally {
                IOUtils.closeQuietly(inputStm);
            }
        }

        return !entries.isEmpty();
    }

    @Override
    public List<IResourceEntry> getEntries() {

        initEntries();

        return entries;
    }

    @Override
    public List<IResourceEntry> getEntries(String module) {
        return getEntries(module, null);
    }

    @Override
    public List<IResourceEntry> getEntries(String module, String group) {
        final ArrayList<IResourceEntry> retList = new ArrayList<IResourceEntry>();

        initEntries();

        for (final Iterator<IResourceEntry> iter = entries.iterator(); iter.hasNext();) {
            final IResourceEntry entry = iter.next();

            if (((null == module) || entry.getModule().equals(module)) && ((null == group) || entry.getGroup().equals(group))) {
                retList.add(entry);
            }
        }

        return retList;
    }

    @Override
    public IResourceEntry getEntry(String module, String group, String title) {
        IResourceEntry retEntry = null;

        if ((null != module) && (null != group) && (null != title)) {
            initEntries();

            for (final Iterator<IResourceEntry> iter = entries.iterator(); (null == retEntry) && iter.hasNext();) {
                final IResourceEntry entry = iter.next();

                if (entry.getModule().equals(module) && entry.getGroup().equals(group) && entry.getTitle().equals(title)) {
                    retEntry = entry;
                }
            }
        }

        return retEntry;
    }

    @Override
    public InputStream getResource(IResourceEntry entry) {
        BufferedInputStream retStm = null;

        if (null != entry) {
            final IResourceEntry theEntry = getEntry(entry.getModule(), entry.getGroup(), entry.getTitle());

            if ((null != theEntry) && (null != theEntry.getLocation())) {
                final InputStream inputStm = this.getClass().getClassLoader().getResourceAsStream(theEntry.getLocation());

                if (null != inputStm) {
                    retStm = new BufferedInputStream(inputStm);
                }
            }
        }

        return retStm;
    }
}
