/*
 *  Copyright 2010, Plutext Pty Ltd.
 *
 *  This file is part of docx4j.

    docx4j is licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.

    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

 */


package org.xlsx4j.sml;

import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.json.JSONArray;
import org.jvnet.jaxb2_commons.ppp.Child;


/**
 * <p>Java class for CT_Cell complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType name="CT_Cell">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="f" type="{http://schemas.openxmlformats.org/spreadsheetml/2006/main}CT_CellFormula" minOccurs="0"/>
 *         &lt;element name="v" type="{http://schemas.openxmlformats.org/spreadsheetml/2006/main}ST_Xstring" minOccurs="0"/>
 *         &lt;element name="is" type="{http://schemas.openxmlformats.org/spreadsheetml/2006/main}CT_Rst" minOccurs="0"/>
 *         &lt;element name="extLst" type="{http://schemas.openxmlformats.org/spreadsheetml/2006/main}CT_ExtensionList" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="r" type="{http://schemas.openxmlformats.org/spreadsheetml/2006/main}ST_CellRef" />
 *       &lt;attribute name="s" type="{http://www.w3.org/2001/XMLSchema}unsignedInt" default="0" />
 *       &lt;attribute name="t" type="{http://schemas.openxmlformats.org/spreadsheetml/2006/main}ST_CellType" default="n" />
 *       &lt;attribute name="cm" type="{http://www.w3.org/2001/XMLSchema}unsignedInt" default="0" />
 *       &lt;attribute name="vm" type="{http://www.w3.org/2001/XMLSchema}unsignedInt" default="0" />
 *       &lt;attribute name="ph" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 *
 *
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "CT_Cell", propOrder = {
    "f",
    "v",
    "is",
    "extLst"
})
public class Cell implements Child {

    protected CTCellFormula f;
    protected String v;
    protected CTRst is;
    protected CTExtensionList extLst;
    @XmlAttribute
    protected String r;
    @XmlAttribute
    @XmlSchemaType(name = "unsignedInt")
    protected Long s;
    @XmlAttribute
    protected STCellType t;
    @XmlAttribute
    @XmlSchemaType(name = "unsignedInt")
    protected Long cm;
    @XmlAttribute
    @XmlSchemaType(name = "unsignedInt")
    protected Long vm;
    @XmlAttribute
    protected Boolean ph;
    @XmlTransient
    private Object parent;

    /**
     * Gets the value of the f property.
     *
     * @return
     *     possible object is
     *     {@link CTCellFormula }
     *
     */
    public CTCellFormula getF() {
        return f;
    }

    /**
     * Sets the value of the f property.
     *
     * @param value
     *     allowed object is
     *     {@link CTCellFormula }
     *
     */
    public void setF(CTCellFormula value) {
        this.f = value;
    }

    /**
     * Gets the value of the v property.
     *
     * @return
     *     possible object is
     *     {@link String }
     *
     */
    public String getV() {
        return v;
    }

    /**
     * Sets the value of the v property.
     *
     * @param value
     *     allowed object is
     *     {@link String }
     *
     */
    public void setV(String value) {
        this.v = value;
    }

    /**
     * Gets the value of the is property.
     *
     * @return
     *     possible object is
     *     {@link CTRst }
     *
     */
    public CTRst getIs() {
        return is;
    }

    /**
     * Sets the value of the is property.
     *
     * @param value
     *     allowed object is
     *     {@link CTRst }
     *
     */
    public void setIs(CTRst value) {
        this.is = value;
    }

    /**
     * Gets the value of the extLst property.
     *
     * @return
     *     possible object is
     *     {@link CTExtensionList }
     *
     */
    public CTExtensionList getExtLst() {
        return extLst;
    }

    /**
     * Sets the value of the extLst property.
     *
     * @param value
     *     allowed object is
     *     {@link CTExtensionList }
     *
     */
    public void setExtLst(CTExtensionList value) {
        this.extLst = value;
    }

    /**
     * Gets the value of the r property.
     *
     * @return
     *     possible object is
     *     {@link String }
     *
     */
    public String getR() {
        return r;
    }

    /**
     * Sets the value of the r property.
     *
     * @param value
     *     allowed object is
     *     {@link String }
     *
     */
    public void setR(String value) {
        this.r = value;
    }

    /**
     * Gets the value of the s property.
     *
     * @return
     *     possible object is
     *     {@link Long }
     *
     */
    public long getS() {
        if (s == null) {
            return  0L;
        } else {
            return s;
        }
    }

    /**
     * Sets the value of the s property.
     *
     * @param value
     *     allowed object is
     *     {@link Long }
     *
     */
    public void setS(Long value) {
        this.s = value;
    }

    /**
     * Gets the value of the t property.
     *
     * @return
     *     possible object is
     *     {@link STCellType }
     *
     */
    public STCellType getT() {
        if (t == null) {
            return STCellType.N;
        } else {
            return t;
        }
    }

    /**
     * Sets the value of the t property.
     *
     * @param value
     *     allowed object is
     *     {@link STCellType }
     *
     */
    public void setT(STCellType value) {
        this.t = value;
    }

    /**
     * Gets the value of the cm property.
     *
     * @return
     *     possible object is
     *     {@link Long }
     *
     */
    public long getCm() {
        if (cm == null) {
            return  0L;
        } else {
            return cm;
        }
    }

    /**
     * Sets the value of the cm property.
     *
     * @param value
     *     allowed object is
     *     {@link Long }
     *
     */
    public void setCm(Long value) {
        this.cm = value;
    }

    /**
     * Gets the value of the vm property.
     *
     * @return
     *     possible object is
     *     {@link Long }
     *
     */
    public long getVm() {
        if (vm == null) {
            return  0L;
        } else {
            return vm;
        }
    }

    /**
     * Sets the value of the vm property.
     *
     * @param value
     *     allowed object is
     *     {@link Long }
     *
     */
    public void setVm(Long value) {
        this.vm = value;
    }

    /**
     * Gets the value of the ph property.
     *
     * @return
     *     possible object is
     *     {@link Boolean }
     *
     */
    public boolean isPh() {
        if (ph == null) {
            return false;
        } else {
            return ph;
        }
    }

    /**
     * Sets the value of the ph property.
     *
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *
     */
    public void setPh(Boolean value) {
        this.ph = value;
    }

    @Override
    public Object getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Object parent) {
        this.parent = parent;
    }

    /**
     * This method is invoked by the JAXB implementation on each instance when unmarshalling completes.
     *
     * @param parent
     *     The parent object in the object tree.
     * @param unmarshaller
     *     The unmarshaller that generated the instance.
     */
    public void afterUnmarshal(Unmarshaller unmarshaller, Object _parent) {
        setParent(_parent);
        if(f!=null&&f.getSi()!=null&&_parent instanceof Row) {
            ((Row)_parent).setSi(f.getSi());
        }
    }

    @XmlAccessorType(XmlAccessType.NONE)
    public static class CellRefRange {
        private final CellRef start;
        private final CellRef end;

        public CellRefRange(CellRef start, CellRef end) {
            this.start = start;
            this.end = end;
        }
        public CellRef getStart() {
            return start;
        }
        public CellRef getEnd() {
            return end;
        }
        public boolean isInside(int column, int row) {
            return column>=Math.min(start.getColumn(), end.getColumn())&&column<=Math.max(start.getColumn(), end.getColumn())
                && row>=Math.min(start.getRow(), end.getRow())&&row<=Math.min(start.getRow(), end.getRow());
        }
        public boolean intersects(CellRefRange cellRefRange) {

            final int left  = Math.max( start.getColumn(), cellRefRange.getStart().getColumn() );
            final int right = Math.min( end.getColumn(), cellRefRange.getEnd().getColumn() );
            final int top   = Math.max( start.getRow(), cellRefRange.getStart().getRow() );
            final int bottom= Math.min( end.getRow(), cellRefRange.getEnd().getRow() );
            return (right<left||bottom<top) ? false : true;
        }
        public static CellRefRange deleteRowRange(CellRefRange cellRef, int startRow, int endRow) {
            int row1 = cellRef.getStart().getRow();
            int row2 = cellRef.getEnd().getRow();
            final int count = (endRow-startRow)+1;
            if(startRow<=row2) {
                if(startRow<=row1&&endRow>=row2) {
                    return null;                                // merged cell is completely removed
                }
                else if(endRow<row1) {
                    row1 -= count;                              // merged cell is completely moved up by count
                    row2 -= count;
                }
                else if(startRow>row1&&endRow<=row2) {
                    row2 -= count;                              // merged cell is shortened by delete count
                }
                else if(startRow>row1) {
                    row2 = startRow-1;                          // new end is to be set
                }
                else {
                    row1 = startRow;                            // new start is to be set
                    row2 -= count;
                }
            }
            return new CellRefRange(new CellRef(cellRef.getStart().getColumn(), row1), new CellRef(cellRef.getEnd().getColumn(), row2));
        }
        public static CellRefRange deleteColumnRange(CellRefRange cellRef, int startColumn, int endColumn) {
            int column1 = cellRef.getStart().getColumn();
            int column2 = cellRef.getEnd().getColumn();
            final int count = (endColumn-startColumn)+1;
            if(startColumn<=column2) {
                if(startColumn<=column1&&endColumn>=column2) {
                    return null;                                // merged cell is completely removed
                }
                else if(endColumn<column1) {
                    column1 -= count;                           // merged cell is completely moved up by count
                    column2 -= count;
                }
                else if(startColumn>column1&&endColumn<=column2) {
                    column2 -= count;                           // merged cell is shortened by delete count
                }
                else if(startColumn>column1) {
                    column2 = startColumn-1;                    // new end is to be set
                }
                else {
                    column1 = startColumn;                      // new start is to be set
                    column2 -= count;
                }
            }
            return new CellRefRange(new CellRef(column1, cellRef.getStart().getRow()), new CellRef(column2, cellRef.getEnd().getRow()));
        }
    }
    @XmlAccessorType(XmlAccessType.NONE)
    public static class CellRef {

        private int column;
        private int row;

        public CellRef(int column, int row) {
            this.column = column;
            this.row = row;
        }
        public int getColumn() {
            return column;
        }
        public int getRow() {
            return row;
        }
        public void setColumn(int column) {
            this.column = column;
        }
        public void setRow(int row) {
            this.row = row;
        }
        public boolean equals(CellRef cellRef) {
            return this.column==cellRef.column&&this.row==cellRef.row;
        }
        public final JSONArray getJSONArray() {
            final JSONArray jsonArray = new JSONArray();
            jsonArray.put(column);
            jsonArray.put(row);
            return jsonArray;
        }
    }

    public static CellRefRange createCellRefRange(String cellRefRange) {

        if(cellRefRange==null)
            return null;
        final CellRef start = createCellRef(cellRefRange);
        if(start==null)
            return null;
        int indexOfSeparator = cellRefRange.indexOf(':');
        if(indexOfSeparator==-1) {
            return new CellRefRange(start, new CellRef(start.getColumn(), start.getRow()));
        }
        if(indexOfSeparator<2||(indexOfSeparator+1)>=cellRefRange.length())
            return null;
        final CellRef end = createCellRef(cellRefRange.substring(indexOfSeparator+1));
        if(end==null)
            return null;
        return new CellRefRange(start, end);
    }

    public static CellRefRange createCellRefRangeWithSheet(String cellRefRange) {
        final int indexOf = cellRefRange.lastIndexOf("!");
        final String range = cellRefRange.substring(indexOf + 1);
        return createCellRefRange(range);
    }

    /**
     * translates string CellRef like "B23" into a computable form : 1, 22
     *
     * returns null on error or missing cellRef
     *
     */
    public static CellRef createCellRef(String cellRef) {

        if(cellRef==null||cellRef.isEmpty())
            return null;

        CellRef cellPosition = null;

        int characters = 0;
        int characterStartIndex = cellRef.charAt(0) == '$' ? 1 : 0;

        while((characters+characterStartIndex)<cellRef.length()) {
            char character = cellRef.charAt(characterStartIndex+characters);
            if((character<'A')||(character>'Z')) {
                break;
            }
            characters++;
        }
        if(characters>0&&(characters+characterStartIndex)<cellRef.length()&&characters<6) {

            final int[] exMap = { 1, 26, 676, 17576, 456976 };

            int ex = characters - 1;
            int x = 0;

            for(int i = 0; i < characters; i++) {
                x +=((cellRef.charAt(i+characterStartIndex)-'A')+1)*exMap[ex-i];
            }

            int numbers = 0;
            int numberStartIndex = characterStartIndex + characters;

            if(cellRef.charAt(numberStartIndex) == '$') {
                numberStartIndex++;
            }
            while(numbers+numberStartIndex<cellRef.length()) {
                char character = cellRef.charAt(numberStartIndex+numbers);
                if((character<'0')||(character>'9')) {
                    break;
                }
                numbers++;
            }
            if(numbers>0) {
                int y = 0;
                for(int i = 0; i < numbers; i++) {
                    y*=10;
                    y +=cellRef.charAt(i+numberStartIndex)-'0';
                }
                if(y>0) {
                    cellPosition = new CellRef(x-1, y-1);
                }
            }
        }
        return cellPosition;
    }

    private static void addCellRef(StringBuilder buffer, int column, long row) {
        addCellRefColumn(buffer, column);
        addCellRefRow(buffer, row);
    }

    private static void addCellRefColumn(StringBuilder buffer, int column) {

        int pos = buffer.length();
        while(column>=0) {
            buffer.insert(pos, (char)('A' + (column % 26)));
            column /= 26;
            column--;
        }
    }

    private static void addCellRefRow(StringBuilder buffer, long row) {
        buffer.append(Long.toString(row+1));
    }

    public static String getCellRef(CellRef cellRef) {
        return getCellRef(cellRef.getColumn(), cellRef.getRow());
    }
    public static String getCellRef(int column, long row) {
        StringBuilder buffer = new StringBuilder(8);
        addCellRef(buffer, column, row);
        return buffer.toString();
    }

    public static String getCellRefRange(CellRefRange cellRefRange) {
        return getCellRefRange(cellRefRange.getStart().getColumn(), cellRefRange.getStart().getRow(), cellRefRange.getEnd().getColumn(), cellRefRange.getEnd().getRow());
    }

    public static String getAbsoluteCellRefRange(CellRefRange cellRefRange) {
        return getAbsoluteCellRefRange(cellRefRange.getStart().getColumn(), cellRefRange.getStart().getRow(), cellRefRange.getEnd().getColumn(), cellRefRange.getEnd().getRow());
    }

    public static String getCellRefRange(int startColumn, long startRow, int endColumn, int endRow) {
        StringBuilder buffer = new StringBuilder(17);
        addCellRef(buffer, startColumn, startRow);
        buffer.append(':');
        addCellRef(buffer, endColumn, endRow);
        return buffer.toString();
    }
    public static String getAbsoluteCellRefRange(int startColumn, long startRow, int endColumn, int endRow) {
        StringBuilder buffer = new StringBuilder(21);
        buffer.append('$');
        addCellRefColumn(buffer, startColumn);
        buffer.append('$');
        addCellRefRow(buffer, startRow);
        buffer.append(':');
        buffer.append('$');
        addCellRefColumn(buffer, endColumn);
        buffer.append('$');
        addCellRefRow(buffer, endRow);
        return buffer.toString();
    }
}
