/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.ooxml.xlsx.tools;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.json.JSONException;
import org.json.JSONObject;
import org.xlsx4j.sml.CTCellStyleXfs;
import org.xlsx4j.sml.CTStylesheet;
import org.xlsx4j.sml.CTXf;
import org.xlsx4j.sml.Col;
import com.openexchange.office.ooxml.xlsx.OperationDocument;
import com.openexchange.office.ooxml.xlsx.operations.ApplyOperationHelper;

public class ColumnUtils {

    public static void applyColumnProperties(OperationDocument operationDocument, JSONObject columnProperties, Col col, CTStylesheet stylesheet)
        throws JSONException {

        if(columnProperties.has("styleId")) {
            Object value = columnProperties.get("styleId");
            if(value instanceof String) {
                final ApplyOperationHelper applyOperationHelper = operationDocument.getApplyOperationHelper();
                if(applyOperationHelper!=null) {
                    col.setStyle(applyOperationHelper.getStyleIndex((String)value));
                }
            }
        }
        // Column properties
        final JSONObject jsonColumnProperties = columnProperties.optJSONObject("column");
        if(jsonColumnProperties!=null) {
            Iterator<String> keys = jsonColumnProperties.keys();
            while(keys.hasNext()) {
                String attr = keys.next();
                Object value = jsonColumnProperties.get(attr);
                if(attr.equals("width")) {
                    Double columnWidth = null;
                    if(value instanceof Integer) {
                        final int defaultFontPixelWidth = operationDocument.getDefaultFontSize() == 12.0 ? 8 : 7;
                        final double maxDigitWidthIn100thmm = (defaultFontPixelWidth*2540)/96.0;
                        columnWidth = (Integer)value / maxDigitWidthIn100thmm;
                    }
                    col.setWidth(columnWidth);
                }
                else if(attr.equals("visible")) {
                    Boolean collapsed = null;
                    if(value instanceof Boolean) {
                        collapsed = !(Boolean)value;
                    }
                    col.setCollapsed(collapsed);
                }
                else if(attr.equals("customWidth")) {
                    Boolean customWidth = null;
                    if(value instanceof Boolean) {
                        customWidth = (Boolean)value;
                    }
                    col.setCustomWidth(customWidth);
                }
                else if(attr.equals("isBestFit")) {
                    Boolean isBestFit = null;
                    if(value instanceof Boolean) {
                        isBestFit = (Boolean)value;
                    }
                    col.setBestFit(isBestFit);
                }
            }
        }
        // cell & character properties
        final JSONObject jsonCellProperties = columnProperties.optJSONObject("cell");
        final JSONObject jsonCharacterProperties = columnProperties.optJSONObject("character");

        if(jsonCellProperties!=null||jsonCharacterProperties!=null) {

            final CTXf xfSource = stylesheet.getCellXfByIndex(col.getStyle());
            final CTXf detachedXf = xfSource==null?Context.getsmlObjectFactory().createCTXf():XmlUtils.deepCopy(xfSource, Context.getJcSML());

            final Long xfId = detachedXf.getXfId();
            CTXf cellStyleXf = null;
            if(xfId!=null) {
                final CTCellStyleXfs cellStyleXfs = stylesheet.getCellStyleXfs();
                if(cellStyleXfs!=null) {
                    final List<CTXf> cellStyleXfsList = cellStyleXfs.getXf();
                    if(xfId>=0&&xfId<cellStyleXfsList.size()) {
                        cellStyleXf = cellStyleXfsList.get(xfId.intValue());
                    }
                }
            }
            if(jsonCellProperties!=null) {
                CellUtils.applyCellProperties(operationDocument, jsonCellProperties, detachedXf, stylesheet, cellStyleXf);
            }
            if(jsonCharacterProperties!=null) {
                CellUtils.applyCharacterProperties(operationDocument, null, null, jsonCharacterProperties, detachedXf, stylesheet, cellStyleXf);
            }

            long index = stylesheet.getOrApplyCellXf(detachedXf);
            if(index>0) {
                col.setStyle(index);
            }

            // Excel 2013 is having problems with empty columns
            if(col.getWidth()==null) {
                col.setWidth(new Double(11.42578125));
            }
        }
        return;
    }

    public static JSONObject createColumnProperties(OperationDocument operationDocument, Col col, Map<Long, String> autoStyleToStyleMap)
        throws JSONException {

        final JSONObject attrs = new JSONObject();

        // row
        final JSONObject columnProperties = new JSONObject();

        Double columnWidth = col.getWidth();
        if(columnWidth!=null) {
            final int defaultFontPixelWidth = operationDocument.getDefaultFontSize() == 12.0 ? 8 : 7;
            final double maxDigitWidthIn100thmm = (defaultFontPixelWidth*2540)/96.0;         // (for a 11pt calibri at 96dpi (7 pixel))
            final int mm100th = (int)(columnWidth * maxDigitWidthIn100thmm + 0.5);
            columnProperties.put("width", mm100th);
        }
        if(col.isCollapsed()||col.isHidden()) {
            columnProperties.put("visible", false);
        }
        if(col.isCustomWidth()) {
            columnProperties.put("customWidth", true);
        }
        if(!col.isBestFit()) {
            columnProperties.put("autoFit", false);
        }
        attrs.put("column", columnProperties);

        long s = col.getStyle();
        if(s>=0) {
            String style = autoStyleToStyleMap.get(s);
// TODO:    if(style==null)
                style = "a" + Long.toString(s);
            attrs.put("styleId", style);
        }
/*
            final CTStylesheet stylesheet = operationDocument.getStylesheet(true);
            CTXf xf = stylesheet.getCellXfByIndex(s);
            if(xf!=null) {
                // creating style attribute (0 is default and though not created)
                Long xfId = xf.getXfId();
                if(xfId!=null&&xfId!=0) {
                    attrs.put("styleId", Long.toString(xfId));
                }
                Commons.mergeJsonObjectIfUsed("character", attrs, CellUtils.createCharacterProperties(xf, stylesheet, false));
                Commons.mergeJsonObjectIfUsed("cell", attrs, CellUtils.createCellProperties(xf, stylesheet, false));
            }
        }
*/
        if(attrs.length()==0) {
            return null;
        }
        return attrs;
    }
}
