/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.tools.jobpool;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang.Validate;


//=============================================================================
public class MapImpl implements IMap
                              , Serializable
{
	// NO serialVersionUID FOR BASE CLASS - PLEASE !
	
	//-------------------------------------------------------------------------
	public MapImpl ()
	    throws Exception
	{}

	//-------------------------------------------------------------------------
	public synchronized void clear ()
	    throws Exception
	{
		mem_Map ().clear();
	}
	
	//-------------------------------------------------------------------------
	@Override
	public synchronized < T extends Serializable > void set(final String sElement,
									 						final T      aValue  )
		throws Exception
	{
		Validate.notEmpty(sElement, "Invalid argument for 'element'.");

		Map< String, Object > lMap = mem_Map ();
		lMap.put(sElement, aValue);
	}

	//-------------------------------------------------------------------------
	@SuppressWarnings("unchecked")
	@Override
	public synchronized <T extends Serializable > T get(final String sElement)
		throws Exception
	{
		Validate.notEmpty(sElement, "Invalid argument for 'element'.");
		
		Map< String, Object > lMap   = mem_Map ();
		Object                aValue = lMap.get(sElement);
		return (T) aValue;
	}

	//-------------------------------------------------------------------------
	@SuppressWarnings("unchecked")
	@Override
	public synchronized < T extends Serializable > T get(final String sElement,
					 			  						 final T      aDefault)
		throws Exception
	{
		Validate.notEmpty(sElement, "Invalid argument for 'element'.");

		Map< String, Object > lMap   = mem_Map ();
		Object                aValue = lMap.get(sElement);

		if (aValue == null)
			aValue = aDefault;
		
		return (T) aValue;
	}

	//-------------------------------------------------------------------------
	@Override
	public synchronized String toString ()
	{
		StringBuffer sString = new StringBuffer (256);
		
		sString.append (super.toString ());
		if (m_lMap == null)
			return sString.toString ();
		
		sString.append (m_lMap);
		return sString.toString ();
	}
	
	//-------------------------------------------------------------------------
	protected Map< String, Object > mem_Map ()
	    throws Exception
	{
		if (m_lMap == null)
			m_lMap = new HashMap< String, Object > ();
		return m_lMap;
	}
	
	//-------------------------------------------------------------------------
	private Map< String, Object > m_lMap = null;
}
