/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.tools;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;

import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.InitialDirContext;

import org.apache.commons.lang.StringUtils;

//=============================================================================
public class IPUtils
{
    //-------------------------------------------------------------------------
    public static final String DNS_ATTR_IPV4_RECORD_A = "A";
    public static final String DNS_ATTR_IPV6_RECORD_A = "AAAA";

	//-------------------------------------------------------------------------
	/** helper classes with static functions only do not need a ctor .-)
	 */
	private IPUtils ()
	{}

	//-------------------------------------------------------------------------
	/** check if the given IP match to current machine.
	 * 
	 *  You can check for IPv4 and IPv6 addresses here ...
	 *  but not for DNS names !
	 * 
	 *	@param	sIP	[IN]
	 *			the IP to be checked here.
	 *
	 * 	@return true if IP match; false otherwise.
	 */
    public static boolean isMyIP (final String sIP)
        throws Exception
    {
    	if (StringUtils.isEmpty(sIP))
    		return false;
    	
    	final Enumeration< NetworkInterface > lInterfaces = NetworkInterface.getNetworkInterfaces();
    	while (lInterfaces.hasMoreElements())
    	{
    	    final NetworkInterface aInterface = lInterfaces.nextElement();
    	    //System.out.println("INTERFACE : "+aInterface);

    	    if ( ! aInterface.isUp()) // TODO think about me ...
    	    	continue;
    	    	
    	    final Enumeration< InetAddress > lAddresses = aInterface.getInetAddresses();
    	    while (lAddresses.hasMoreElements())
    	    {
    	        final InetAddress aAddress = lAddresses.nextElement();
    	        final String      sAddress = aAddress.getHostAddress();
    	        //System.out.println("ADDRESS : "+sAddress);
    	        
    	        if (StringUtils.equals(sAddress, sIP))
    	        	return true;
    	    }
    	}

    	return false;
    }
    
	//-------------------------------------------------------------------------
    /**
     * TODO might be better to use DNSJava JAR ? (http://www.dnsjava.org)
     */
    public static String detectIP (final String sIPOrDNS)
        throws Exception
    {
    	//System.out.println ("\ndetectIP ('"+sIPOrDNS+"') ...");
    	
    	final InetAddress                              aAddress       = InetAddress.getByName(sIPOrDNS);
    	final InitialDirContext                        aContext       = new InitialDirContext();
    	final String                                   sLookupURL     = "dns:/" + aAddress.getHostName();
    	final Attributes                               lDNSAttributes = aContext.getAttributes(sLookupURL);
    	      NamingEnumeration< ? extends Attribute > pIt            = null;
    	      String                                   sIPV4          = null;
    	      String                                   sIPV6          = null;
    	      
		try
		{
	    	pIt = lDNSAttributes.getAll();
	
	    	while (pIt.hasMore())
	    	{
	    		final BasicAttribute aAttribute = (BasicAttribute) pIt.next();
	    		final String         sAttribute = aAttribute.getID();
	    		final Object         aValue     = aAttribute.get  (); // return default value ... which is enough in our case .-)
	    		
//	    		System.out.println ("\n");
//	    	    System.out.println ("Attribute : " + aAttribute        );
//	    		System.out.println ("ID        : " + aAttribute.getID());
//	    		System.out.println ("Value     : " + aAttribute.get  ());

	    		// prefer IPV4 ...
	    		// If we find such IP ..
	    		// we can break the loop .-)

	    		if (StringUtils.equals(sAttribute, DNS_ATTR_IPV4_RECORD_A))
	    		{
	    			sIPV4 = (String) aValue;
	    			break;
	    		}

	    		// search for IPV6 too ...
	    		// but cache those IP only ...
	    		// It's used in case IPV4 is not detected only !
	    		
	    		if (StringUtils.equals(sAttribute, DNS_ATTR_IPV6_RECORD_A))
	    		{
	    			sIPV6 = (String) aValue;
	    			// ! NO BREAK !
	    		}
	    	}
		}
		catch (Throwable ex)
		{
			// our error handling is return null .-)
		}
		finally
		{
			if (pIt != null)
				pIt.close();
		}

		if ( ! StringUtils.isEmpty(sIPV4))
			return sIPV4;
		
		if ( ! StringUtils.isEmpty(sIPV6))
			return sIPV6;

		return null;
    }
}
