package com.openexchange.office.calcengine.client.impl.jms;

import javax.jms.Message;

public class CalcEngineJMSResponse extends CalcEngineJMSMessage
{
    //-------------------------------------------------------------------------
	public static final String RESPONSE_PROP_PREFIX = CalcEngineJMSMessage.HEADER_PROP_PREFIX+".response";

    //-------------------------------------------------------------------------
	public static final String RESPONSE_PROP_RESULT                 = RESPONSE_PROP_PREFIX+".result";
	public static final String RESPONSE_PROP_JSON_OPERATIONRESPONSE = RESPONSE_PROP_PREFIX+".json-operation-response";

    //-------------------------------------------------------------------------
	private CalcEngineJMSResponse ()
	{}

    //-------------------------------------------------------------------------
	public static CalcEngineJMSResponse create ()
	    throws Exception
	{
		return new CalcEngineJMSResponse ();
	}

    //-------------------------------------------------------------------------
	public static CalcEngineJMSResponse create (final Message aMessage)
	    throws Exception
	{
		final CalcEngineJMSResponse aResponse = new CalcEngineJMSResponse ();
		aResponse.fromJMSMessage(aMessage);
		return aResponse;
	}

	//-------------------------------------------------------------------------
	@Override
    public void fromJMSMessage (final Message aMessage)
	    throws Exception
	{
		super.fromJMSMessage(aMessage);

		final String            sResult = aMessage.getStringProperty (RESPONSE_PROP_RESULT);
		final ECalcEngineResult eResult = ECalcEngineResult.fromString (sResult);
		setResult (eResult);

		final String sJSONOperationResponse = aMessage.getStringProperty (RESPONSE_PROP_JSON_OPERATIONRESPONSE);
		setJSONOperationResponse (sJSONOperationResponse);
	}

	//-------------------------------------------------------------------------
	@Override
    public void toJMSMessage (final Message aMessage)
	    throws Exception
	{
		super.toJMSMessage (aMessage);

		final ECalcEngineResult eResult = getResult ();
		final String            sResult = ECalcEngineResult.toString(eResult);
		aMessage.setStringProperty (RESPONSE_PROP_RESULT, sResult);

		final String sJSONOperationResponse = getJSONOperationResponse ();
		aMessage.setStringProperty (RESPONSE_PROP_JSON_OPERATIONRESPONSE, sJSONOperationResponse);
	}

	//-------------------------------------------------------------------------
	public void setResult (final ECalcEngineResult eResult)
		throws Exception
	{
		m_eResult = eResult;
	}

	//-------------------------------------------------------------------------
	public void setResult (final Throwable aError)
		throws Exception
	{
		m_eResult = ECalcEngineResult.E_ERROR;
	}

	//-------------------------------------------------------------------------
	public ECalcEngineResult getResult ()
		throws Exception
	{
		return m_eResult;
	}

	//-------------------------------------------------------------------------
	public void setJSONOperationResponse (final String sJSON)
	    throws Exception
	{
		m_sJSONOperationResponse = sJSON;
	}

	//-------------------------------------------------------------------------
	public String getJSONOperationResponse ()
	    throws Exception
	{
		return m_sJSONOperationResponse;
	}

	//-------------------------------------------------------------------------
	private ECalcEngineResult m_eResult = null;

	//-------------------------------------------------------------------------
	private String m_sJSONOperationResponse = null;
}
