/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.calcengine.client;

import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;

//=============================================================================
public class CalcEngineHttpEntity
{
	//-------------------------------------------------------------------------
	public static final String JSONKEY_ERROR_STATE    = "error-state"    ;
	public static final String JSONKEY_JSON_PAYLOAD   = "json-payload"   ;
	public static final String JSONKEY_CLIPBOARDEVENT = "clipboard-event";
	
	//-------------------------------------------------------------------------
	private CalcEngineHttpEntity ()
	{}
	
	//-------------------------------------------------------------------------
	public static CalcEngineHttpEntity EMPTY ()
	    throws Exception
	{
		final CalcEngineHttpEntity aEntity = new CalcEngineHttpEntity ();
		return aEntity;
	}

	//-------------------------------------------------------------------------
	public static CalcEngineHttpEntity OK (final String                   sPayload       ,
										   final CalcEngineClipBoardEvent aClipboardEvent)
	    throws Exception
	{
		final CalcEngineHttpEntity aEntity = new CalcEngineHttpEntity ();
		aEntity.m_eError          = ECalcEngineError.E_NONE;
		aEntity.m_sJSONPayload    = sPayload;
		aEntity.m_aClipboardEvent = aClipboardEvent;
		return aEntity;
	}
	
	//-------------------------------------------------------------------------
	public static CalcEngineHttpEntity ERROR (final ECalcEngineError eError)
	    throws Exception
	{
		final CalcEngineHttpEntity aEntity = new CalcEngineHttpEntity ();
		aEntity.m_eError = eError;
		return aEntity;
	}

	//-------------------------------------------------------------------------
	public ECalcEngineError getError ()
		throws Exception
	{
		return m_eError;
	}

	//-------------------------------------------------------------------------
	public String getJSONPayload ()
	    throws Exception
	{
		return m_sJSONPayload;
	}
	
	//-------------------------------------------------------------------------
	public CalcEngineClipBoardEvent getClipboardEvent ()
	    throws Exception
	{
		return m_aClipboardEvent;
	}

	//-------------------------------------------------------------------------
	@Override
	public String toString ()
	{
		try
		{
			final StringBuffer sString = new StringBuffer (256);
			sString.append (super.toString());
			sString.append (" : "           );
			sString.append (CalcEngineHttpEntity.toJSON(this));
			return sString.toString ();
		}
		catch (Exception ex)
		{}
		
		return super.toString ();
	}
	
	//-------------------------------------------------------------------------
	public static String toJSON (final CalcEngineHttpEntity aEntity)
	    throws Exception
	{
        final JSONObject aJson = new JSONObject();

        // mandatory
        aJson.put(JSONKEY_ERROR_STATE, ECalcEngineError.toString(aEntity.m_eError));

        // optional
        if ( ! StringUtils.isEmpty(aEntity.m_sJSONPayload))
        	aJson.put(JSONKEY_JSON_PAYLOAD, aEntity.m_sJSONPayload );

        // optional
        if (aEntity.m_aClipboardEvent != null)
        {
        	final String sEventJson = CalcEngineClipBoardEvent.toJSON(aEntity.m_aClipboardEvent);
        	aJson.put(JSONKEY_CLIPBOARDEVENT, sEventJson);
        }

        final String sJson = aJson.toString();
        return sJson;
	}

	//-------------------------------------------------------------------------
	public static CalcEngineHttpEntity fromJSON (final String sJSON)
	    throws Exception
	{
		final JSONObject           aJSON   = new JSONObject (sJSON);
		final CalcEngineHttpEntity aEntity = new CalcEngineHttpEntity ();

		if (aJSON.hasAndNotNull(JSONKEY_ERROR_STATE))
			aEntity.m_eError = ECalcEngineError.fromString(aJSON.getString(JSONKEY_ERROR_STATE));

		if (aJSON.hasAndNotNull(JSONKEY_JSON_PAYLOAD))
			aEntity.m_sJSONPayload = impl_trimPureJSONString((String)aJSON.get(JSONKEY_JSON_PAYLOAD));

		if (aJSON.hasAndNotNull(JSONKEY_CLIPBOARDEVENT))
		{
			String sEventJson = (String)aJSON.get(JSONKEY_CLIPBOARDEVENT);
			       sEventJson = impl_trimPureJSONString(sEventJson);
			aEntity.m_aClipboardEvent = CalcEngineClipBoardEvent.fromJSON(sEventJson);
		}

		return aEntity;
	}

//	//-------------------------------------------------------------------------
//	@Deprecated
//	public static CalcEngineHttpEntity fromJSON (final Map< ?, ? > aJSON)
//	    throws Exception
//	{
//		final CalcEngineHttpEntity aEntity = new CalcEngineHttpEntity ();
//
//		aEntity.m_eError       = ECalcEngineError.from  ((String)aJSON.get(JSONKEY_ERROR_STATE ));
//		aEntity.m_sJSONPayload = impl_trimPureJSONString((String)aJSON.get(JSONKEY_JSON_PAYLOAD));
//
//		return aEntity;
//	}
	
	//-------------------------------------------------------------------------
	/** If there are some JSON parser/generator on the way ... an original JSON string
	 *  will be quoted (sometimes). But we know - our member ResultJSON is a pure JSON
	 *  string ... so we do not need any quoting there ... and so we remove it .-)
	 * 
	 *	@param	sIn [IN]
	 *			the string to be checked for (wrong) quoting.
	 *
	 *  @return the pure (unquoted) JSON string
	 */
	private static String impl_trimPureJSONString (final String sIn)
	{
		String sOut = sIn;
		sOut = StringUtils.removeStartIgnoreCase(sOut, "\"");
		sOut = StringUtils.removeEndIgnoreCase  (sOut, "\"");
		return sOut;
	}

	//-------------------------------------------------------------------------
	private ECalcEngineError m_eError = null;

	//-------------------------------------------------------------------------
	private String m_sJSONPayload = null;

	//-------------------------------------------------------------------------
	private CalcEngineClipBoardEvent m_aClipboardEvent = null;
}
