/*
*
*    OPEN-XCHANGE legal information
*
*    All intellectual property rights in the Software are protected by
*    international copyright laws.
*
*
*    In some countries OX, OX Open-Xchange, open xchange and OXtender
*    as well as the corresponding Logos OX Open-Xchange and OX are registered
*    trademarks of the Open-Xchange, Inc. group of companies.
*    The use of the Logos is not covered by the GNU General Public License.
*    Instead, you are allowed to use these Logos according to the terms and
*    conditions of the Creative Commons License, Version 2.5, Attribution,
*    Non-commercial, ShareAlike, and the interpretation of the term
*    Non-commercial applicable to the aforementioned license is published
*    on the web site http://www.open-xchange.com/EN/legal/index.html.
*
*    Please make sure that third-party modules and libraries are used
*    according to their respective licenses.
*
*    Any modifications to this package must retain all copyright notices
*    of the original copyright holder(s) for the original code used.
*
*    After any such modifications, the original and derivative code shall remain
*    under the copyright of the copyright holder(s) and/or original author(s)per
*    the Attribution and Assignment Agreement that can be located at
*    http://www.open-xchange.com/EN/developer/. The contributing author shall be
*    given Attribution for the derivative code and a license granting use.
*
*     Copyright (C) 2004-2012 Open-Xchange, Inc.
*     Mail: info@open-xchange.com
*
*
*     This program is free software; you can redistribute it and/or modify it
*     under the terms of the GNU General Public License, Version 2 as published
*     by the Free Software Foundation.
*
*     This program is distributed in the hope that it will be useful, but
*     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
*     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
*     for more details.
*
*     You should have received a copy of the GNU General Public License along
*     with this program; if not, write to the Free Software Foundation, Inc., 59
*     Temple Place, Suite 330, Boston, MA 02111-1307 USA
*
*/

package com.openexchange.spellchecker;

import java.util.List;
import org.json.JSONArray;
/**
* {@link ISpellChecker}
*
* @author <a href="mailto:oliver.specht@open-xchange.com">Oliver Specht</a>
* 
* 
*/
public interface ISpellChecker {
    /**
     * @param word
     * @param locale
     * @param offset 
     * 	contains an optional offset to use the error result in a paragraph context 
     * @return JSONArray containing JSONObjects that contain a 'start' and and 'length' attribute of a spelling error   
     */
    public JSONArray checkSpelling( String word, String locale, int offset );
    /**
     * @param paragraph array that contains the parts of the paragraph combined to it's locale as 'text' and 'local' objects.
     * @param locale
     * @return JSONArray containing JSONObjects that contain a 'start' and and 'length' attribute of a spelling error of the paragraph 
     */
    public JSONArray checkParagraphSpelling( JSONArray paragraph );
   /**
    * 
    * @param word
    * @param locale
    * @return
    */
   public List<String> suggestReplacements( String word, String locale );
   /** 
    * @param word word to be checked
    * @param locale locale to be used 
    * @return true if word is detected as wrongly spelled
    */
   public boolean isMisspelled( String word, String locale );
   /**
    * 
    * @return a list of locales supported by the spell checker
    */
   public List<String> getSupportedLocales();
 

}