/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.tools.jobpool;

//=============================================================================
/** the public API of a job running within these job pool environment ...
 * 
 *  You can obtain a job instance from a corresponding {@link IJobPool}.
 *
 *  @note Please read documentation of {@link IJobPool} carefully.
 *        Using jobs is bound to some rules ... you should know and respect .-)
 */
public interface IJob
{
	//-------------------------------------------------------------------------
	public static final int INVALID_JOB_ID = -1;
	
	//-------------------------------------------------------------------------
	public int getId ()
	    throws Exception;

	//-------------------------------------------------------------------------
	/** execute the job synchronous.
	 * 
	 *  You can pass arguments and will get results back synchronous.
	 *  
	 *  Every job will be cancelled by the framework if it's execution time
	 *  exceeds the (within the pool configured) timeout value.
	 *  
	 *  Ask {@link JobResults#wasTimeout()} to detect that state.
	 *
	 *  @note	this will block the current thread.
	 * 
	 *	@param	lArguments [IN]
	 *			the list of arguments suitable for this request only.
	 *
	 *	@return the list of results.
	 */
	public JobResults executeSynchronous (final JobArguments lArguments)
		throws Exception;

	//-------------------------------------------------------------------------
	/** execute the job asynchronous.
	 * 
	 *  You can pass arguments and will get results back asynchronous
	 *  by calling the provided results sink. If no results sink will
	 *  be provided .. it's up to you to find out when the job will be
	 *  finished .-)
	 *  
	 *  Every job will be cancelled by the framework if it's execution time
	 *  exceeds the (within the pool configured) timeout value.
	 *  
	 *  Ask {@link JobResults#wasTimeout()} to detect that state
	 *  if its passed to your results sink.
	 *  
	 *  @note	this method schedule an asynchronous operation only
	 *  		and will return immediately.
	 *
	 *	@param	lArguments [IN]
	 *			the list of arguments suitable for this request only.
	 *
	 * 	@param	iSink [IN]
	 * 			those sink is called if job was finished (or even cancelled).
	 * 			Results will be padded to that sink as well.
	 */
	public void executeAsynchronoues (final JobArguments   lArguments,
									  final IJobResultSink iSink     )
		throws Exception;
}
