/*
 *  Copyright 2010, Plutext Pty Ltd.
 *
 *  This file is part of docx4j.

    docx4j is licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.

    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

 */


package org.xlsx4j.sml;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlElementDecl;
import javax.xml.bind.annotation.XmlRegistry;
import javax.xml.namespace.QName;


/**
 * This object contains factory methods for each
 * Java content interface and Java element interface
 * generated in the org.xlsx4j.sml package.
 * <p>An ObjectFactory allows you to programatically
 * construct new instances of the Java representation
 * for XML content. The Java representation of XML
 * content can consist of schema derived interfaces
 * and classes representing the binding of schema
 * type definitions, element declarations and model
 * groups.  Factory methods for each of these are
 * provided in this class.
 *
 */
@XmlRegistry
public class ObjectFactory {

    private final static QName _Connections_QNAME = new QName("http://schemas.openxmlformats.org/spreadsheetml/2006/main", "connections");
    private final static QName _Metadata_QNAME = new QName("http://schemas.openxmlformats.org/spreadsheetml/2006/main", "metadata");
    private final static QName _ExternalLink_QNAME = new QName("http://schemas.openxmlformats.org/spreadsheetml/2006/main", "externalLink");
    private final static QName _Comments_QNAME = new QName("http://schemas.openxmlformats.org/spreadsheetml/2006/main", "comments");
    private final static QName _SingleXmlCells_QNAME = new QName("http://schemas.openxmlformats.org/spreadsheetml/2006/main", "singleXmlCells");
    private final static QName _Revisions_QNAME = new QName("http://schemas.openxmlformats.org/spreadsheetml/2006/main", "revisions");
    private final static QName _Sst_QNAME = new QName("http://schemas.openxmlformats.org/spreadsheetml/2006/main", "sst");
    private final static QName _StyleSheet_QNAME = new QName("http://schemas.openxmlformats.org/spreadsheetml/2006/main", "styleSheet");
    private final static QName _Chartsheet_QNAME = new QName("http://schemas.openxmlformats.org/spreadsheetml/2006/main", "chartsheet");
    private final static QName _Workbook_QNAME = new QName("http://schemas.openxmlformats.org/spreadsheetml/2006/main", "workbook");
    private final static QName _Table_QNAME = new QName("http://schemas.openxmlformats.org/spreadsheetml/2006/main", "table");
    private final static QName _PivotCacheRecords_QNAME = new QName("http://schemas.openxmlformats.org/spreadsheetml/2006/main", "pivotCacheRecords");
    private final static QName _Worksheet_QNAME = new QName("http://schemas.openxmlformats.org/spreadsheetml/2006/main", "worksheet");
    private final static QName _Dialogsheet_QNAME = new QName("http://schemas.openxmlformats.org/spreadsheetml/2006/main", "dialogsheet");
    private final static QName _PivotCacheDefinition_QNAME = new QName("http://schemas.openxmlformats.org/spreadsheetml/2006/main", "pivotCacheDefinition");
    private final static QName _VolTypes_QNAME = new QName("http://schemas.openxmlformats.org/spreadsheetml/2006/main", "volTypes");
    private final static QName _MapInfo_QNAME = new QName("http://schemas.openxmlformats.org/spreadsheetml/2006/main", "MapInfo");
    private final static QName _QueryTable_QNAME = new QName("http://schemas.openxmlformats.org/spreadsheetml/2006/main", "queryTable");
    private final static QName _Users_QNAME = new QName("http://schemas.openxmlformats.org/spreadsheetml/2006/main", "users");
    private final static QName _CalcChain_QNAME = new QName("http://schemas.openxmlformats.org/spreadsheetml/2006/main", "calcChain");
    private final static QName _Headers_QNAME = new QName("http://schemas.openxmlformats.org/spreadsheetml/2006/main", "headers");
    private final static QName _PivotTableDefinition_QNAME = new QName("http://schemas.openxmlformats.org/spreadsheetml/2006/main", "pivotTableDefinition");
    private final static QName _CTFont_QNAME = new QName("http://schemas.openxmlformats.org/spreadsheetml/2006/main", "font");
    private final static QName _CTFontSz_QNAME = new QName("http://schemas.openxmlformats.org/spreadsheetml/2006/main", "sz");
    private final static QName _CTFontCondense_QNAME = new QName("http://schemas.openxmlformats.org/spreadsheetml/2006/main", "condense");
    private final static QName _CTFontStrike_QNAME = new QName("http://schemas.openxmlformats.org/spreadsheetml/2006/main", "strike");
    private final static QName _CTFontU_QNAME = new QName("http://schemas.openxmlformats.org/spreadsheetml/2006/main", "u");
    private final static QName _CTFontVertAlign_QNAME = new QName("http://schemas.openxmlformats.org/spreadsheetml/2006/main", "vertAlign");
    private final static QName _CTFontName_QNAME = new QName("http://schemas.openxmlformats.org/spreadsheetml/2006/main", "name");
    private final static QName _CTFontShadow_QNAME = new QName("http://schemas.openxmlformats.org/spreadsheetml/2006/main", "shadow");
    private final static QName _CTFontFamily_QNAME = new QName("http://schemas.openxmlformats.org/spreadsheetml/2006/main", "family");
    private final static QName _CTFontColor_QNAME = new QName("http://schemas.openxmlformats.org/spreadsheetml/2006/main", "color");
    private final static QName _CTFontScheme_QNAME = new QName("http://schemas.openxmlformats.org/spreadsheetml/2006/main", "scheme");
    private final static QName _CTFontCharset_QNAME = new QName("http://schemas.openxmlformats.org/spreadsheetml/2006/main", "charset");
    private final static QName _CTFontI_QNAME = new QName("http://schemas.openxmlformats.org/spreadsheetml/2006/main", "i");
    private final static QName _CTFontOutline_QNAME = new QName("http://schemas.openxmlformats.org/spreadsheetml/2006/main", "outline");
    private final static QName _CTFontExtend_QNAME = new QName("http://schemas.openxmlformats.org/spreadsheetml/2006/main", "extend");
    private final static QName _CTFontB_QNAME = new QName("http://schemas.openxmlformats.org/spreadsheetml/2006/main", "b");
    private final static QName _CTRPrEltRFont_QNAME = new QName("http://schemas.openxmlformats.org/spreadsheetml/2006/main", "rFont");
    private final static QName _CTXf_QNAME = new QName("http://schemas.openxmlformats.org/spreadsheetml/2006/main", "xf");
    private final static QName _CTFill_QNAME = new QName("http://schemas.openxmlformats.org/spreadsheetml/2006/main", "fill");
    private final static QName _CTBorder_QNAME = new QName("http://schemas.openxmlformats.org/spreadsheetml/2006/main", "border");
    private final static QName _CTDataValidations_legacy_QNAME = new QName("http://schemas.microsoft.com/office/spreadsheetml/2009/9/main", "dataValidations");
    private final static QName _CTDataValidation_legacy_QNAME = new QName("http://schemas.microsoft.com/office/spreadsheetml/2009/9/main", "dataValidation");

    /**
     * Create a new ObjectFactory that can be used to create new instances of schema derived classes for package: org.xlsx4j.sml
     *
     */
    public ObjectFactory() {
    }

    /**
     * Create an instance of {@link CTWebPublishItem }
     *
     */
    public CTWebPublishItem createCTWebPublishItem() {
        return new CTWebPublishItem();
    }

    /**
     * Create an instance of {@link Sheets }
     *
     */
    public Sheets createSheets() {
        return new Sheets();
    }

    /**
     * Create an instance of {@link CTTables }
     *
     */
    public CTTables createCTTables() {
        return new CTTables();
    }

    /**
     * Create an instance of {@link CTTextField }
     *
     */
    public CTTextField createCTTextField() {
        return new CTTextField();
    }

    /**
     * Create an instance of {@link CTCustomFilter }
     *
     */
    public CTCustomFilter createCTCustomFilter() {
        return new CTCustomFilter();
    }

    /**
     * Create an instance of {@link CTRecord }
     *
     */
    public CTRecord createCTRecord() {
        return new CTRecord();
    }

    /**
     * Create an instance of {@link CTQueryTable }
     *
     */
    public CTQueryTable createCTQueryTable() {
        return new CTQueryTable();
    }

    /**
     * Create an instance of {@link CTIconSet }
     *
     */
    public CTIconSet createCTIconSet() {
        return new CTIconSet();
    }

    /**
     * Create an instance of {@link Col }
     *
     */
    public Col createCol() {
        return new Col();
    }

    /**
     * Create an instance of {@link CTFilters }
     *
     */
    public CTFilters createCTFilters() {
        return new CTFilters();
    }

    /**
     * Create an instance of {@link CTFontName }
     *
     */
    public CTFontName createCTFontName() {
        return new CTFontName();
    }

    /**
     * Create an instance of {@link CTItem }
     *
     */
    public CTItem createCTItem() {
        return new CTItem();
    }

    /**
     * Create an instance of {@link CTComments }
     *
     */
    public CTComments createCTComments() {
        return new CTComments();
    }

    /**
     * Create an instance of {@link CTPivotFields }
     *
     */
    public CTPivotFields createCTPivotFields() {
        return new CTPivotFields();
    }

    /**
     * Create an instance of {@link CTWebPublishObjects }
     *
     */
    public CTWebPublishObjects createCTWebPublishObjects() {
        return new CTWebPublishObjects();
    }

    /**
     * Create an instance of {@link Row }
     *
     */
    public Row createRow() {
        return new Row();
    }

    /**
     * Create an instance of {@link CTConnection }
     *
     */
    public CTConnection createCTConnection() {
        return new CTConnection();
    }

    /**
     * Create an instance of {@link CTMdxSet }
     *
     */
    public CTMdxSet createCTMdxSet() {
        return new CTMdxSet();
    }

    /**
     * Create an instance of {@link CTChartsheetView }
     *
     */
    public CTChartsheetView createCTChartsheetView() {
        return new CTChartsheetView();
    }

    /**
     * Create an instance of {@link CTFunctionGroup }
     *
     */
    public CTFunctionGroup createCTFunctionGroup() {
        return new CTFunctionGroup();
    }

    /**
     * Create an instance of {@link CTFont }
     *
     */
    public CTFont createCTFont() {
        return new CTFont();
    }

    /**
     * Create an instance of {@link CTCalculatedItem }
     *
     */
    public CTCalculatedItem createCTCalculatedItem() {
        return new CTCalculatedItem();
    }

    /**
     * Create an instance of {@link CTCalcPr }
     *
     */
    public CTCalcPr createCTCalcPr() {
        return new CTCalcPr();
    }

    /**
     * Create an instance of {@link CTCacheHierarchy }
     *
     */
    public CTCacheHierarchy createCTCacheHierarchy() {
        return new CTCacheHierarchy();
    }

    /**
     * Create an instance of {@link CTFill }
     *
     */
    public CTFill createCTFill() {
        return new CTFill();
    }

    /**
     * Create an instance of {@link CTDdeValue }
     *
     */
    public CTDdeValue createCTDdeValue() {
        return new CTDdeValue();
    }

    /**
     * Create an instance of {@link CTPivotFilter }
     *
     */
    public CTPivotFilter createCTPivotFilter() {
        return new CTPivotFilter();
    }

    /**
     * Create an instance of {@link CTPane }
     *
     */
    public CTPane createCTPane() {
        return new CTPane();
    }

    /**
     * Create an instance of {@link CTMembers }
     *
     */
    public CTMembers createCTMembers() {
        return new CTMembers();
    }

    /**
     * Create an instance of {@link CTConditionalFormatting }
     *
     */
    public CTConditionalFormatting createCTConditionalFormatting() {
        return new CTConditionalFormatting();
    }

    /**
     * Create an instance of {@link CTPatternFill }
     *
     */
    public CTPatternFill createCTPatternFill() {
        return new CTPatternFill();
    }

    /**
     * Create an instance of {@link CTTuple }
     *
     */
    public CTTuple createCTTuple() {
        return new CTTuple();
    }

    /**
     * Create an instance of {@link CTCacheSource }
     *
     */
    public CTCacheSource createCTCacheSource() {
        return new CTCacheSource();
    }

    /**
     * Create an instance of {@link CTVerticalAlignFontProperty }
     *
     */
    public CTVerticalAlignFontProperty createCTVerticalAlignFontProperty() {
        return new CTVerticalAlignFontProperty();
    }

    /**
     * Create an instance of {@link CTPivotField }
     *
     */
    public CTPivotField createCTPivotField() {
        return new CTPivotField();
    }

    /**
     * Create an instance of {@link CTBorder }
     *
     */
    public CTBorder createCTBorder() {
        return new CTBorder();
    }

    /**
     * Create an instance of {@link CTHierarchyUsage }
     *
     */
    public CTHierarchyUsage createCTHierarchyUsage() {
        return new CTHierarchyUsage();
    }

    /**
     * Create an instance of {@link CTWebPublishObject }
     *
     */
    public CTWebPublishObject createCTWebPublishObject() {
        return new CTWebPublishObject();
    }

    /**
     * Create an instance of {@link CTCellStyleXfs }
     *
     */
    public CTCellStyleXfs createCTCellStyleXfs() {
        return new CTCellStyleXfs();
    }

    /**
     * Create an instance of {@link CTCacheHierarchies }
     *
     */
    public CTCacheHierarchies createCTCacheHierarchies() {
        return new CTCacheHierarchies();
    }

    /**
     * Create an instance of {@link CTSortState }
     *
     */
    public CTSortState createCTSortState() {
        return new CTSortState();
    }

    /**
     * Create an instance of {@link CTDataFields }
     *
     */
    public CTDataFields createCTDataFields() {
        return new CTDataFields();
    }

    /**
     * Create an instance of {@link CTSmartTagPr }
     *
     */
    public CTSmartTagPr createCTSmartTagPr() {
        return new CTSmartTagPr();
    }

    /**
     * Create an instance of {@link CTChartsheetProtection }
     *
     */
    public CTChartsheetProtection createCTChartsheetProtection() {
        return new CTChartsheetProtection();
    }

    /**
     * Create an instance of {@link CTCsPageSetup }
     *
     */
    public CTCsPageSetup createCTCsPageSetup() {
        return new CTCsPageSetup();
    }

    /**
     * Create an instance of {@link CTCustomWorkbookViews }
     *
     */
    public CTCustomWorkbookViews createCTCustomWorkbookViews() {
        return new CTCustomWorkbookViews();
    }

    /**
     * Create an instance of {@link CTMeasureGroup }
     *
     */
    public CTMeasureGroup createCTMeasureGroup() {
        return new CTMeasureGroup();
    }

    /**
     * Create an instance of {@link CTQueryCache }
     *
     */
    public CTQueryCache createCTQueryCache() {
        return new CTQueryCache();
    }

    /**
     * Create an instance of {@link CTPageField }
     *
     */
    public CTPageField createCTPageField() {
        return new CTPageField();
    }

    /**
     * Create an instance of {@link CTPhoneticPr }
     *
     */
    public CTPhoneticPr createCTPhoneticPr() {
        return new CTPhoneticPr();
    }

    /**
     * Create an instance of {@link CTCellSmartTagPr }
     *
     */
    public CTCellSmartTagPr createCTCellSmartTagPr() {
        return new CTCellSmartTagPr();
    }

    /**
     * Create an instance of {@link Cols }
     *
     */
    public Cols createCols() {
        return new Cols();
    }

    /**
     * Create an instance of {@link CTCellXfs }
     *
     */
    public CTCellXfs createCTCellXfs() {
        return new CTCellXfs();
    }

    /**
     * Create an instance of {@link CTSheetBackgroundPicture }
     *
     */
    public CTSheetBackgroundPicture createCTSheetBackgroundPicture() {
        return new CTSheetBackgroundPicture();
    }

    /**
     * Create an instance of {@link CTField }
     *
     */
    public CTField createCTField() {
        return new CTField();
    }

    /**
     * Create an instance of {@link CTMember }
     *
     */
    public CTMember createCTMember() {
        return new CTMember();
    }

    /**
     * Create an instance of {@link CTCalculatedMembers }
     *
     */
    public CTCalculatedMembers createCTCalculatedMembers() {
        return new CTCalculatedMembers();
    }

    /**
     * Create an instance of {@link CTRPrElt }
     *
     */
    public CTRPrElt createCTRPrElt() {
        return new CTRPrElt();
    }

    /**
     * Create an instance of {@link CTColItems }
     *
     */
    public CTColItems createCTColItems() {
        return new CTColItems();
    }

    /**
     * Create an instance of {@link CTDimensions }
     *
     */
    public CTDimensions createCTDimensions() {
        return new CTDimensions();
    }

    /**
     * Create an instance of {@link CTDataRef }
     *
     */
    public CTDataRef createCTDataRef() {
        return new CTDataRef();
    }

    /**
     * Create an instance of {@link CTOlapPr }
     *
     */
    public CTOlapPr createCTOlapPr() {
        return new CTOlapPr();
    }

    /**
     * Create an instance of {@link CTRevisionCustomView }
     *
     */
    public CTRevisionCustomView createCTRevisionCustomView() {
        return new CTRevisionCustomView();
    }

    /**
     * Create an instance of {@link CTXmlCellPr }
     *
     */
    public CTXmlCellPr createCTXmlCellPr() {
        return new CTXmlCellPr();
    }

    /**
     * Create an instance of {@link CTCustomChartsheetViews }
     *
     */
    public CTCustomChartsheetViews createCTCustomChartsheetViews() {
        return new CTCustomChartsheetViews();
    }

    /**
     * Create an instance of {@link CTGradientFill }
     *
     */
    public CTGradientFill createCTGradientFill() {
        return new CTGradientFill();
    }

    /**
     * Create an instance of {@link CTSingleXmlCell }
     *
     */
    public CTSingleXmlCell createCTSingleXmlCell() {
        return new CTSingleXmlCell();
    }

    /**
     * Create an instance of {@link CTWebPr }
     *
     */
    public CTWebPr createCTWebPr() {
        return new CTWebPr();
    }

    /**
     * Create an instance of {@link CTPivotTableStyle }
     *
     */
    public CTPivotTableStyle createCTPivotTableStyle() {
        return new CTPivotTableStyle();
    }

    /**
     * Create an instance of {@link CTRevisionInsertSheet }
     *
     */
    public CTRevisionInsertSheet createCTRevisionInsertSheet() {
        return new CTRevisionInsertSheet();
    }

    /**
     * Create an instance of {@link CTPivotCacheDefinition }
     *
     */
    public CTPivotCacheDefinition createCTPivotCacheDefinition() {
        return new CTPivotCacheDefinition();
    }

    /**
     * Create an instance of {@link CTAutoFilter }
     *
     */
    public CTAutoFilter createCTAutoFilter() {
        return new CTAutoFilter();
    }

    /**
     * Create an instance of {@link CTMetadataRecord }
     *
     */
    public CTMetadataRecord createCTMetadataRecord() {
        return new CTMetadataRecord();
    }

    /**
     * Create an instance of {@link CTXmlColumnPr }
     *
     */
    public CTXmlColumnPr createCTXmlColumnPr() {
        return new CTXmlColumnPr();
    }

    /**
     * Create an instance of {@link CTBorderPr }
     *
     */
    public CTBorderPr createCTBorderPr() {
        return new CTBorderPr();
    }

    /**
     * Create an instance of {@link CTTableStyle }
     *
     */
    public CTTableStyle createCTTableStyle() {
        return new CTTableStyle();
    }

    /**
     * Create an instance of {@link CTCalculatedItems }
     *
     */
    public CTCalculatedItems createCTCalculatedItems() {
        return new CTCalculatedItems();
    }

    /**
     * Create an instance of {@link CTMRUColors }
     *
     */
    public CTMRUColors createCTMRUColors() {
        return new CTMRUColors();
    }

    /**
     * Create an instance of {@link WorkbookPr }
     *
     */
    public WorkbookPr createWorkbookPr() {
        return new WorkbookPr();
    }

    /**
     * Create an instance of {@link CTExternalSheetData }
     *
     */
    public CTExternalSheetData createCTExternalSheetData() {
        return new CTExternalSheetData();
    }

    /**
     * Create an instance of {@link CTCalculatedMember }
     *
     */
    public CTCalculatedMember createCTCalculatedMember() {
        return new CTCalculatedMember();
    }

    /**
     * Create an instance of {@link CTCacheFields }
     *
     */
    public CTCacheFields createCTCacheFields() {
        return new CTCacheFields();
    }

    /**
     * Create an instance of {@link CTOleLink }
     *
     */
    public CTOleLink createCTOleLink() {
        return new CTOleLink();
    }

    /**
     * Create an instance of {@link CTNumFmt }
     *
     */
    public CTNumFmt createCTNumFmt() {
        return new CTNumFmt();
    }

    /**
     * Create an instance of {@link FileVersion }
     *
     */
    public FileVersion createFileVersion() {
        return new FileVersion();
    }

    /**
     * Create an instance of {@link CTPivotTableDefinition }
     *
     */
    public CTPivotTableDefinition createCTPivotTableDefinition() {
        return new CTPivotTableDefinition();
    }

    /**
     * Create an instance of {@link CTSheetId }
     *
     */
    public CTSheetId createCTSheetId() {
        return new CTSheetId();
    }

    /**
     * Create an instance of {@link CTRevisionConflict }
     *
     */
    public CTRevisionConflict createCTRevisionConflict() {
        return new CTRevisionConflict();
    }

    /**
     * Create an instance of {@link CTQueryTableFields }
     *
     */
    public CTQueryTableFields createCTQueryTableFields() {
        return new CTQueryTableFields();
    }

    /**
     * Create an instance of {@link Workbook }
     *
     */
    public Workbook createWorkbook() {
        return new Workbook();
    }

    /**
     * Create an instance of {@link CTXmlPr }
     *
     */
    public CTXmlPr createCTXmlPr() {
        return new CTXmlPr();
    }

    /**
     * Create an instance of {@link CTVolTypes }
     *
     */
    public CTVolTypes createCTVolTypes() {
        return new CTVolTypes();
    }

    /**
     * Create an instance of {@link CTSheetProtection }
     *
     */
    public CTSheetProtection createCTSheetProtection() {
        return new CTSheetProtection();
    }

    /**
     * Create an instance of {@link CTDataBar }
     *
     */
    public CTDataBar createCTDataBar() {
        return new CTDataBar();
    }

    /**
     * Create an instance of {@link CTExtensionList }
     *
     */
    public CTExtensionList createCTExtensionList() {
        return new CTExtensionList();
    }

    /**
     * Create an instance of {@link CTScenario }
     *
     */
    public CTScenario createCTScenario() {
        return new CTScenario();
    }

    /**
     * Create an instance of {@link CTRevisionAutoFormatting }
     *
     */
    public CTRevisionAutoFormatting createCTRevisionAutoFormatting() {
        return new CTRevisionAutoFormatting();
    }

    /**
     * Create an instance of {@link CTControl }
     *
     */
    public CTControl createCTControl() {
        return new CTControl();
    }

    /**
     * Create an instance of {@link CTCellWatches }
     *
     */
    public CTCellWatches createCTCellWatches() {
        return new CTCellWatches();
    }

    /**
     * Create an instance of {@link CTRevisionCellChange }
     *
     */
    public CTRevisionCellChange createCTRevisionCellChange() {
        return new CTRevisionCellChange();
    }

    /**
     * Create an instance of {@link CTSheetPr }
     *
     */
    public CTSheetPr createCTSheetPr() {
        return new CTSheetPr();
    }

    /**
     * Create an instance of {@link CTFills }
     *
     */
    public CTFills createCTFills() {
        return new CTFills();
    }

    /**
     * Create an instance of {@link CTCfvo }
     *
     */
    public CTCfvo createCTCfvo() {
        return new CTCfvo();
    }

    /**
     * Create an instance of {@link CTX }
     *
     */
    public CTX createCTX() {
        return new CTX();
    }

    /**
     * Create an instance of {@link CTProtectedRange }
     *
     */
    public CTProtectedRange createCTProtectedRange() {
        return new CTProtectedRange();
    }

    /**
     * Create an instance of {@link CTRowHierarchiesUsage }
     *
     */
    public CTRowHierarchiesUsage createCTRowHierarchiesUsage() {
        return new CTRowHierarchiesUsage();
    }

    /**
     * Create an instance of {@link CTServerFormats }
     *
     */
    public CTServerFormats createCTServerFormats() {
        return new CTServerFormats();
    }

    /**
     * Create an instance of {@link CTDataRefs }
     *
     */
    public CTDataRefs createCTDataRefs() {
        return new CTDataRefs();
    }

    /**
     * Create an instance of {@link CTExternalRow }
     *
     */
    public CTExternalRow createCTExternalRow() {
        return new CTExternalRow();
    }

    /**
     * Create an instance of {@link CTScenarios }
     *
     */
    public CTScenarios createCTScenarios() {
        return new CTScenarios();
    }

    /**
     * Create an instance of {@link CTMap }
     *
     */
    public CTMap createCTMap() {
        return new CTMap();
    }

    /**
     * Create an instance of {@link CTFileRecoveryPr }
     *
     */
    public CTFileRecoveryPr createCTFileRecoveryPr() {
        return new CTFileRecoveryPr();
    }

    /**
     * Create an instance of {@link CTItems }
     *
     */
    public CTItems createCTItems() {
        return new CTItems();
    }

    /**
     * Create an instance of {@link CTDxfs }
     *
     */
    public CTDxfs createCTDxfs() {
        return new CTDxfs();
    }

    /**
     * Create an instance of {@link CTOleObject }
     *
     */
    public CTOleObject createCTOleObject() {
        return new CTOleObject();
    }

    /**
     * Create an instance of {@link CTIndexedColors }
     *
     */
    public CTIndexedColors createCTIndexedColors() {
        return new CTIndexedColors();
    }

    /**
     * Create an instance of {@link CTCommentList }
     *
     */
    public CTCommentList createCTCommentList() {
        return new CTCommentList();
    }

    /**
     * Create an instance of {@link CTFontSize }
     *
     */
    public CTFontSize createCTFontSize() {
        return new CTFontSize();
    }

    /**
     * Create an instance of {@link CTFormats }
     *
     */
    public CTFormats createCTFormats() {
        return new CTFormats();
    }

    /**
     * Create an instance of {@link CTCustomFilters }
     *
     */
    public CTCustomFilters createCTCustomFilters() {
        return new CTCustomFilters();
    }

    /**
     * Create an instance of {@link CTSheetIdMap }
     *
     */
    public CTSheetIdMap createCTSheetIdMap() {
        return new CTSheetIdMap();
    }

    /**
     * Create an instance of {@link CTPivotAreaReference }
     *
     */
    public CTPivotAreaReference createCTPivotAreaReference() {
        return new CTPivotAreaReference();
    }

    /**
     * Create an instance of {@link CTPCDKPIs }
     *
     */
    public CTPCDKPIs createCTPCDKPIs() {
        return new CTPCDKPIs();
    }

    /**
     * Create an instance of {@link CTRangePr }
     *
     */
    public CTRangePr createCTRangePr() {
        return new CTRangePr();
    }

    /**
     * Create an instance of {@link CTRst }
     *
     */
    public CTRst createCTRst() {
        return new CTRst();
    }

    /**
     * Create an instance of {@link CTFormat }
     *
     */
    public CTFormat createCTFormat() {
        return new CTFormat();
    }

    /**
     * Create an instance of {@link CTTableFormula }
     *
     */
    public CTTableFormula createCTTableFormula() {
        return new CTTableFormula();
    }

    /**
     * Create an instance of {@link CTDdeValues }
     *
     */
    public CTDdeValues createCTDdeValues() {
        return new CTDdeValues();
    }

    /**
     * Create an instance of {@link CTColorFilter }
     *
     */
    public CTColorFilter createCTColorFilter() {
        return new CTColorFilter();
    }

    /**
     * Create an instance of {@link CTIndex }
     *
     */
    public CTIndex createCTIndex() {
        return new CTIndex();
    }

    /**
     * Create an instance of {@link BookViews }
     *
     */
    public BookViews createBookViews() {
        return new BookViews();
    }

    /**
     * Create an instance of {@link CTPivotFilters }
     *
     */
    public CTPivotFilters createCTPivotFilters() {
        return new CTPivotFilters();
    }

    /**
     * Create an instance of {@link CTColor }
     *
     */
    public CTColor createCTColor() {
        return new CTColor();
    }

    /**
     * Create an instance of {@link CTConsolidation }
     *
     */
    public CTConsolidation createCTConsolidation() {
        return new CTConsolidation();
    }

    /**
     * Create an instance of {@link CTCustomWorkbookView }
     *
     */
    public CTCustomWorkbookView createCTCustomWorkbookView() {
        return new CTCustomWorkbookView();
    }

    /**
     * Create an instance of {@link CTCellProtection }
     *
     */
    public CTCellProtection createCTCellProtection() {
        return new CTCellProtection();
    }

    /**
     * Create an instance of {@link CTCfRule }
     *
     */
    public CTCfRule createCTCfRule() {
        return new CTCfRule();
    }

    /**
     * Create an instance of {@link CTPageSetup }
     *
     */
    public CTPageSetup createCTPageSetup() {
        return new CTPageSetup();
    }

    /**
     * Create an instance of {@link CTExternalSheetNames }
     *
     */
    public CTExternalSheetNames createCTExternalSheetNames() {
        return new CTExternalSheetNames();
    }

    /**
     * Create an instance of {@link CTAutoSortScope }
     *
     */
    public CTAutoSortScope createCTAutoSortScope() {
        return new CTAutoSortScope();
    }

    /**
     * Create an instance of {@link CTTable }
     *
     */
    public CTTable createCTTable() {
        return new CTTable();
    }

    /**
     * Create an instance of {@link CTConditionalFormats }
     *
     */
    public CTConditionalFormats createCTConditionalFormats() {
        return new CTConditionalFormats();
    }

    /**
     * Create an instance of {@link CTPages }
     *
     */
    public CTPages createCTPages() {
        return new CTPages();
    }

    /**
     * Create an instance of {@link CTDdeItem }
     *
     */
    public CTDdeItem createCTDdeItem() {
        return new CTDdeItem();
    }

    /**
     * Create an instance of {@link CTSelection }
     *
     */
    public CTSelection createCTSelection() {
        return new CTSelection();
    }

    /**
     * Create an instance of {@link CTGradientStop }
     *
     */
    public CTGradientStop createCTGradientStop() {
        return new CTGradientStop();
    }

    /**
     * Create an instance of {@link CTMdxKPI }
     *
     */
    public CTMdxKPI createCTMdxKPI() {
        return new CTMdxKPI();
    }

    /**
     * Create an instance of {@link CTCustomChartsheetView }
     *
     */
    public CTCustomChartsheetView createCTCustomChartsheetView() {
        return new CTCustomChartsheetView();
    }

    /**
     * Create an instance of {@link CTExternalBook }
     *
     */
    public CTExternalBook createCTExternalBook() {
        return new CTExternalBook();
    }

    /**
     * Create an instance of {@link CTGroupItems }
     *
     */
    public CTGroupItems createCTGroupItems() {
        return new CTGroupItems();
    }

    /**
     * Create an instance of {@link CTGroupLevel }
     *
     */
    public CTGroupLevel createCTGroupLevel() {
        return new CTGroupLevel();
    }

    /**
     * Create an instance of {@link CTMetadataBlocks }
     *
     */
    public CTMetadataBlocks createCTMetadataBlocks() {
        return new CTMetadataBlocks();
    }

    /**
     * Create an instance of {@link CTRevisionQueryTableField }
     *
     */
    public CTRevisionQueryTableField createCTRevisionQueryTableField() {
        return new CTRevisionQueryTableField();
    }

    /**
     * Create an instance of {@link CTCustomSheetViews }
     *
     */
    public CTCustomSheetViews createCTCustomSheetViews() {
        return new CTCustomSheetViews();
    }

    /**
     * Create an instance of {@link CTRevisionComment }
     *
     */
    public CTRevisionComment createCTRevisionComment() {
        return new CTRevisionComment();
    }

    /**
     * Create an instance of {@link CTChartsheet }
     *
     */
    public CTChartsheet createCTChartsheet() {
        return new CTChartsheet();
    }

    /**
     * Create an instance of {@link CTPivotCacheRecords }
     *
     */
    public CTPivotCacheRecords createCTPivotCacheRecords() {
        return new CTPivotCacheRecords();
    }

    /**
     * Create an instance of {@link CTPivotCache }
     *
     */
    public CTPivotCache createCTPivotCache() {
        return new CTPivotCache();
    }

    /**
     * Create an instance of {@link CTFilter }
     *
     */
    public CTFilter createCTFilter() {
        return new CTFilter();
    }

    /**
     * Create an instance of {@link CTTextFields }
     *
     */
    public CTTextFields createCTTextFields() {
        return new CTTextFields();
    }

    /**
     * Create an instance of {@link CTSmartTagTypes }
     *
     */
    public CTSmartTagTypes createCTSmartTagTypes() {
        return new CTSmartTagTypes();
    }

    /**
     * Create an instance of {@link CTTableMissing }
     *
     */
    public CTTableMissing createCTTableMissing() {
        return new CTTableMissing();
    }

    /**
     * Create an instance of {@link CTBreak }
     *
     */
    public CTBreak createCTBreak() {
        return new CTBreak();
    }

    /**
     * Create an instance of {@link CTWorksheetSource }
     *
     */
    public CTWorksheetSource createCTWorksheetSource() {
        return new CTWorksheetSource();
    }

    /**
     * Create an instance of {@link CTComment }
     *
     */
    public CTComment createCTComment() {
        return new CTComment();
    }

    /**
     * Create an instance of {@link CTInputCells }
     *
     */
    public CTInputCells createCTInputCells() {
        return new CTInputCells();
    }

    /**
     * Create an instance of {@link CTMapInfo }
     *
     */
    public CTMapInfo createCTMapInfo() {
        return new CTMapInfo();
    }

    /**
     * Create an instance of {@link CTQueryTableRefresh }
     *
     */
    public CTQueryTableRefresh createCTQueryTableRefresh() {
        return new CTQueryTableRefresh();
    }

    /**
     * Create an instance of {@link CTDataBinding }
     *
     */
    public CTDataBinding createCTDataBinding() {
        return new CTDataBinding();
    }

    /**
     * Create an instance of {@link CTRevisionHeader }
     *
     */
    public CTRevisionHeader createCTRevisionHeader() {
        return new CTRevisionHeader();
    }

    /**
     * Create an instance of {@link CTPrintOptions }
     *
     */
    public CTPrintOptions createCTPrintOptions() {
        return new CTPrintOptions();
    }

    /**
     * Create an instance of {@link CTMetadata }
     *
     */
    public CTMetadata createCTMetadata() {
        return new CTMetadata();
    }

    /**
     * Create an instance of {@link CTCalcChain }
     *
     */
    public CTCalcChain createCTCalcChain() {
        return new CTCalcChain();
    }

    /**
     * Create an instance of {@link CTParameters }
     *
     */
    public CTParameters createCTParameters() {
        return new CTParameters();
    }

    /**
     * Create an instance of {@link CTVolTopicRef }
     *
     */
    public CTVolTopicRef createCTVolTopicRef() {
        return new CTVolTopicRef();
    }

    /**
     * Create an instance of {@link CTRangeSet }
     *
     */
    public CTRangeSet createCTRangeSet() {
        return new CTRangeSet();
    }

    /**
     * Create an instance of {@link CTHyperlinks }
     *
     */
    public CTHyperlinks createCTHyperlinks() {
        return new CTHyperlinks();
    }

    /**
     * Create an instance of {@link CTOleSize }
     *
     */
    public CTOleSize createCTOleSize() {
        return new CTOleSize();
    }

    /**
     * Create an instance of {@link CTWorkbookProtection }
     *
     */
    public CTWorkbookProtection createCTWorkbookProtection() {
        return new CTWorkbookProtection();
    }

    /**
     * Create an instance of {@link CTMdxTuple }
     *
     */
    public CTMdxTuple createCTMdxTuple() {
        return new CTMdxTuple();
    }

    /**
     * Create an instance of {@link CTColHierarchiesUsage }
     *
     */
    public CTColHierarchiesUsage createCTColHierarchiesUsage() {
        return new CTColHierarchiesUsage();
    }

    /**
     * Create an instance of {@link CTOleObjects }
     *
     */
    public CTOleObjects createCTOleObjects() {
        return new CTOleObjects();
    }

    /**
     * Create an instance of {@link CTDrawing }
     *
     */
    public CTDrawing createCTDrawing() {
        return new CTDrawing();
    }

    /**
     * Create an instance of {@link CTSets }
     *
     */
    public CTSets createCTSets() {
        return new CTSets();
    }

    /**
     * Create an instance of {@link CTTupleCache }
     *
     */
    public CTTupleCache createCTTupleCache() {
        return new CTTupleCache();
    }

    /**
     * Create an instance of {@link CTCellStyle }
     *
     */
    public CTCellStyle createCTCellStyle() {
        return new CTCellStyle();
    }

    /**
     * Create an instance of {@link CTIconFilter }
     *
     */
    public CTIconFilter createCTIconFilter() {
        return new CTIconFilter();
    }

    /**
     * Create an instance of {@link CTExternalSheetName }
     *
     */
    public CTExternalSheetName createCTExternalSheetName() {
        return new CTExternalSheetName();
    }

    /**
     * Create an instance of {@link CTSharedUser }
     *
     */
    public CTSharedUser createCTSharedUser() {
        return new CTSharedUser();
    }

    /**
     * Create an instance of {@link CTExternalLink }
     *
     */
    public CTExternalLink createCTExternalLink() {
        return new CTExternalLink();
    }

    /**
     * Create an instance of {@link CTFutureMetadata }
     *
     */
    public CTFutureMetadata createCTFutureMetadata() {
        return new CTFutureMetadata();
    }

    /**
     * Create an instance of {@link CTBookView }
     *
     */
    public CTBookView createCTBookView() {
        return new CTBookView();
    }

    /**
     * Create an instance of {@link CTChartFormat }
     *
     */
    public CTChartFormat createCTChartFormat() {
        return new CTChartFormat();
    }

    /**
     * Create an instance of {@link CTRevisionHeaders }
     *
     */
    public CTRevisionHeaders createCTRevisionHeaders() {
        return new CTRevisionHeaders();
    }

    /**
     * Create an instance of {@link CTMemberProperty }
     *
     */
    public CTMemberProperty createCTMemberProperty() {
        return new CTMemberProperty();
    }

    /**
     * Create an instance of {@link CTCustomProperties }
     *
     */
    public CTCustomProperties createCTCustomProperties() {
        return new CTCustomProperties();
    }

    /**
     * Create an instance of {@link CTStylesheet }
     *
     */
    public CTStylesheet createCTStylesheet() {
        return new CTStylesheet();
    }

    /**
     * Create an instance of {@link CTMeasureGroups }
     *
     */
    public CTMeasureGroups createCTMeasureGroups() {
        return new CTMeasureGroups();
    }

    /**
     * Create an instance of {@link DefinedNames }
     *
     */
    public DefinedNames createDefinedNames() {
        return new DefinedNames();
    }

    /**
     * Create an instance of {@link CTExternalSheetDataSet }
     *
     */
    public CTExternalSheetDataSet createCTExternalSheetDataSet() {
        return new CTExternalSheetDataSet();
    }

    /**
     * Create an instance of {@link CTDynamicFilter }
     *
     */
    public CTDynamicFilter createCTDynamicFilter() {
        return new CTDynamicFilter();
    }

    /**
     * Create an instance of {@link CTRElt }
     *
     */
    public CTRElt createCTRElt() {
        return new CTRElt();
    }

    /**
     * Create an instance of {@link CTBorders }
     *
     */
    public CTBorders createCTBorders() {
        return new CTBorders();
    }

    /**
     * Create an instance of {@link Cell }
     *
     */
    public Cell createCell() {
        return new Cell();
    }

    /**
     * Create an instance of {@link CTQueryTableDeletedFields }
     *
     */
    public CTQueryTableDeletedFields createCTQueryTableDeletedFields() {
        return new CTQueryTableDeletedFields();
    }

    /**
     * Create an instance of {@link CTColors }
     *
     */
    public CTColors createCTColors() {
        return new CTColors();
    }

    /**
     * Create an instance of {@link CTMergeCell }
     *
     */
    public CTMergeCell createCTMergeCell() {
        return new CTMergeCell();
    }

    /**
     * Create an instance of {@link CTGroupMembers }
     *
     */
    public CTGroupMembers createCTGroupMembers() {
        return new CTGroupMembers();
    }

    /**
     * Create an instance of {@link SheetViews }
     *
     */
    public SheetViews createSheetViews() {
        return new SheetViews();
    }

    /**
     * Create an instance of {@link CTNumber }
     *
     */
    public CTNumber createCTNumber() {
        return new CTNumber();
    }

    /**
     * Create an instance of {@link CTChartsheetViews }
     *
     */
    public CTChartsheetViews createCTChartsheetViews() {
        return new CTChartsheetViews();
    }

    /**
     * Create an instance of {@link CTCellAlignment }
     *
     */
    public CTCellAlignment createCTCellAlignment() {
        return new CTCellAlignment();
    }

    /**
     * Create an instance of {@link CTMetadataBlock }
     *
     */
    public CTMetadataBlock createCTMetadataBlock() {
        return new CTMetadataBlock();
    }

    /**
     * Create an instance of {@link CTIgnoredErrors }
     *
     */
    public CTIgnoredErrors createCTIgnoredErrors() {
        return new CTIgnoredErrors();
    }

    /**
     * Create an instance of {@link CTPageBreak }
     *
     */
    public CTPageBreak createCTPageBreak() {
        return new CTPageBreak();
    }

    /**
     * Create an instance of {@link CTPivotHierarchies }
     *
     */
    public CTPivotHierarchies createCTPivotHierarchies() {
        return new CTPivotHierarchies();
    }

    /**
     * Create an instance of {@link CTSharedItems }
     *
     */
    public CTSharedItems createCTSharedItems() {
        return new CTSharedItems();
    }

    /**
     * Create an instance of {@link Worksheet }
     *
     */
    public Worksheet createWorksheet() {
        return new Worksheet();
    }

    /**
     * Create an instance of {@link CTTableStyleElement }
     *
     */
    public CTTableStyleElement createCTTableStyleElement() {
        return new CTTableStyleElement();
    }

    /**
     * Create an instance of {@link CTChartFormats }
     *
     */
    public CTChartFormats createCTChartFormats() {
        return new CTChartFormats();
    }

    /**
     * Create an instance of {@link CTError }
     *
     */
    public CTError createCTError() {
        return new CTError();
    }

    /**
     * Create an instance of {@link CTPivotAreaReferences }
     *
     */
    public CTPivotAreaReferences createCTPivotAreaReferences() {
        return new CTPivotAreaReferences();
    }

    /**
     * Create an instance of {@link CTWebPublishItems }
     *
     */
    public CTWebPublishItems createCTWebPublishItems() {
        return new CTWebPublishItems();
    }

    /**
     * Create an instance of {@link CTTableStyles }
     *
     */
    public CTTableStyles createCTTableStyles() {
        return new CTTableStyles();
    }

    /**
     * Create an instance of {@link CTExternalDefinedNames }
     *
     */
    public CTExternalDefinedNames createCTExternalDefinedNames() {
        return new CTExternalDefinedNames();
    }

    /**
     * Create an instance of {@link CTTuples }
     *
     */
    public CTTuples createCTTuples() {
        return new CTTuples();
    }

    /**
     * Create an instance of {@link CTAuthors }
     *
     */
    public CTAuthors createCTAuthors() {
        return new CTAuthors();
    }

    /**
     * Create an instance of {@link CTDataField }
     *
     */
    public CTDataField createCTDataField() {
        return new CTDataField();
    }

    /**
     * Create an instance of {@link CTRangeSets }
     *
     */
    public CTRangeSets createCTRangeSets() {
        return new CTRangeSets();
    }

    /**
     * Create an instance of {@link CTTableStyleInfo }
     *
     */
    public CTTableStyleInfo createCTTableStyleInfo() {
        return new CTTableStyleInfo();
    }

    /**
     * Create an instance of {@link CTCalcCell }
     *
     */
    public CTCalcCell createCTCalcCell() {
        return new CTCalcCell();
    }

    /**
     * Create an instance of {@link CTFieldUsage }
     *
     */
    public CTFieldUsage createCTFieldUsage() {
        return new CTFieldUsage();
    }

    /**
     * Create an instance of {@link CTFilterColumn }
     *
     */
    public CTFilterColumn createCTFilterColumn() {
        return new CTFilterColumn();
    }

    /**
     * Create an instance of {@link CTTableColumn }
     *
     */
    public CTTableColumn createCTTableColumn() {
        return new CTTableColumn();
    }

    /**
     * Create an instance of {@link CTPivotCaches }
     *
     */
    public CTPivotCaches createCTPivotCaches() {
        return new CTPivotCaches();
    }

    /**
     * Create an instance of {@link CTDateGroupItem }
     *
     */
    public CTDateGroupItem createCTDateGroupItem() {
        return new CTDateGroupItem();
    }

    /**
     * Create an instance of {@link CTMetadataStringIndex }
     *
     */
    public CTMetadataStringIndex createCTMetadataStringIndex() {
        return new CTMetadataStringIndex();
    }

    /**
     * Create an instance of {@link CTSmartTagType }
     *
     */
    public CTSmartTagType createCTSmartTagType() {
        return new CTSmartTagType();
    }

    /**
     * Create an instance of {@link CTSortCondition }
     *
     */
    public CTSortCondition createCTSortCondition() {
        return new CTSortCondition();
    }

    /**
     * Create an instance of {@link CTRowFields }
     *
     */
    public CTRowFields createCTRowFields() {
        return new CTRowFields();
    }

    /**
     * Create an instance of {@link CTDbPr }
     *
     */
    public CTDbPr createCTDbPr() {
        return new CTDbPr();
    }

    /**
     * Create an instance of {@link CTBoolean }
     *
     */
    public CTBoolean createCTBoolean() {
        return new CTBoolean();
    }

    /**
     * Create an instance of {@link CTDiscretePr }
     *
     */
    public CTDiscretePr createCTDiscretePr() {
        return new CTDiscretePr();
    }

    /**
     * Create an instance of {@link CTMemberProperties }
     *
     */
    public CTMemberProperties createCTMemberProperties() {
        return new CTMemberProperties();
    }

    /**
     * Create an instance of {@link CTVolMain }
     *
     */
    public CTVolMain createCTVolMain() {
        return new CTVolMain();
    }

    /**
     * Create an instance of {@link CTCellWatch }
     *
     */
    public CTCellWatch createCTCellWatch() {
        return new CTCellWatch();
    }

    /**
     * Create an instance of {@link CTMergeCells }
     *
     */
    public CTMergeCells createCTMergeCells() {
        return new CTMergeCells();
    }

    /**
     * Create an instance of {@link CTFontScheme }
     *
     */
    public CTFontScheme createCTFontScheme() {
        return new CTFontScheme();
    }

    /**
     * Create an instance of {@link CTRevisionSheetRename }
     *
     */
    public CTRevisionSheetRename createCTRevisionSheetRename() {
        return new CTRevisionSheetRename();
    }

    /**
     * Create an instance of {@link CTRevisionMove }
     *
     */
    public CTRevisionMove createCTRevisionMove() {
        return new CTRevisionMove();
    }

    /**
     * Create an instance of {@link CTCellSmartTag }
     *
     */
    public CTCellSmartTag createCTCellSmartTag() {
        return new CTCellSmartTag();
    }

    /**
     * Create an instance of {@link SheetData }
     *
     */
    public SheetData createSheetData() {
        return new SheetData();
    }

    /**
     * Create an instance of {@link CTTableParts }
     *
     */
    public CTTableParts createCTTableParts() {
        return new CTTableParts();
    }

    /**
     * Create an instance of {@link CTDateTime }
     *
     */
    public CTDateTime createCTDateTime() {
        return new CTDateTime();
    }

    /**
     * Create an instance of {@link CTExternalCell }
     *
     */
    public CTExternalCell createCTExternalCell() {
        return new CTExternalCell();
    }

    /**
     * Create an instance of {@link CTFieldsUsage }
     *
     */
    public CTFieldsUsage createCTFieldsUsage() {
        return new CTFieldsUsage();
    }

    /**
     * Create an instance of {@link CTPivotArea }
     *
     */
    public CTPivotArea createCTPivotArea() {
        return new CTPivotArea();
    }

    /**
     * Create an instance of {@link CTLevelGroup }
     *
     */
    public CTLevelGroup createCTLevelGroup() {
        return new CTLevelGroup();
    }

    /**
     * Create an instance of {@link CTConnections }
     *
     */
    public CTConnections createCTConnections() {
        return new CTConnections();
    }

    /**
     * Create an instance of {@link CTQueryTableField }
     *
     */
    public CTQueryTableField createCTQueryTableField() {
        return new CTQueryTableField();
    }

    /**
     * Create an instance of {@link CTMeasureDimensionMap }
     *
     */
    public CTMeasureDimensionMap createCTMeasureDimensionMap() {
        return new CTMeasureDimensionMap();
    }

    /**
     * Create an instance of {@link CTPageMargins }
     *
     */
    public CTPageMargins createCTPageMargins() {
        return new CTPageMargins();
    }

    /**
     * Create an instance of {@link CTI }
     *
     */
    public CTI createCTI() {
        return new CTI();
    }

    /**
     * Create an instance of {@link CTReviewedRevisions }
     *
     */
    public CTReviewedRevisions createCTReviewedRevisions() {
        return new CTReviewedRevisions();
    }

    /**
     * Create an instance of {@link CTFonts }
     *
     */
    public CTFonts createCTFonts() {
        return new CTFonts();
    }

    /**
     * Create an instance of {@link CTLocation }
     *
     */
    public CTLocation createCTLocation() {
        return new CTLocation();
    }

    /**
     * Create an instance of {@link CTCustomSheetView }
     *
     */
    public CTCustomSheetView createCTCustomSheetView() {
        return new CTCustomSheetView();
    }

    /**
     * Create an instance of {@link CTTop10 }
     *
     */
    public CTTop10 createCTTop10() {
        return new CTTop10();
    }

    /**
     * Create an instance of {@link CTSchema }
     *
     */
    public CTSchema createCTSchema() {
        return new CTSchema();
    }

    /**
     * Create an instance of {@link CTMetadataTypes }
     *
     */
    public CTMetadataTypes createCTMetadataTypes() {
        return new CTMetadataTypes();
    }

    /**
     * Create an instance of {@link CTMeasureDimensionMaps }
     *
     */
    public CTMeasureDimensionMaps createCTMeasureDimensionMaps() {
        return new CTMeasureDimensionMaps();
    }

    /**
     * Create an instance of {@link CTUsers }
     *
     */
    public CTUsers createCTUsers() {
        return new CTUsers();
    }

    /**
     * Create an instance of {@link CTTextPr }
     *
     */
    public CTTextPr createCTTextPr() {
        return new CTTextPr();
    }

    /**
     * Create an instance of {@link CTServerFormat }
     *
     */
    public CTServerFormat createCTServerFormat() {
        return new CTServerFormat();
    }

    /**
     * Create an instance of {@link CTPageSetUpPr }
     *
     */
    public CTPageSetUpPr createCTPageSetUpPr() {
        return new CTPageSetUpPr();
    }

    /**
     * Create an instance of {@link CTDataValidations }
     *
     */
    public CTDataValidations createCTDataValidations() {
        return new CTDataValidations();
    }

    /**
     * Create an instance of {@link CTSingleXmlCells }
     *
     */
    public CTSingleXmlCells createCTSingleXmlCells() {
        return new CTSingleXmlCells();
    }

    /**
     * Create an instance of {@link CTPCDKPI }
     *
     */
    public CTPCDKPI createCTPCDKPI() {
        return new CTPCDKPI();
    }

    /**
     * Create an instance of {@link CTMissing }
     *
     */
    public CTMissing createCTMissing() {
        return new CTMissing();
    }

    /**
     * Create an instance of {@link CTSheetDimension }
     *
     */
    public CTSheetDimension createCTSheetDimension() {
        return new CTSheetDimension();
    }

    /**
     * Create an instance of {@link CTQuery }
     *
     */
    public CTQuery createCTQuery() {
        return new CTQuery();
    }

    /**
     * Create an instance of {@link CTFieldGroup }
     *
     */
    public CTFieldGroup createCTFieldGroup() {
        return new CTFieldGroup();
    }

    /**
     * Create an instance of {@link CTDdeLink }
     *
     */
    public CTDdeLink createCTDdeLink() {
        return new CTDdeLink();
    }

    /**
     * Create an instance of {@link CTDdeItems }
     *
     */
    public CTDdeItems createCTDdeItems() {
        return new CTDdeItems();
    }

    /**
     * Create an instance of {@link Sheet }
     *
     */
    public Sheet createSheet() {
        return new Sheet();
    }

    /**
     * Create an instance of {@link CTFunctionGroups }
     *
     */
    public CTFunctionGroups createCTFunctionGroups() {
        return new CTFunctionGroups();
    }

    /**
     * Create an instance of {@link CTPageItem }
     *
     */
    public CTPageItem createCTPageItem() {
        return new CTPageItem();
    }

    /**
     * Create an instance of {@link CTGroupLevels }
     *
     */
    public CTGroupLevels createCTGroupLevels() {
        return new CTGroupLevels();
    }

    /**
     * Create an instance of {@link CTLegacyDrawing }
     *
     */
    public CTLegacyDrawing createCTLegacyDrawing() {
        return new CTLegacyDrawing();
    }

    /**
     * Create an instance of {@link CTSst }
     *
     */
    public CTSst createCTSst() {
        return new CTSst();
    }

    /**
     * Create an instance of {@link CTExternalReference }
     *
     */
    public CTExternalReference createCTExternalReference() {
        return new CTExternalReference();
    }

    /**
     * Create an instance of {@link CTPageFields }
     *
     */
    public CTPageFields createCTPageFields() {
        return new CTPageFields();
    }

    /**
     * Create an instance of {@link CTReviewed }
     *
     */
    public CTReviewed createCTReviewed() {
        return new CTReviewed();
    }

    /**
     * Create an instance of {@link Dialogsheet }
     *
     */
    public Dialogsheet createDialogsheet() {
        return new Dialogsheet();
    }

    /**
     * Create an instance of {@link CTExtension }
     *
     */
    public CTExtension createCTExtension() {
        return new CTExtension();
    }

    /**
     * Create an instance of {@link CTOutlinePr }
     *
     */
    public CTOutlinePr createCTOutlinePr() {
        return new CTOutlinePr();
    }

    /**
     * Create an instance of {@link CTConditionalFormat }
     *
     */
    public CTConditionalFormat createCTConditionalFormat() {
        return new CTConditionalFormat();
    }

    /**
     * Create an instance of {@link CTUnderlineProperty }
     *
     */
    public CTUnderlineProperty createCTUnderlineProperty() {
        return new CTUnderlineProperty();
    }

    /**
     * Create an instance of {@link CTPhoneticRun }
     *
     */
    public CTPhoneticRun createCTPhoneticRun() {
        return new CTPhoneticRun();
    }

    /**
     * Create an instance of {@link CTDataConsolidate }
     *
     */
    public CTDataConsolidate createCTDataConsolidate() {
        return new CTDataConsolidate();
    }

    /**
     * Create an instance of {@link CTPivotHierarchy }
     *
     */
    public CTPivotHierarchy createCTPivotHierarchy() {
        return new CTPivotHierarchy();
    }

    /**
     * Create an instance of {@link CTMdxMetadata }
     *
     */
    public CTMdxMetadata createCTMdxMetadata() {
        return new CTMdxMetadata();
    }

    /**
     * Create an instance of {@link CTHyperlink }
     *
     */
    public CTHyperlink createCTHyperlink() {
        return new CTHyperlink();
    }

    /**
     * Create an instance of {@link CTParameter }
     *
     */
    public CTParameter createCTParameter() {
        return new CTParameter();
    }

    /**
     * Create an instance of {@link CTCacheField }
     *
     */
    public CTCacheField createCTCacheField() {
        return new CTCacheField();
    }

    /**
     * Create an instance of {@link SheetView }
     *
     */
    public SheetView createSheetView() {
        return new SheetView();
    }

    /**
     * Create an instance of {@link CTUndoInfo }
     *
     */
    public CTUndoInfo createCTUndoInfo() {
        return new CTUndoInfo();
    }

    /**
     * Create an instance of {@link CTMdxMemeberProp }
     *
     */
    public CTMdxMemeberProp createCTMdxMemeberProp() {
        return new CTMdxMemeberProp();
    }

    /**
     * Create an instance of {@link CTSheetCalcPr }
     *
     */
    public CTSheetCalcPr createCTSheetCalcPr() {
        return new CTSheetCalcPr();
    }

    /**
     * Create an instance of {@link CTVolType }
     *
     */
    public CTVolType createCTVolType() {
        return new CTVolType();
    }

    /**
     * Create an instance of {@link CTCellFormula }
     *
     */
    public CTCellFormula createCTCellFormula() {
        return new CTCellFormula();
    }

    /**
     * Create an instance of {@link CTColorScale }
     *
     */
    public CTColorScale createCTColorScale() {
        return new CTColorScale();
    }

    /**
     * Create an instance of {@link CTPivotDimension }
     *
     */
    public CTPivotDimension createCTPivotDimension() {
        return new CTPivotDimension();
    }

    /**
     * Create an instance of {@link CTRowItems }
     *
     */
    public CTRowItems createCTRowItems() {
        return new CTRowItems();
    }

    /**
     * Create an instance of {@link CTExternalReferences }
     *
     */
    public CTExternalReferences createCTExternalReferences() {
        return new CTExternalReferences();
    }

    /**
     * Create an instance of {@link CTRevisions }
     *
     */
    public CTRevisions createCTRevisions() {
        return new CTRevisions();
    }

    /**
     * Create an instance of {@link CTExternalDefinedName }
     *
     */
    public CTExternalDefinedName createCTExternalDefinedName() {
        return new CTExternalDefinedName();
    }

    /**
     * Create an instance of {@link CTCellSmartTags }
     *
     */
    public CTCellSmartTags createCTCellSmartTags() {
        return new CTCellSmartTags();
    }

    /**
     * Create an instance of {@link CTDataValidation }
     *
     */
    public CTDataValidation createCTDataValidation() {
        return new CTDataValidation();
    }

    /**
     * Create an instance of {@link CTMdx }
     *
     */
    public CTMdx createCTMdx() {
        return new CTMdx();
    }

    /**
     * Create an instance of {@link CTGroups }
     *
     */
    public CTGroups createCTGroups() {
        return new CTGroups();
    }

    /**
     * Create an instance of {@link CTFileSharing }
     *
     */
    public CTFileSharing createCTFileSharing() {
        return new CTFileSharing();
    }

    /**
     * Create an instance of {@link CTDxf }
     *
     */
    public CTDxf createCTDxf() {
        return new CTDxf();
    }

    /**
     * Create an instance of {@link CTHeaderFooter }
     *
     */
    public CTHeaderFooter createCTHeaderFooter() {
        return new CTHeaderFooter();
    }

    /**
     * Create an instance of {@link CTMetadataType }
     *
     */
    public CTMetadataType createCTMetadataType() {
        return new CTMetadataType();
    }

    /**
     * Create an instance of {@link CTWebPublishing }
     *
     */
    public CTWebPublishing createCTWebPublishing() {
        return new CTWebPublishing();
    }

    /**
     * Create an instance of {@link CTOleItem }
     *
     */
    public CTOleItem createCTOleItem() {
        return new CTOleItem();
    }

    /**
     * Create an instance of {@link CTMetadataStrings }
     *
     */
    public CTMetadataStrings createCTMetadataStrings() {
        return new CTMetadataStrings();
    }

    /**
     * Create an instance of {@link CTTableColumns }
     *
     */
    public CTTableColumns createCTTableColumns() {
        return new CTTableColumns();
    }

    /**
     * Create an instance of {@link CTPCDSDTCEntries }
     *
     */
    public CTPCDSDTCEntries createCTPCDSDTCEntries() {
        return new CTPCDSDTCEntries();
    }

    /**
     * Create an instance of {@link CTIntProperty }
     *
     */
    public CTIntProperty createCTIntProperty() {
        return new CTIntProperty();
    }

    /**
     * Create an instance of {@link CTFutureMetadataBlock }
     *
     */
    public CTFutureMetadataBlock createCTFutureMetadataBlock() {
        return new CTFutureMetadataBlock();
    }

    /**
     * Create an instance of {@link CTPivotAreas }
     *
     */
    public CTPivotAreas createCTPivotAreas() {
        return new CTPivotAreas();
    }

    /**
     * Create an instance of {@link CTSet }
     *
     */
    public CTSet createCTSet() {
        return new CTSet();
    }

    /**
     * Create an instance of {@link CTChartsheetPr }
     *
     */
    public CTChartsheetPr createCTChartsheetPr() {
        return new CTChartsheetPr();
    }

    /**
     * Create an instance of {@link CTCustomProperty }
     *
     */
    public CTCustomProperty createCTCustomProperty() {
        return new CTCustomProperty();
    }

    /**
     * Create an instance of {@link CTRgbColor }
     *
     */
    public CTRgbColor createCTRgbColor() {
        return new CTRgbColor();
    }

    /**
     * Create an instance of {@link CTSheetFormatPr }
     *
     */
    public CTSheetFormatPr createCTSheetFormatPr() {
        return new CTSheetFormatPr();
    }

    /**
     * Create an instance of {@link CTNumFmts }
     *
     */
    public CTNumFmts createCTNumFmts() {
        return new CTNumFmts();
    }

    /**
     * Create an instance of {@link CTControls }
     *
     */
    public CTControls createCTControls() {
        return new CTControls();
    }

    /**
     * Create an instance of {@link CTColFields }
     *
     */
    public CTColFields createCTColFields() {
        return new CTColFields();
    }

    /**
     * Create an instance of {@link CTTablePart }
     *
     */
    public CTTablePart createCTTablePart() {
        return new CTTablePart();
    }

    /**
     * Create an instance of {@link CTOleItems }
     *
     */
    public CTOleItems createCTOleItems() {
        return new CTOleItems();
    }

    /**
     * Create an instance of {@link CTDeletedField }
     *
     */
    public CTDeletedField createCTDeletedField() {
        return new CTDeletedField();
    }

    /**
     * Create an instance of {@link CTBooleanProperty }
     *
     */
    public CTBooleanProperty createCTBooleanProperty() {
        return new CTBooleanProperty();
    }

    /**
     * Create an instance of {@link CTRevisionFormatting }
     *
     */
    public CTRevisionFormatting createCTRevisionFormatting() {
        return new CTRevisionFormatting();
    }

    /**
     * Create an instance of {@link CTString }
     *
     */
    public CTString createCTString() {
        return new CTString();
    }

    /**
     * Create an instance of {@link CTRevisionRowColumn }
     *
     */
    public CTRevisionRowColumn createCTRevisionRowColumn() {
        return new CTRevisionRowColumn();
    }

    /**
     * Create an instance of {@link CTCellStyles }
     *
     */
    public CTCellStyles createCTCellStyles() {
        return new CTCellStyles();
    }

    /**
     * Create an instance of {@link CTVolTopic }
     *
     */
    public CTVolTopic createCTVolTopic() {
        return new CTVolTopic();
    }

    /**
     * Create an instance of {@link CTIgnoredError }
     *
     */
    public CTIgnoredError createCTIgnoredError() {
        return new CTIgnoredError();
    }

    /**
     * Create an instance of {@link CTXStringElement }
     *
     */
    public CTXStringElement createCTXStringElement() {
        return new CTXStringElement();
    }

    /**
     * Create an instance of {@link CTSmartTags }
     *
     */
    public CTSmartTags createCTSmartTags() {
        return new CTSmartTags();
    }

    /**
     * Create an instance of {@link CTPCDSCPage }
     *
     */
    public CTPCDSCPage createCTPCDSCPage() {
        return new CTPCDSCPage();
    }

    /**
     * Create an instance of {@link CTDefinedName }
     *
     */
    public CTDefinedName createCTDefinedName() {
        return new CTDefinedName();
    }

    /**
     * Create an instance of {@link CTGroupMember }
     *
     */
    public CTGroupMember createCTGroupMember() {
        return new CTGroupMember();
    }

    /**
     * Create an instance of {@link Macrosheet }
     *
     */
    public Macrosheet createMacrosheet() {
        return new Macrosheet();
    }

    /**
     * Create an instance of {@link CTProtectedRanges }
     *
     */
    public CTProtectedRanges createCTProtectedRanges() {
        return new CTProtectedRanges();
    }

    /**
     * Create an instance of {@link CTPivotSelection }
     *
     */
    public CTPivotSelection createCTPivotSelection() {
        return new CTPivotSelection();
    }

    /**
     * Create an instance of {@link CTRevisionDefinedName }
     *
     */
    public CTRevisionDefinedName createCTRevisionDefinedName() {
        return new CTRevisionDefinedName();
    }

    /**
     * Create an instance of {@link CTXf }
     *
     */
    public CTXf createCTXf() {
        return new CTXf();
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTXf }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "xf")
    public JAXBElement<CTXf> createCTXf(CTXf value) {
        return new JAXBElement<CTXf>(_CTXf_QNAME, CTXf.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTFill }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "fill")
    public JAXBElement<CTFill> createCTFill(CTFill value) {
        return new JAXBElement<CTFill>(_CTFill_QNAME, CTFill.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTBorder }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "border")
    public JAXBElement<CTBorder> createCTBorder(CTBorder value) {
        return new JAXBElement<CTBorder>(_CTBorder_QNAME, CTBorder.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTConnections }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "connections")
    public JAXBElement<CTConnections> createConnections(CTConnections value) {
        return new JAXBElement<CTConnections>(_Connections_QNAME, CTConnections.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTMetadata }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "metadata")
    public JAXBElement<CTMetadata> createMetadata(CTMetadata value) {
        return new JAXBElement<CTMetadata>(_Metadata_QNAME, CTMetadata.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTExternalLink }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "externalLink")
    public JAXBElement<CTExternalLink> createExternalLink(CTExternalLink value) {
        return new JAXBElement<CTExternalLink>(_ExternalLink_QNAME, CTExternalLink.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTComments }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "comments")
    public JAXBElement<CTComments> createComments(CTComments value) {
        return new JAXBElement<CTComments>(_Comments_QNAME, CTComments.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTSingleXmlCells }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "singleXmlCells")
    public JAXBElement<CTSingleXmlCells> createSingleXmlCells(CTSingleXmlCells value) {
        return new JAXBElement<CTSingleXmlCells>(_SingleXmlCells_QNAME, CTSingleXmlCells.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTRevisions }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "revisions")
    public JAXBElement<CTRevisions> createRevisions(CTRevisions value) {
        return new JAXBElement<CTRevisions>(_Revisions_QNAME, CTRevisions.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTSst }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "sst")
    public JAXBElement<CTSst> createSst(CTSst value) {
        return new JAXBElement<CTSst>(_Sst_QNAME, CTSst.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTStylesheet }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "styleSheet")
    public JAXBElement<CTStylesheet> createStyleSheet(CTStylesheet value) {
        return new JAXBElement<CTStylesheet>(_StyleSheet_QNAME, CTStylesheet.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTChartsheet }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "chartsheet")
    public JAXBElement<CTChartsheet> createChartsheet(CTChartsheet value) {
        return new JAXBElement<CTChartsheet>(_Chartsheet_QNAME, CTChartsheet.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link Workbook }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "workbook")
    public JAXBElement<Workbook> createWorkbook(Workbook value) {
        return new JAXBElement<Workbook>(_Workbook_QNAME, Workbook.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTTable }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "table")
    public JAXBElement<CTTable> createTable(CTTable value) {
        return new JAXBElement<CTTable>(_Table_QNAME, CTTable.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPivotCacheRecords }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "pivotCacheRecords")
    public JAXBElement<CTPivotCacheRecords> createPivotCacheRecords(CTPivotCacheRecords value) {
        return new JAXBElement<CTPivotCacheRecords>(_PivotCacheRecords_QNAME, CTPivotCacheRecords.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link Worksheet }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "worksheet")
    public JAXBElement<Worksheet> createWorksheet(Worksheet value) {
        return new JAXBElement<Worksheet>(_Worksheet_QNAME, Worksheet.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link Dialogsheet }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "dialogsheet")
    public JAXBElement<Dialogsheet> createDialogsheet(Dialogsheet value) {
        return new JAXBElement<Dialogsheet>(_Dialogsheet_QNAME, Dialogsheet.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPivotCacheDefinition }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "pivotCacheDefinition")
    public JAXBElement<CTPivotCacheDefinition> createPivotCacheDefinition(CTPivotCacheDefinition value) {
        return new JAXBElement<CTPivotCacheDefinition>(_PivotCacheDefinition_QNAME, CTPivotCacheDefinition.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTVolTypes }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "volTypes")
    public JAXBElement<CTVolTypes> createVolTypes(CTVolTypes value) {
        return new JAXBElement<CTVolTypes>(_VolTypes_QNAME, CTVolTypes.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTMapInfo }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "MapInfo")
    public JAXBElement<CTMapInfo> createMapInfo(CTMapInfo value) {
        return new JAXBElement<CTMapInfo>(_MapInfo_QNAME, CTMapInfo.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTQueryTable }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "queryTable")
    public JAXBElement<CTQueryTable> createQueryTable(CTQueryTable value) {
        return new JAXBElement<CTQueryTable>(_QueryTable_QNAME, CTQueryTable.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTUsers }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "users")
    public JAXBElement<CTUsers> createUsers(CTUsers value) {
        return new JAXBElement<CTUsers>(_Users_QNAME, CTUsers.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTCalcChain }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "calcChain")
    public JAXBElement<CTCalcChain> createCalcChain(CTCalcChain value) {
        return new JAXBElement<CTCalcChain>(_CalcChain_QNAME, CTCalcChain.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTRevisionHeaders }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "headers")
    public JAXBElement<CTRevisionHeaders> createHeaders(CTRevisionHeaders value) {
        return new JAXBElement<CTRevisionHeaders>(_Headers_QNAME, CTRevisionHeaders.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPivotTableDefinition }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "pivotTableDefinition")
    public JAXBElement<CTPivotTableDefinition> createPivotTableDefinition(CTPivotTableDefinition value) {
        return new JAXBElement<CTPivotTableDefinition>(_PivotTableDefinition_QNAME, CTPivotTableDefinition.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTFont }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "font")
    public JAXBElement<CTFont> createCTFont(CTFont value) {
        return new JAXBElement<CTFont>(_CTFont_QNAME, CTFont.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTFontSize }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "sz", scope = CTFont.class)
    public JAXBElement<CTFontSize> createCTFontSz(CTFontSize value) {
        return new JAXBElement<CTFontSize>(_CTFontSz_QNAME, CTFontSize.class, CTFont.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTBooleanProperty }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "condense", scope = CTFont.class)
    public JAXBElement<CTBooleanProperty> createCTFontCondense(CTBooleanProperty value) {
        return new JAXBElement<CTBooleanProperty>(_CTFontCondense_QNAME, CTBooleanProperty.class, CTFont.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTBooleanProperty }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "strike", scope = CTFont.class)
    public JAXBElement<CTBooleanProperty> createCTFontStrike(CTBooleanProperty value) {
        return new JAXBElement<CTBooleanProperty>(_CTFontStrike_QNAME, CTBooleanProperty.class, CTFont.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTUnderlineProperty }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "u", scope = CTFont.class)
    public JAXBElement<CTUnderlineProperty> createCTFontU(CTUnderlineProperty value) {
        return new JAXBElement<CTUnderlineProperty>(_CTFontU_QNAME, CTUnderlineProperty.class, CTFont.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTVerticalAlignFontProperty }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "vertAlign", scope = CTFont.class)
    public JAXBElement<CTVerticalAlignFontProperty> createCTFontVertAlign(CTVerticalAlignFontProperty value) {
        return new JAXBElement<CTVerticalAlignFontProperty>(_CTFontVertAlign_QNAME, CTVerticalAlignFontProperty.class, CTFont.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTFontName }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "name", scope = CTFont.class)
    public JAXBElement<CTFontName> createCTFontName(CTFontName value) {
        return new JAXBElement<CTFontName>(_CTFontName_QNAME, CTFontName.class, CTFont.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTBooleanProperty }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "shadow", scope = CTFont.class)
    public JAXBElement<CTBooleanProperty> createCTFontShadow(CTBooleanProperty value) {
        return new JAXBElement<CTBooleanProperty>(_CTFontShadow_QNAME, CTBooleanProperty.class, CTFont.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTIntProperty }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "family", scope = CTFont.class)
    public JAXBElement<CTIntProperty> createCTFontFamily(CTIntProperty value) {
        return new JAXBElement<CTIntProperty>(_CTFontFamily_QNAME, CTIntProperty.class, CTFont.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTColor }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "color", scope = CTFont.class)
    public JAXBElement<CTColor> createCTFontColor(CTColor value) {
        return new JAXBElement<CTColor>(_CTFontColor_QNAME, CTColor.class, CTFont.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTFontScheme }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "scheme", scope = CTFont.class)
    public JAXBElement<CTFontScheme> createCTFontScheme(CTFontScheme value) {
        return new JAXBElement<CTFontScheme>(_CTFontScheme_QNAME, CTFontScheme.class, CTFont.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTIntProperty }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "charset", scope = CTFont.class)
    public JAXBElement<CTIntProperty> createCTFontCharset(CTIntProperty value) {
        return new JAXBElement<CTIntProperty>(_CTFontCharset_QNAME, CTIntProperty.class, CTFont.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTBooleanProperty }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "i", scope = CTFont.class)
    public JAXBElement<CTBooleanProperty> createCTFontI(CTBooleanProperty value) {
        return new JAXBElement<CTBooleanProperty>(_CTFontI_QNAME, CTBooleanProperty.class, CTFont.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTBooleanProperty }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "outline", scope = CTFont.class)
    public JAXBElement<CTBooleanProperty> createCTFontOutline(CTBooleanProperty value) {
        return new JAXBElement<CTBooleanProperty>(_CTFontOutline_QNAME, CTBooleanProperty.class, CTFont.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTBooleanProperty }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "extend", scope = CTFont.class)
    public JAXBElement<CTBooleanProperty> createCTFontExtend(CTBooleanProperty value) {
        return new JAXBElement<CTBooleanProperty>(_CTFontExtend_QNAME, CTBooleanProperty.class, CTFont.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTBooleanProperty }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "b", scope = CTFont.class)
    public JAXBElement<CTBooleanProperty> createCTFontB(CTBooleanProperty value) {
        return new JAXBElement<CTBooleanProperty>(_CTFontB_QNAME, CTBooleanProperty.class, CTFont.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTBooleanProperty }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "condense", scope = CTRPrElt.class)
    public JAXBElement<CTBooleanProperty> createCTRPrEltCondense(CTBooleanProperty value) {
        return new JAXBElement<CTBooleanProperty>(_CTFontCondense_QNAME, CTBooleanProperty.class, CTRPrElt.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTFontSize }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "sz", scope = CTRPrElt.class)
    public JAXBElement<CTFontSize> createCTRPrEltSz(CTFontSize value) {
        return new JAXBElement<CTFontSize>(_CTFontSz_QNAME, CTFontSize.class, CTRPrElt.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTUnderlineProperty }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "u", scope = CTRPrElt.class)
    public JAXBElement<CTUnderlineProperty> createCTRPrEltU(CTUnderlineProperty value) {
        return new JAXBElement<CTUnderlineProperty>(_CTFontU_QNAME, CTUnderlineProperty.class, CTRPrElt.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTBooleanProperty }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "strike", scope = CTRPrElt.class)
    public JAXBElement<CTBooleanProperty> createCTRPrEltStrike(CTBooleanProperty value) {
        return new JAXBElement<CTBooleanProperty>(_CTFontStrike_QNAME, CTBooleanProperty.class, CTRPrElt.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTVerticalAlignFontProperty }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "vertAlign", scope = CTRPrElt.class)
    public JAXBElement<CTVerticalAlignFontProperty> createCTRPrEltVertAlign(CTVerticalAlignFontProperty value) {
        return new JAXBElement<CTVerticalAlignFontProperty>(_CTFontVertAlign_QNAME, CTVerticalAlignFontProperty.class, CTRPrElt.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTIntProperty }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "family", scope = CTRPrElt.class)
    public JAXBElement<CTIntProperty> createCTRPrEltFamily(CTIntProperty value) {
        return new JAXBElement<CTIntProperty>(_CTFontFamily_QNAME, CTIntProperty.class, CTRPrElt.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTBooleanProperty }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "shadow", scope = CTRPrElt.class)
    public JAXBElement<CTBooleanProperty> createCTRPrEltShadow(CTBooleanProperty value) {
        return new JAXBElement<CTBooleanProperty>(_CTFontShadow_QNAME, CTBooleanProperty.class, CTRPrElt.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTColor }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "color", scope = CTRPrElt.class)
    public JAXBElement<CTColor> createCTRPrEltColor(CTColor value) {
        return new JAXBElement<CTColor>(_CTFontColor_QNAME, CTColor.class, CTRPrElt.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTFontScheme }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "scheme", scope = CTRPrElt.class)
    public JAXBElement<CTFontScheme> createCTRPrEltScheme(CTFontScheme value) {
        return new JAXBElement<CTFontScheme>(_CTFontScheme_QNAME, CTFontScheme.class, CTRPrElt.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTIntProperty }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "charset", scope = CTRPrElt.class)
    public JAXBElement<CTIntProperty> createCTRPrEltCharset(CTIntProperty value) {
        return new JAXBElement<CTIntProperty>(_CTFontCharset_QNAME, CTIntProperty.class, CTRPrElt.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTBooleanProperty }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "i", scope = CTRPrElt.class)
    public JAXBElement<CTBooleanProperty> createCTRPrEltI(CTBooleanProperty value) {
        return new JAXBElement<CTBooleanProperty>(_CTFontI_QNAME, CTBooleanProperty.class, CTRPrElt.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTBooleanProperty }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "outline", scope = CTRPrElt.class)
    public JAXBElement<CTBooleanProperty> createCTRPrEltOutline(CTBooleanProperty value) {
        return new JAXBElement<CTBooleanProperty>(_CTFontOutline_QNAME, CTBooleanProperty.class, CTRPrElt.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTBooleanProperty }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "extend", scope = CTRPrElt.class)
    public JAXBElement<CTBooleanProperty> createCTRPrEltExtend(CTBooleanProperty value) {
        return new JAXBElement<CTBooleanProperty>(_CTFontExtend_QNAME, CTBooleanProperty.class, CTRPrElt.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTFontName }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "rFont", scope = CTRPrElt.class)
    public JAXBElement<CTFontName> createCTRPrEltRFont(CTFontName value) {
        return new JAXBElement<CTFontName>(_CTRPrEltRFont_QNAME, CTFontName.class, CTRPrElt.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTBooleanProperty }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/spreadsheetml/2006/main", name = "b", scope = CTRPrElt.class)
    public JAXBElement<CTBooleanProperty> createCTRPrEltB(CTBooleanProperty value) {
        return new JAXBElement<CTBooleanProperty>(_CTFontB_QNAME, CTBooleanProperty.class, CTRPrElt.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTDataValidations_legacy }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.microsoft.com/office/spreadsheetml/2009/9/main", name = "dataValidations")
    public JAXBElement<CTDataValidations_legacy> createCTDataValidations_legacy(CTDataValidations_legacy value) {
        return new JAXBElement<CTDataValidations_legacy>(_CTDataValidations_legacy_QNAME, CTDataValidations_legacy.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTDataValidations_legacy }{@code >}}
     *
     */
    @XmlElementDecl(namespace = "http://schemas.microsoft.com/office/spreadsheetml/2009/9/main", name = "dataValidation")
    public JAXBElement<CTDataValidation_legacy> createCTDataValidations_legacy(CTDataValidation_legacy value) {
        return new JAXBElement<CTDataValidation_legacy>(_CTDataValidation_legacy_QNAME, CTDataValidation_legacy.class, null, value);
    }

    public CTDataValidationFormula_legacy createCTDataValidationFormula_legacy() {
        return new CTDataValidationFormula_legacy();
    }

}
