/*
 *  Copyright 2007-2008, Plutext Pty Ltd.
 *
 *  This file is part of docx4j.

    docx4j is licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.

    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

 */


package org.docx4j.dml.spreadsheetdrawing;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.docx4j.dml.CTPositiveSize2D;
import org.docx4j.jaxb.Context;


/**
 * <p>Java class for CT_OneCellAnchor complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType name="CT_OneCellAnchor">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="from" type="{http://schemas.openxmlformats.org/drawingml/2006/spreadsheetDrawing}CT_Marker"/>
 *         &lt;element name="ext" type="{http://schemas.openxmlformats.org/drawingml/2006/main}CT_PositiveSize2D"/>
 *         &lt;group ref="{http://schemas.openxmlformats.org/drawingml/2006/spreadsheetDrawing}EG_ObjectChoices"/>
 *         &lt;element name="clientData" type="{http://schemas.openxmlformats.org/drawingml/2006/spreadsheetDrawing}CT_AnchorClientData"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 *
 *
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "CT_OneCellAnchor", propOrder = {
    "from",
    "ext",
    "sp",
    "grpSp",
    "graphicFrame",
    "cxnSp",
    "pic",
    "clientData"
})
public class CTOneCellAnchor implements CellAnchor {

    @XmlElement(required = true)
    protected CTMarker from;
    @XmlElement(required = true)
    protected CTPositiveSize2D ext;
    protected CTShape sp;
    protected CTGroupShape grpSp;
    protected CTGraphicalObjectFrame graphicFrame;
    protected CTConnector cxnSp;
    protected CTPicture pic;
    @XmlElement(required = true)
    protected CTAnchorClientData clientData;

    /**
     * Gets the value of the from property.
     *
     * @return
     *     possible object is
     *     {@link CTMarker }
     *
     */
    public CTMarker getFrom(boolean forceCreate) {
        if(from==null&&forceCreate) {
            from = Context.getDmlSpreadsheetDrawingObjectFactory().createCTMarker();
        }
        return from;
    }

    /**
     * Sets the value of the from property.
     *
     * @param value
     *     allowed object is
     *     {@link CTMarker }
     *
     */
    public void setFrom(CTMarker value) {
        this.from = value;
    }

    /**
     * Gets the value of the ext property.
     *
     * @return
     *     possible object is
     *     {@link CTPositiveSize2D }
     *
     */
    public CTPositiveSize2D getExt(boolean forceCreate) {
        if(ext==null&&forceCreate) {
            ext = Context.getDmlObjectFactory().createCTPositiveSize2D();
        }
        return ext;
    }

    /**
     * Sets the value of the ext property.
     *
     * @param value
     *     allowed object is
     *     {@link CTPositiveSize2D }
     *
     */
    public void setExt(CTPositiveSize2D value) {
        this.ext = value;
    }

    /**
     * Gets the value of the sp property.
     *
     * @return
     *     possible object is
     *     {@link CTShape }
     *
     */
    @Override
    public CTShape getSp() {
        return sp;
    }

    /**
     * Sets the value of the sp property.
     *
     * @param value
     *     allowed object is
     *     {@link CTShape }
     *
     */
    @Override
    public void setSp(CTShape value) {
        this.sp = value;
    }

    /**
     * Gets the value of the grpSp property.
     *
     * @return
     *     possible object is
     *     {@link CTGroupShape }
     *
     */
    @Override
    public CTGroupShape getGrpSp() {
        return grpSp;
    }

    /**
     * Sets the value of the grpSp property.
     *
     * @param value
     *     allowed object is
     *     {@link CTGroupShape }
     *
     */
    @Override
    public void setGrpSp(CTGroupShape value) {
        this.grpSp = value;
    }

    /**
     * Gets the value of the graphicFrame property.
     *
     * @return
     *     possible object is
     *     {@link CTGraphicalObjectFrame }
     *
     */
    @Override
    public CTGraphicalObjectFrame getGraphicFrame() {
        return graphicFrame;
    }

    /**
     * Sets the value of the graphicFrame property.
     *
     * @param value
     *     allowed object is
     *     {@link CTGraphicalObjectFrame }
     *
     */
    @Override
    public void setGraphicFrame(CTGraphicalObjectFrame value) {
        this.graphicFrame = value;
    }

    /**
     * Gets the value of the cxnSp property.
     *
     * @return
     *     possible object is
     *     {@link CTConnector }
     *
     */
    @Override
    public CTConnector getCxnSp() {
        return cxnSp;
    }

    /**
     * Sets the value of the cxnSp property.
     *
     * @param value
     *     allowed object is
     *     {@link CTConnector }
     *
     */
    @Override
    public void setCxnSp(CTConnector value) {
        this.cxnSp = value;
    }

    /**
     * Gets the value of the pic property.
     *
     * @return
     *     possible object is
     *     {@link CTPicture }
     *
     */
    @Override
    public CTPicture getPic() {
        return pic;
    }

    /**
     * Sets the value of the pic property.
     *
     * @param value
     *     allowed object is
     *     {@link CTPicture }
     *
     */
    @Override
    public void setPic(CTPicture value) {
        this.pic = value;
    }

    /**
     * Gets the value of the clientData property.
     *
     * @return
     *     possible object is
     *     {@link CTAnchorClientData }
     *
     */
    @Override
    public CTAnchorClientData getClientData() {
        return clientData;
    }

    /**
     * Sets the value of the clientData property.
     *
     * @param value
     *     allowed object is
     *     {@link CTAnchorClientData }
     *
     */
    @Override
    public void setClientData(CTAnchorClientData value) {
        this.clientData = value;
    }

}
