
package org.docx4j.dml.chart.chartStyle;

import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.docx4j.dml.CTSchemeColor;
import org.json.JSONException;
import org.json.JSONObject;
import com.openexchange.office.ooxml.tools.json.JSONAble;
import com.openexchange.office.ooxml.tools.json.JSONHelper;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "colorStyle")
@XmlType(propOrder = { "id", "meth", "schemeClr", "variation" })
public class CTChartColor implements JSONAble {

    @XmlAttribute
    protected long id;

    @XmlAttribute
    protected String meth;

    @XmlElement(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main")
    protected List<CTSchemeColor> schemeClr;

    protected List<CTSchemeColor> variation;

    @Override
    public JSONObject toJSON() throws JSONException {
        JSONObject res = new JSONObject();

        res.put("id", id);
        res.put("meth", meth);
        res.put("schemeClr", JSONHelper.toJSONArray(schemeClr));
        res.put("variation", JSONHelper.toJSONArray(variation));

        return res;
    }

}
