/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.json.actions;

import org.json.JSONException;
import org.json.JSONObject;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.session.ServerSession;
//import com.openexchange.office.calcengine.*;;

/**
 * {@link UpdateViewAction}
 *
 * @author <a href="mailto:ingo.schmidt-rosbiegal@open-xchange.com">Ingo Schmidt-Rosbiegal</a>
 */
@Action(method = RequestMethod.POST, name = "updateview", description = "Request for updating the view with calculated data from the calc engine.", parameters = {
    @Parameter(name = "session", description = "A session ID previously obtained from the login module."),
    @Parameter(name = "id", description = "Object ID of the requested infoitem."),
    @Parameter(name = "folder_id", description = "Folder ID of the requested infoitem."),
    @Parameter(name = "uid", description = "The unique id of the client application."),
    @Parameter(name = "version", optional=true, description = "If present, the infoitem data describes the given version. Otherwise the current version is returned."),
    @Parameter(name = "requestdata", description = "The object describing the visible part in the browser, including sheet number, pane description and selection.")
}, responseDescription = "Response with timestamp: A JSON object containing the actual spreadsheet data, that are displayed in the spreadsheet client.")

public class UpdateViewAction extends DocumentFilterAction {

    /**
     * Initializes a new {@link UpdateViewAction}.
     *
     * @param services
     */
    public UpdateViewAction(ServiceLookup services) {

        super(services);
    }

    /**
     * Calculating the cell content for a given view update request.
     *
     * @param {JSONObject} requestData
     *  The view update request.
     *
     * @returns {JSONObject}
     *  The calculated view update response for a given view update request.
     */
    protected JSONObject getResultDataFromRequestData(AJAXRequestData request, ServerSession session) throws JSONException {
        JSONObject requestData = new JSONObject(request.getParameter("requestdata"));
        JSONObject updateViewResult = sendConnectionMessageSynchronously(request, session, "updateView", "spreadsheet", requestData);
    	return updateViewResult;
    }

	/*
     * (non-Javadoc)
     * @see com.openexchange.ajax.requesthandler.AJAXActionService#perform(com.openexchange.ajax.requesthandler.AJAXRequestData,
     * com.openexchange.tools.session.ServerSession)
     */
    @Override
    public AJAXRequestResult perform(AJAXRequestData request, ServerSession session) {
        JSONObject resultData = null;
        AJAXRequestResult ajaxResult = null;

        try {
            resultData = getResultDataFromRequestData(request, session);
        } catch (JSONException e) {
            //
        }

        ajaxResult = getAjaxRequestResult(resultData);

        return ajaxResult;
    }
}
